/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.diplomacy.TeamInstance;
import CoroUtil.diplomacy.TeamTypes;
import CoroUtil.entity.EnumActState;
import CoroUtil.entity.EnumJobState;
import CoroUtil.formation.Formation;
import CoroUtil.inventory.AIInventory;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.CoroUtilNBT;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.location.ManagedLocation;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class AIAgent {
    public EntityLiving ent;
    public ICoroAI entInt;
    public AIInventory entInv;
    public boolean useInv = false;
    public JobManager jobMan;
    public Formation activeFormation;
    public boolean pathAvailable;
    public boolean pathRequested;
    public PathEntity pathToEntity;
    public Entity entityToAttack;
    public Entity retaliateEntity;
    public boolean retaliateEnable = true;
    public int retaliateTicks = 0;
    public int retaliateTicksMax = 400;
    public int curCooldown_Melee;
    public int curCooldown_Ranged;
    public float maxReach_Melee = 1.8f;
    public float maxReach_Ranged = 10.0f;
    public boolean rangedInUse = false;
    public boolean rangedAimWhileInUse = false;
    public boolean meleeOverridesRangedInUse = true;
    public boolean meleeUseRightClick = false;
    public boolean canJoinFormations = false;
    public long checkAreaDelay;
    public long checkRange = 16L;
    public int dangerLevel = 0;
    public boolean fleeing = false;
    public Entity lastFleeEnt;
    public Vec3 lastSafeSpot;
    public boolean wasInLava = false;
    public boolean enhanceAIEnemies = false;
    public int enhancedAIDelay = 100;
    public int maxPFRange = 32;
    public int PFRangeClose = 22;
    public int PFRangeFormation = 22;
    public int PFRangePathing = 32;
    public float collideResistClose = 0.2f;
    public float collideResistFormation = 0.5f;
    public float collideResistPathing = 0.8f;
    public Random rand;
    public int openedChest = 0;
    public float oldMoveSpeed;
    private float fleeSpeed = 0.33f;
    private float moveSpeed = 0.28f;
    public float lungeFactor = 1.0f;
    public int entID = -1;
    public EnumActState currentAction;
    public boolean shouldFixBadYPathing = true;
    public boolean shouldPathfollow = true;
    public boolean shouldHeal = true;
    public int curCooldown_Heal;
    public int cooldown_Heal = 60;
    public int noMoveTicks = 0;
    public Vec3 prevPos = null;
    public int moveLeadTicks = 10;
    public float moveLeadFactorDist = 2.0f;
    public boolean shouldAvoid = true;
    public boolean useCustomMovement = false;
    public int homeX;
    public int homeY = -1;
    public int homeZ;
    public boolean scanForHomeChest = false;
    public int targX;
    public int targY;
    public int targZ;
    public double maxDistanceFromHome = 96.0;
    public boolean facingWater = false;
    public boolean wasInWater = false;
    public ChunkCoordinates coordsManagedLocation;
    public int locationMemberID = -1;
    public boolean dipl_hostilePlayer = false;
    public TeamInstance dipl_info = TeamTypes.getType("neutral");
    public int dipl_spreadInfoDelay = 0;
    public boolean hasBeenSpawnedOrNBTInitialized = false;
    public boolean waitingToMakeFakePlayer = false;
    public int lastMovementState = -1;
    public static final UUID uuid = UUID.randomUUID();
    public static AttributeModifier speedBoostFlee = new AttributeModifier(uuid, "Speed boost flee", 0.45, 0).func_111168_a(false);
    public static AttributeModifier speedBoostAttack = new AttributeModifier(uuid, "Speed boost attack", 0.45, 0).func_111168_a(false);
    public boolean swingArm;
    public int swingTick;
    private int tickAge;
    private int tickDespawn;

    public AIAgent(ICoroAI parEnt, boolean useInventory) {
        this.ent = (EntityLiving)parEnt;
        this.entInt = parEnt;
        this.useInv = useInventory;
        this.entInv = new AIInventory((EntityLivingBase)this.ent);
        this.jobMan = new JobManager(this);
        this.rand = new Random();
        this.setState(EnumActState.IDLE);
        if (this.entID == -1) {
            this.entID = this.rand.nextInt(999999999);
        }
    }

    public void applyEntityAttributes() {
        this.ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
    }

    public void attrRemoveSpeeds() {
        IAttributeInstance attributeinstance = this.ent.func_110148_a(SharedMonsterAttributes.field_111263_d);
        attributeinstance.func_111124_b(speedBoostAttack);
        attributeinstance.func_111124_b(speedBoostFlee);
    }

    public void attrSetSpeedFlee() {
        this.attrRemoveSpeeds();
        IAttributeInstance attributeinstance = this.ent.func_110148_a(SharedMonsterAttributes.field_111263_d);
        attributeinstance.func_111121_a(speedBoostFlee);
    }

    public void attrSetSpeedAttack() {
        this.attrRemoveSpeeds();
        IAttributeInstance attributeinstance = this.ent.func_110148_a(SharedMonsterAttributes.field_111263_d);
        attributeinstance.func_111121_a(speedBoostAttack);
    }

    public void attrSetSpeedNormal() {
        this.attrRemoveSpeeds();
    }

    public void setSpeedFleeAdditive(float speed) {
        this.fleeSpeed = speed;
        speedBoostFlee = new AttributeModifier(uuid, "Speed boost flee", (double)this.fleeSpeed, 0).func_111168_a(false);
    }

    public void setSpeedAttackAdditive(float speed) {
        speedBoostAttack = new AttributeModifier(uuid, "Speed boost attack", (double)speed, 0).func_111168_a(false);
    }

    public void setSpeedNormalBase(float var) {
        this.moveSpeed = var;
    }

    public void setTeam(String parTeam) {
        this.dipl_info = TeamTypes.getType(parTeam);
    }

    public void spawnedOrNBTReloadedInit() {
        this.dbg(this.ent.func_145782_y() + " - CALLED: spawnedOrNBTReloadedInit()");
        this.hasBeenSpawnedOrNBTInitialized = true;
        this.postFullInit();
    }

    public void postFullInit() {
        ManagedLocation ml;
        if (this.homeY == -1) {
            this.homeX = (int)Math.floor(this.ent.field_70165_t);
            this.homeY = (int)Math.floor(this.ent.field_70163_u);
            this.homeZ = (int)Math.floor(this.ent.field_70161_v);
        }
        if ((ml = this.getManagedLocation()) != null) {
            ml.addEntity("member", (EntityLivingBase)this.ent);
        }
    }

    public ManagedLocation getManagedLocation() {
        if (this.coordsManagedLocation != null) {
            WorldDirector wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(this.ent.field_70170_p);
            ManagedLocation ml = wd.getTickingLocation(this.coordsManagedLocation);
            return ml;
        }
        return null;
    }

    public void setManagedLocation(ChunkCoordinates parLocation) {
        this.coordsManagedLocation = parLocation;
    }

    public void setManagedLocation(ManagedLocation parLocation) {
        this.coordsManagedLocation = parLocation.spawn;
    }

    public void setLocationMemberID(int parID) {
        this.locationMemberID = parID;
    }

    public boolean notPathing() {
        return !this.pathRequested && this.ent.func_70661_as().func_75500_f();
    }

    public void initJobs() {
    }

    public void setState(EnumActState eka) {
        this.currentAction = eka;
    }

    public void entityInit() {
        this.ent.func_70096_w().func_75682_a(22, (Object)0);
        this.ent.func_70096_w().func_75682_a(24, (Object)0);
        this.ent.func_70096_w().func_75682_a(25, (Object)0);
    }

    public int getDWonGround() {
        return this.ent.func_70096_w().func_75679_c(22);
    }

    public EnumActState getDWStateAI() {
        return EnumActState.get(this.ent.func_70096_w().func_75679_c(24));
    }

    public void swingArm() {
        this.swingArm = true;
    }

    public void onLivingUpdateTick() {
        if (this.ent.field_70170_p.field_72995_K) {
            if (this.ent.func_70096_w().func_75679_c(25) == 1) {
                this.swingArm = true;
            }
            if (this.ent.func_70096_w().func_75679_c(22) == 1) {
                this.ent.field_70181_x = 0.0;
                this.ent.field_70122_E = true;
            } else {
                this.ent.field_70181_x = 0.0;
                this.ent.field_70122_E = false;
            }
        } else {
            this.ent.func_70096_w().func_75692_b(22, (Object)(this.ent.field_70122_E ? 1 : 0));
            this.ent.func_70096_w().func_75692_b(24, (Object)this.currentAction.ordinal());
            this.ent.func_70096_w().func_75692_b(25, (Object)(this.swingArm ? 1 : 0));
            if (this.swingArm) {
                this.swingArm = false;
            }
        }
    }

    public void updateAITasks() {
        this.lastMovementState = -1;
        if (this.jobMan.getPrimaryJob() == null) {
            return;
        }
        if (this.dangerLevel != 2 && this.jobMan.getPrimaryJob().shouldTickCloseCombat()) {
            this.lastMovementState = 0;
            this.maxPFRange = this.PFRangeClose;
            this.ent.field_70144_Y = this.collideResistClose;
            this.jobMan.getPrimaryJob().onTickCloseCombat();
        } else if (this.dangerLevel != 2 && this.jobMan.getPrimaryJob().shouldTickFormation() && this.activeFormation.leader != this.entInt && !((EntityLivingBase)this.activeFormation.leader).func_70090_H()) {
            this.lastMovementState = 1;
            this.maxPFRange = this.PFRangeFormation;
            this.ent.field_70144_Y = this.collideResistFormation;
            this.jobMan.getPrimaryJob().onTickFormation();
        } else {
            this.lastMovementState = 2;
            this.maxPFRange = this.PFRangePathing;
            this.ent.field_70144_Y = this.collideResistPathing;
            if (this.shouldPathfollow) {
                this.checkPathfindLock();
                this.ent.func_70661_as().func_75501_e();
            }
        }
        if (this.lastMovementState != 1) {
            this.tickPathFollowHelp();
        }
        this.tickMovementHelp();
        this.updateAI();
        this.tickAgeEntity();
        if (this.useCustomMovement) {
            this.jobMan.priJob.tickCustomMovement();
        } else {
            this.ent.func_70605_aq().func_75641_c();
            this.ent.func_70671_ap().func_75649_a();
            this.ent.func_70683_ar().func_75661_b();
        }
    }

    public void tickAgeEntity() {
        ++this.tickAge;
        if (!this.ent.func_104002_bU()) {
            EntityPlayer entityplayer;
            this.tickDespawn = this.ent.func_70661_as().func_75500_f() || this.entityToAttack == null ? ++this.tickDespawn : 0;
            if (this.ent.field_70170_p.func_82737_E() % 20L == 0L && (entityplayer = this.ent.field_70170_p.func_72890_a((Entity)this.ent, -1.0)) != null) {
                double d0 = entityplayer.field_70165_t - this.ent.field_70165_t;
                double d1 = entityplayer.field_70163_u - this.ent.field_70163_u;
                double d2 = entityplayer.field_70161_v - this.ent.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                Random rand = new Random();
                boolean despawn = false;
                if (d3 > 128.0) {
                    despawn = true;
                }
                if (this.tickDespawn > 600) {
                    if (d3 > 32.0) {
                        despawn = true;
                    } else if (d3 < 128.0) {
                        this.tickDespawn = 0;
                    }
                }
                if (despawn) {
                    this.ent.func_70106_y();
                }
            }
        } else {
            this.tickDespawn = 0;
        }
    }

    public void tickPathFollowHelp() {
        if (this.ent.func_70090_H()) {
            if (this.ent.func_70661_as().func_75505_d() != null) {
                PathEntity pEnt = this.ent.func_70661_as().func_75505_d();
                int index = pEnt.func_75873_e() + 1;
                if (index < 0) {
                    index = 0;
                }
                if (index > pEnt.func_75874_d()) {
                    index = pEnt.func_75874_d() - 1;
                }
                Vec3 var1 = null;
                try {
                    var1 = pEnt.func_75881_a((Entity)this.ent, pEnt.func_75873_e());
                }
                catch (Exception ex) {
                    var1 = pEnt.func_75881_a((Entity)this.ent, pEnt.func_75874_d() - 1);
                }
                if (var1 != null) {
                    this.ent.func_70605_aq().func_75642_a(var1.field_72450_a, var1.field_72448_b, var1.field_72449_c, (double)0.53f);
                    double dist = this.ent.func_70011_f(var1.field_72450_a, var1.field_72448_b, var1.field_72449_c);
                    if (dist < 3.0) {
                        this.ent.func_70661_as().func_75505_d().func_75875_a();
                    }
                }
            }
            if (!this.ent.func_70661_as().func_75500_f()) {
                // empty if block
            }
        }
        if (!this.ent.func_70661_as().func_75500_f()) {
            Vec3 curPos = Vec3.func_72443_a((double)this.ent.field_70165_t, (double)this.ent.field_70163_u, (double)this.ent.field_70161_v);
            this.prevPos = this.prevPos == null ? curPos : Vec3.func_72443_a((double)this.prevPos.field_72450_a, (double)this.ent.field_70163_u, (double)this.prevPos.field_72449_c);
            this.noMoveTicks = curPos.func_72438_d(this.prevPos) < 0.01 ? ++this.noMoveTicks : 0;
            if (this.noMoveTicks > 60) {
                this.ent.func_70661_as().func_75499_g();
                this.noMoveTicks = 0;
            }
            this.prevPos = curPos;
        }
    }

    public void tickMovementHelp() {
        PathEntity pe;
        if (this.ent.func_70090_H()) {
            this.ent.field_70181_x += 0.03;
            if (Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y) > (double)0.001f && Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y) < (double)0.2f) {
                this.ent.field_70159_w *= (double)1.2f;
                this.ent.field_70179_y *= (double)1.2f;
            }
        } else if (this.ent.func_70058_J()) {
            this.ent.field_70181_x += 0.07;
            float speed = 1.2f;
            if (this.lastSafeSpot != null) {
                this.ent.func_70605_aq().func_75642_a(this.lastSafeSpot.field_72450_a, this.lastSafeSpot.field_72448_b, this.lastSafeSpot.field_72449_c, (double)speed);
            } else if (this.jobMan.getPrimaryJob().tamable.isTame() && this.jobMan.getPrimaryJob().tamable.ownerCachedInstance != null) {
                this.ent.func_70605_aq().func_75642_a(this.jobMan.getPrimaryJob().tamable.ownerCachedInstance.field_70165_t, this.jobMan.getPrimaryJob().tamable.ownerCachedInstance.field_70163_u, this.jobMan.getPrimaryJob().tamable.ownerCachedInstance.field_70161_v, (double)speed);
            }
            this.wasInLava = true;
        }
        if (this.wasInLava && !this.ent.func_70058_J()) {
            this.wasInLava = false;
            this.ent.func_70066_B();
        }
        if (!this.ent.field_70170_p.field_72995_K && (pe = this.ent.func_70661_as().func_75505_d()) != null && pe.func_75874_d() == 1 && (double)pe.func_75870_c().field_75837_b - this.ent.field_70163_u > (double)0.01f) {
            this.ent.func_70661_as().func_75499_g();
        }
        if (this.ent.field_70122_E && this.ent.func_70661_as().func_75500_f()) {
            this.lastSafeSpot = Vec3.func_72443_a((double)this.ent.field_70165_t, (double)this.ent.field_70163_u, (double)this.ent.field_70161_v);
        }
        if (this.shouldFixBadYPathing) {
            this.fixBadYPathing();
        }
    }

    public void fixBadYPathing() {
        if (this.ent.func_70661_as().func_75505_d() != null) {
            double dist;
            PathEntity pEnt = this.ent.func_70661_as().func_75505_d();
            int index = pEnt.func_75873_e();
            if (index < 0) {
                index = 0;
            }
            if (index >= pEnt.func_75874_d()) {
                index = pEnt.func_75874_d() - 1;
            }
            Vec3 var1 = null;
            try {
                var1 = pEnt.func_75881_a((Entity)this.ent, index);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("errrrrrrrrrrrrrrr");
                var1 = pEnt.func_75881_a((Entity)this.ent, pEnt.func_75874_d() - 1);
            }
            if (var1 != null && (dist = this.ent.func_70011_f(var1.field_72450_a, this.ent.field_70121_D.field_72338_b, var1.field_72449_c)) <= 0.5) {
                this.ent.func_70661_as().func_75505_d().func_75875_a();
            }
        }
    }

    public void updateHealing() {
        if (this.curCooldown_Heal > 0) {
            --this.curCooldown_Heal;
        }
        if (this.curCooldown_Heal <= 0) {
            this.curCooldown_Heal = this.cooldown_Heal;
            this.heal(1);
        }
    }

    public void heal(int val) {
        this.ent.func_70691_i((float)val);
    }

    public void updateAI() {
        if (this.jobMan.getPrimaryJob() == null) {
            return;
        }
        if (this.curCooldown_Melee > 0) {
            --this.curCooldown_Melee;
        }
        if (this.curCooldown_Ranged > 0) {
            --this.curCooldown_Ranged;
        }
        this.jobMan.getPrimaryJob().onTickChestScan();
        if (this.activeFormation != null && this.activeFormation.listEntities.size() == 0) {
            this.activeFormation = null;
        }
        if (this.retaliateTicks > 0) {
            --this.retaliateTicks;
            if (this.retaliateTicks == 0 && this.retaliateEntity != null && this.retaliateEntity == this.entityToAttack && !this.entInt.isEnemy(this.retaliateEntity)) {
                this.entityToAttack = null;
                this.retaliateEntity = null;
            }
        }
        if (this.entityToAttack != null && this.entityToAttack.func_70089_S()) {
            float var2 = this.entityToAttack.func_70032_d((Entity)this.ent);
            if (this.ent.func_70685_l(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, var2);
            }
        } else {
            this.entityToAttack = null;
        }
        if (this.shouldHeal) {
            this.updateHealing();
        }
        this.dangerLevel = 0;
        if (this.checkSurroundings() == 1) {
            this.dangerLevel = 1;
        }
        if (this.jobMan.getPrimaryJob().checkDangers()) {
            this.dangerLevel = 2;
        }
        this.jobMan.getPrimaryJob().checkHunger();
        this.fleeing = false;
        if (this.dangerLevel == 0) {
            this.jobMan.tick();
            this.attrSetSpeedNormal();
        } else if (this.dangerLevel == 1) {
            this.jobMan.tick();
            this.attrSetSpeedNormal();
        } else if (this.dangerLevel == 2) {
            if (!this.jobMan.getPrimaryJob().avoid(true) || !this.shouldAvoid) {
                this.fleeing = false;
                this.jobMan.tick();
                this.attrSetSpeedNormal();
            } else {
                this.fleeing = true;
                this.jobMan.getPrimaryJob().onLowHealth();
                this.attrSetSpeedFlee();
            }
        }
        if (this.currentAction == EnumActState.IDLE && this.jobMan.getPrimaryJob().state == EnumJobState.IDLE) {
            this.jobMan.getPrimaryJob().onIdleTick();
        } else if (this.currentAction == EnumActState.FIGHTING) {
            this.actFight();
        } else if (this.currentAction == EnumActState.WALKING) {
            this.actWalk();
        }
        this.entInv.tick();
    }

    public void actFight() {
        if (this.entityToAttack == null || this.entityToAttack.field_70128_L || this.entityToAttack == this.ent || this.entityToAttack instanceof EntityLivingBase && ((EntityLivingBase)this.entityToAttack).field_70725_aQ > 0) {
            this.entityToAttack = null;
            this.setState(EnumActState.IDLE);
        }
    }

    public void actWalk() {
        --this.jobMan.getPrimaryJob().walkingTimeout;
        if (this.ent.func_70011_f((double)this.targX, (double)this.targY, (double)this.targZ) < 2.0 || this.ent.func_70661_as().func_75505_d() == null || this.ent.func_70661_as().func_75505_d().func_75879_b()) {
            this.ent.func_70661_as().func_75499_g();
            this.setState(EnumActState.IDLE);
        } else if (this.jobMan.getPrimaryJob().walkingTimeout <= 0) {
            this.ent.func_70661_as().func_75499_g();
            this.setState(EnumActState.IDLE);
        }
    }

    public boolean checkHealth() {
        return (double)this.ent.func_110143_aJ() < (double)this.ent.func_110138_aP() * 0.75;
    }

    public int checkSurroundings() {
        if (this.checkAreaDelay < System.currentTimeMillis() && this.checkHealth()) {
            this.checkAreaDelay = System.currentTimeMillis() + 1500L + (long)this.rand.nextInt(1000);
            float closest = 9999.0f;
            Entity clEnt = null;
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)this.checkRange, (double)(this.checkRange / 2L), (double)this.checkRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (!this.jobMan.getPrimaryJob().isEnemy(entity1) || !this.ent.func_70685_l(entity1) || !((dist = this.ent.func_70032_d(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public void faceEntity(Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - this.ent.field_70165_t;
        double d1 = par1Entity.field_70161_v - this.ent.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)par1Entity;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.ent.field_70163_u + (double)this.ent.func_70047_e());
        } else {
            d2 = (par1Entity.field_70121_D.field_72338_b + par1Entity.field_70121_D.field_72337_e) / 2.0 - (this.ent.field_70163_u + (double)this.ent.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.ent.field_70125_A = this.updateRotation(this.ent.field_70125_A, f3, par3);
        this.ent.field_70177_z = this.updateRotation(this.ent.field_70177_z, f2, par2);
    }

    protected void attackEntity(Entity var1, float var2) {
        float prevRotYaw = this.ent.field_70177_z;
        float prevRotPitch = this.ent.field_70125_A;
        if ((!this.rangedInUse || this.meleeOverridesRangedInUse) && var2 < this.maxReach_Melee && var1.field_70121_D.field_72337_e > this.ent.field_70121_D.field_72338_b && var1.field_70121_D.field_72338_b < this.ent.field_70121_D.field_72337_e) {
            if (this.curCooldown_Melee <= 0) {
                if (this.rangedInUse) {
                    this.rangedUsageCancelCharge();
                }
                this.ent.func_70625_a(var1, 180.0f, 180.0f);
                if (!this.meleeUseRightClick) {
                    if (this.useInv) {
                        this.entInv.attackMelee(var1, var2);
                    } else {
                        this.entInt.attackMelee(var1, var2);
                    }
                } else if (this.useInv) {
                    if (this.entInv.inventory == null) {
                        return;
                    }
                    this.faceEntity((Entity)this.ent, 180.0f, 180.0f);
                    this.entInv.setSlotActive(AIInventory.slot_Melee);
                    this.entInv.performRightClick();
                } else {
                    this.entInt.attackRanged(var1, var2);
                }
                this.curCooldown_Melee = this.entInt.getCooldownMelee();
            }
        } else if (!this.rangedInUse && var2 < this.maxReach_Ranged && this.curCooldown_Ranged <= 0 && (float)this.curCooldown_Melee < this.maxReach_Melee - this.maxReach_Melee / 4.0f) {
            this.ent.func_70625_a(var1, 180.0f, 180.0f);
            if (this.useInv) {
                this.entInv.attackRanged(var1, var2);
            } else {
                this.entInt.attackRanged(var1, var2);
            }
            this.curCooldown_Ranged = this.entInt.getCooldownRanged();
        }
        this.ent.field_70177_z = prevRotYaw;
        this.ent.field_70125_A = prevRotPitch;
    }

    public void rangedUsageUpdate(Entity ent, float dist) {
        this.rangedUsageCancelCharge();
    }

    public void rangedUsageStartCharge() {
        this.rangedInUse = true;
    }

    public void rangedUsageCancelCharge() {
        this.rangedInUse = false;
        this.curCooldown_Ranged = this.entInt.getCooldownRanged();
    }

    public void updateWanderPath() {
        boolean flag = false;
        int i = -1;
        int j = -1;
        int k = -1;
        float f = -99999.0f;
        for (int l = 0; l < 10; ++l) {
            int i1 = MathHelper.func_76128_c((double)(this.ent.field_70165_t + (double)this.rand.nextInt(13) - 6.0));
            int j1 = MathHelper.func_76128_c((double)(this.ent.field_70163_u + (double)this.rand.nextInt(7) - 3.0));
            int k1 = MathHelper.func_76128_c((double)(this.ent.field_70161_v + (double)this.rand.nextInt(13) - 6.0));
            float f1 = 1.0f;
            if (!(f1 > f)) continue;
            f = f1;
            i = i1;
            j = j1;
            k = k1;
            flag = true;
        }
        if (flag) {
            this.walkTo((Entity)this.ent, i, j, k, this.maxPFRange, 600);
        }
    }

    public void checkPathfindLock() {
        if (this.pathAvailable) {
            this.ent.func_70661_as().func_75499_g();
            this.ent.func_70661_as().func_75484_a(this.pathToEntity, (double)OldUtil.getMoveSpeed((EntityLivingBase)this.ent));
            this.pathAvailable = false;
            this.pathRequested = false;
        }
    }

    public void setPathToEntity(PathEntity pathentity) {
        this.jobMan.getPrimaryJob().setPathToEntity(pathentity);
    }

    public void setPathToEntityForce(PathEntity pathentity) {
        this.pathToEntity = pathentity;
        this.pathAvailable = true;
    }

    public void walkTo(Entity var1, ChunkCoordinates coords, float var2, int timeout) {
        this.walkTo(var1, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, var2, timeout, 0);
    }

    public void walkTo(Entity var1, int x, int y, int z, float var2, int timeout) {
        this.walkTo(var1, x, y, z, var2, timeout, 0);
    }

    public void walkTo(Entity var1, int x, int y, int z, float var2, int timeout, int priority) {
        this.pathRequested = true;
        PFQueue.getPath((Entity)this.ent, x, y, z, var2, priority);
        this.setState(EnumActState.WALKING);
        this.jobMan.getPrimaryJob().walkingTimeout = timeout;
        this.targX = x;
        this.targY = y;
        this.targZ = z;
    }

    public void walkToMark(Entity var1, PathEntity pe, int timeout) {
        this.setState(EnumActState.WALKING);
        this.jobMan.getPrimaryJob().walkingTimeout = timeout;
        this.targX = pe.func_75870_c().field_75839_a;
        this.targY = pe.func_75870_c().field_75837_b;
        this.targZ = pe.func_75870_c().field_75838_c;
    }

    public void walkToMark(Entity var1, ChunkCoordinates coords, int timeout) {
        this.setState(EnumActState.WALKING);
        this.jobMan.getPrimaryJob().walkingTimeout = timeout;
        this.targX = coords.field_71574_a;
        this.targY = coords.field_71572_b;
        this.targZ = coords.field_71573_c;
    }

    public void setTargetRetaliate(Entity targ) {
        this.setTarget(targ);
        this.retaliateEntity = targ;
        this.retaliateTicks = this.retaliateTicksMax;
    }

    public void setTarget(Entity parEnt) {
        this.entityToAttack = parEnt;
        if (this.jobMan.getPrimaryJob().isInFormation() && this.activeFormation.leaderTarget == null && parEnt instanceof EntityLivingBase) {
            this.activeFormation.leaderTarget = (EntityLivingBase)parEnt;
        }
        this.setState(EnumActState.FIGHTING);
    }

    public void huntTarget(Entity parEnt, int pri) {
        boolean isLeader;
        boolean bl = isLeader = this.jobMan.getPrimaryJob().isInFormation() && this.activeFormation.leader == this.entInt;
        if (this.lastMovementState == 2 || isLeader) {
            this.pathRequested = true;
            PFQueue.getPath((Entity)this.ent, parEnt, this.maxPFRange, pri);
        }
        this.setTarget(parEnt);
    }

    public void huntTarget(Entity parEnt) {
        this.huntTarget(parEnt, 0);
    }

    public void moveTo(ChunkCoordinates coords) {
        PFQueue.getPath((Entity)this.ent, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, this.maxPFRange, 0);
        this.walkToMark(null, coords, 600);
    }

    public void faceCoord(ChunkCoordinates coord, float f, float f1) {
        this.faceCoord(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, f, f1);
    }

    public void faceCoord(int x, int y, int z, float f, float f1) {
        double d = (double)((float)x + 0.5f) - this.ent.field_70165_t;
        double d2 = (double)((float)z + 0.5f) - this.ent.field_70161_v;
        double d1 = (double)((float)y + 0.5f) - (this.ent.field_70163_u + (double)this.ent.func_70047_e());
        double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
        this.ent.field_70125_A = -this.updateRotation(this.ent.field_70125_A, f3, f1);
        this.ent.field_70177_z = this.updateRotation(this.ent.field_70177_z, f2, f);
    }

    public float updateRotation(float f, float f1, float f2) {
        float f3;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public MovingObjectPosition rayTrace(double reachDist, float yOffset, Vec3 randLook) {
        float partialTick = 1.0f;
        Vec3 var4 = Vec3.func_72443_a((double)this.ent.field_70165_t, (double)(this.ent.field_70163_u + (double)yOffset), (double)this.ent.field_70161_v);
        Vec3 var5 = this.ent.func_70676_i(partialTick);
        if (randLook != null) {
            var5.func_72441_c(randLook.field_72450_a, randLook.field_72448_b, randLook.field_72449_c);
        }
        Vec3 var6 = var4.func_72441_c(var5.field_72450_a * reachDist, var5.field_72448_b * reachDist, var5.field_72449_c * reachDist);
        return this.ent.field_70170_p.func_72933_a(var4, var6);
    }

    public boolean isInFormation() {
        return this.jobMan.getPrimaryJob().isInFormation();
    }

    public void readEntityFromNBT(NBTTagCompound var1) {
        this.entInv.nbtRead(var1.func_74775_l("inventory"));
        this.entID = var1.func_74762_e("ICoroAI_entID");
        this.locationMemberID = var1.func_74762_e("locationMemberID");
        this.homeX = var1.func_74762_e("homeX");
        this.homeY = var1.func_74762_e("homeY");
        this.homeZ = var1.func_74762_e("homeZ");
        String tameName = var1.func_74779_i("tamedByUser");
        if (!tameName.equals("")) {
            this.jobMan.getPrimaryJob().tamable.tameBy(tameName);
        }
        if (var1.func_74764_b("coordsManagedLocationX")) {
            this.coordsManagedLocation = CoroUtilNBT.readCoords("coordsManagedLocation", var1);
        }
        this.spawnedOrNBTReloadedInit();
    }

    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.func_74782_a("inventory", (NBTBase)this.entInv.nbtWrite());
        var1.func_74768_a("ICoroAI_entID", this.entID);
        var1.func_74768_a("locationMemberID", this.locationMemberID);
        var1.func_74768_a("homeX", this.homeX);
        var1.func_74768_a("homeY", this.homeY);
        var1.func_74768_a("homeZ", this.homeZ);
        var1.func_74778_a("tamedByUser", this.jobMan.getPrimaryJob().tamable.owner);
        if (this.coordsManagedLocation != null) {
            CoroUtilNBT.writeCoords("coordsManagedLocation", this.coordsManagedLocation, var1);
        }
    }

    public boolean hookHit(DamageSource par1DamageSource, int par2) {
        if (!this.ent.field_70170_p.field_72995_K) {
            return this.jobMan.hookHit(par1DamageSource, par2);
        }
        return true;
    }

    public boolean hookInteract(EntityPlayer par1EntityPlayer) {
        if (!this.ent.field_70170_p.field_72995_K) {
            return this.jobMan.hookInteract(par1EntityPlayer);
        }
        return false;
    }

    public void hookSetDead() {
        WorldDirector wd;
        ManagedLocation ml;
        if (!this.ent.field_70170_p.field_72995_K && this.coordsManagedLocation != null && (ml = (wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(this.ent.field_70170_p)).getTickingLocation(this.coordsManagedLocation)) != null) {
            ml.hookEntityDied((EntityLivingBase)this.ent);
        }
    }

    public boolean isThreat(Entity ent) {
        return ent instanceof EntityCreeper || ent instanceof EntityEnderman;
    }

    public void dbg(Object obj) {
    }

    public void cleanup() {
        WorldDirector wd;
        ManagedLocation ml;
        this.entInv.cleanup();
        PFQueue.pfDelays.remove(this.ent);
        if (this.coordsManagedLocation != null && (ml = (wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(this.ent.field_70170_p)).getTickingLocation(this.coordsManagedLocation)) != null) {
            ml.hookEntityDestroyed((EntityLivingBase)this.ent);
        }
        this.jobMan.cleanup();
        this.ent = null;
        this.entInt.cleanup();
        this.entInt = null;
        this.entInv = null;
        this.jobMan = null;
        this.activeFormation = null;
        this.retaliateEntity = null;
        this.entityToAttack = null;
    }
}

