/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.inventory;

import java.util.concurrent.Callable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ReportedException;

public class InventoryWrapper
implements IInventory {
    public ItemStack[] invList;
    public boolean inventoryChanged = true;
    public String username;

    public void invInitData(NBTTagList stacks, int bufferSize) {
        this.invList = new ItemStack[bufferSize];
        for (int i = 0; i < stacks.func_74745_c(); ++i) {
            NBTTagCompound tag = stacks.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.invList.length) continue;
            this.invList[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void invInitData(ItemStack[] stacks) {
        this.invList = stacks;
    }

    public NBTTagList invWriteTagList() {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.invList.length; ++i) {
            ItemStack stack = this.invList[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        return itemList;
    }

    public int func_70302_i_() {
        return this.invList.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.invList.length) {
            return this.invList[i];
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.invList[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public String func_145825_b() {
        return "Inventory Wrapper";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70296_d() {
        this.inventoryChanged = true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean addItemStackToInventory(final ItemStack p_70441_1_) {
        if (p_70441_1_ != null && p_70441_1_.field_77994_a != 0 && p_70441_1_.func_77973_b() != null) {
            try {
                int i;
                if (p_70441_1_.func_77951_h()) {
                    int i2 = this.getFirstEmptyStack();
                    if (i2 >= 0) {
                        this.invList[i2] = ItemStack.func_77944_b((ItemStack)p_70441_1_);
                        this.invList[i2].field_77992_b = 5;
                        p_70441_1_.field_77994_a = 0;
                        return true;
                    }
                    return false;
                }
                do {
                    i = p_70441_1_.field_77994_a;
                    p_70441_1_.field_77994_a = this.storePartialItemStack(p_70441_1_);
                } while (p_70441_1_.field_77994_a > 0 && p_70441_1_.field_77994_a < i);
                return p_70441_1_.field_77994_a < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)p_70441_1_.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)p_70441_1_.func_77960_j());
                crashreportcategory.func_71500_a("Item name", new Callable(){
                    private static final String __OBFID = "CL_00001710";

                    public String call() {
                        return p_70441_1_.func_82833_r();
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.invList.length; ++i) {
            if (this.invList[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int storeItemStack(ItemStack p_70432_1_) {
        for (int i = 0; i < this.invList.length; ++i) {
            if (this.invList[i] == null || this.invList[i].func_77973_b() != p_70432_1_.func_77973_b() || !this.invList[i].func_77985_e() || this.invList[i].field_77994_a >= this.invList[i].func_77976_d() || this.invList[i].field_77994_a >= this.func_70297_j_() || this.invList[i].func_77981_g() && this.invList[i].func_77960_j() != p_70432_1_.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.invList[i], (ItemStack)p_70432_1_)) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack p_70452_1_) {
        Item item = p_70452_1_.func_77973_b();
        int i = p_70452_1_.field_77994_a;
        if (p_70452_1_.func_77976_d() == 1) {
            int j = this.getFirstEmptyStack();
            if (j < 0) {
                return i;
            }
            if (this.invList[j] == null) {
                this.invList[j] = ItemStack.func_77944_b((ItemStack)p_70452_1_);
            }
            return 0;
        }
        int j = this.storeItemStack(p_70452_1_);
        if (j < 0) {
            j = this.getFirstEmptyStack();
        }
        if (j < 0) {
            return i;
        }
        if (this.invList[j] == null) {
            this.invList[j] = new ItemStack(item, 0, p_70452_1_.func_77960_j());
            if (p_70452_1_.func_77942_o()) {
                this.invList[j].func_77982_d((NBTTagCompound)p_70452_1_.func_77978_p().func_74737_b());
            }
        }
        int k = i;
        if (i > this.invList[j].func_77976_d() - this.invList[j].field_77994_a) {
            k = this.invList[j].func_77976_d() - this.invList[j].field_77994_a;
        }
        if (k > this.func_70297_j_() - this.invList[j].field_77994_a) {
            k = this.func_70297_j_() - this.invList[j].field_77994_a;
        }
        if (k == 0) {
            return i;
        }
        this.invList[j].field_77994_a += k;
        this.invList[j].field_77992_b = 5;
        return i -= k;
    }
}

