/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.location;

import CoroUtil.forge.CoroAI;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.location.SpawnLocationData;
import CoroUtil.world.location.StructureObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ManagedLocation {
    public int locationID = -1;
    public int dimID;
    public ChunkCoordinates spawn;
    public boolean hasInit = false;
    public List<EntityLivingBase> listLoadedEntities = new ArrayList<EntityLivingBase>();
    public List<UUID> listPersistantEntities = new ArrayList<UUID>();
    public HashMap<Long, Object> lookupIDToTownObject = new HashMap();
    public int lastTownObjectIDSet = 1;
    public List<SpawnLocationData> listSpawnLocations = new ArrayList<SpawnLocationData>();

    public void initData(int parLocation, int parDim, ChunkCoordinates parCoords) {
        this.locationID = parLocation;
        this.dimID = parDim;
        this.spawn = parCoords;
    }

    public void initFirstTime() {
    }

    public void tickUpdate() {
        if (this.getWorld().func_82737_E() % 100L == 0L) {
            this.tickMonitorPersistantMembers();
        }
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimID);
    }

    public void addTownObject(StructureObject bb) {
        this.lookupIDToTownObject.put(bb.ID, bb);
    }

    public void removeObject(Object obj) {
        System.out.println("removing object: " + obj);
        if (obj instanceof EntityLivingBase) {
            this.listLoadedEntities.remove(obj);
        }
        if (!(obj instanceof EntityLivingBase)) {
            this.lookupIDToTownObject.remove(obj);
        }
    }

    public void hookEntityDied(EntityLivingBase ent) {
        System.out.println("hook entity died: " + ent);
        this.removeObject(ent);
        this.listPersistantEntities.remove(ent.getPersistentID());
    }

    public void hookEntityDestroyed(EntityLivingBase ent) {
        System.out.println("hook entity obj destroyed: " + ent);
        this.removeObject(ent);
    }

    public void addEntity(String unitType, EntityLivingBase ent) {
        if (this.listLoadedEntities.contains(ent)) {
            CoroAI.dbg("WARNING: adding already existing entity to ManagedLocation");
        } else {
            this.listLoadedEntities.add(ent);
        }
        if (!this.listPersistantEntities.contains(ent.getPersistentID())) {
            this.listPersistantEntities.add(ent.getPersistentID());
        }
    }

    public void registerSpawnLocation(SpawnLocationData parData) {
        this.listSpawnLocations.add(parData);
    }

    public void registerSpawnLocation(ChunkCoordinates parCoords, String ... types) {
        for (int i = 0; i < types.length; ++i) {
            this.listSpawnLocations.add(new SpawnLocationData(parCoords, types[i]));
        }
    }

    public void tickMonitorPersistantMembers() {
        for (int i = 0; i < this.listSpawnLocations.size(); ++i) {
            SpawnLocationData data = this.listSpawnLocations.get(i);
            if (data.entityUUID != null && !this.listPersistantEntities.contains(data.entityUUID)) {
                data.entityUUID = null;
            }
            if (data.entityUUID != null) continue;
            System.out.println("detected missing entity, attempting to respawn a " + data.type + " at coords: " + data.coords);
            this.spawnMemberAtSpawnLocation(data);
            if (data.entityUUID != null) continue;
            System.out.println("spawned location failed to spawn a new entity, perhaps spawnMemberAtSpawnLocation() method not overridden properly?");
        }
    }

    public void spawnMemberAtSpawnLocation(SpawnLocationData parData) {
    }

    public void cleanup() {
        this.listLoadedEntities.clear();
        this.listPersistantEntities.clear();
        this.lookupIDToTownObject.clear();
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74778_a("classname", this.getClass().getCanonicalName());
        var1.func_74768_a("locationID", this.locationID);
        var1.func_74768_a("dimID", this.dimID);
        CoroUtilFile.writeCoords("spawn", this.spawn, var1);
        NBTTagCompound nbtListPersistantEntities = new NBTTagCompound();
        int count = 0;
        for (int i = 0; i < this.listPersistantEntities.size(); ++i) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            nbtEntry.func_74778_a("UUID", this.listPersistantEntities.get(i).toString());
            nbtListPersistantEntities.func_74782_a("entry_" + count++, (NBTBase)nbtEntry);
        }
        var1.func_74782_a("listPersistantEntities", (NBTBase)nbtListPersistantEntities);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.hasInit = true;
        this.locationID = var1.func_74762_e("locationID");
        this.dimID = var1.func_74762_e("dimID");
        this.spawn = CoroUtilFile.readCoords("spawn", var1);
        NBTTagCompound nbtPersistantEntities = var1.func_74775_l("listPersistantEntities");
        for (String entryName : nbtPersistantEntities.func_150296_c()) {
            NBTTagCompound entry = nbtPersistantEntities.func_74775_l(entryName);
            UUID uuid = UUID.fromString(entry.func_74779_i("UUID"));
            this.listPersistantEntities.add(uuid);
        }
    }
}

