/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.ItemDye;

public class ColorHelper {
    private static BiMap<Integer, Integer> woolValues = HashBiMap.create();
    private static ArrayList<Integer> colorValues = Lists.newArrayList();
    public static int DEFAULT_VALUE;
    public static final char COLOR_CHARACTER = '\u00a7';

    public static void init() {
        for (int color : ItemDye.field_150922_c) {
            colorValues.add(color);
        }
        DEFAULT_VALUE = colorValues.get(0);
        for (int i = 0; i < colorValues.size(); ++i) {
            woolValues.put((Object)ItemDye.field_150922_c[i], (Object)i);
        }
    }

    public static String color(int val) {
        return '\u00a7' + Integer.toHexString(val);
    }

    public static int getNumColors() {
        return woolValues.keySet().size();
    }

    public static int getColorFromDamage(int damage) {
        return colorValues.get(damage);
    }

    public static int getDamageFromColor(int color) {
        return (Integer)woolValues.get((Object)color);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int getColor(float red, float green, float blue) {
        return (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static int getColor(float[] rgb) {
        return ColorHelper.getColor(rgb[0], rgb[1], rgb[2]);
    }
}

