/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.block.BlockTropicraft;
import net.tropicraft.info.TCRenderIDs;
import net.tropicraft.registry.TCItemRegistry;

public class BlockTikiTorch
extends BlockTropicraft {
    private IIcon lowerTorch;
    private IIcon upperTorch;

    public BlockTikiTorch() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.field_149784_t = 15;
        float w = 0.0625f;
        this.func_149676_a(0.5f - w, 0.0f, 0.5f - w, 0.5f + w, 0.9f, 0.5f + w);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int id, int metadata) {
        if (metadata != 0) {
            return this.lowerTorch;
        }
        return this.upperTorch;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float w = 0.0625f;
        float top = world.func_72805_g(x, y, z) == 0 ? 0.625f : 1.0f;
        this.func_149676_a(0.5f - w, 0.0f, 0.5f - w, 0.5f + w, top, 0.5f + w);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            return this.canPlaceTikiTorchOn(world, x, y - 1, z);
        }
        return false;
    }

    public Item func_149650_a(int meta, Random rand, int unused) {
        if (meta == 0) {
            return TCItemRegistry.tikiTorch;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return TCItemRegistry.tikiTorch;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return TCRenderIDs.tikiTorch;
    }

    private boolean canPlaceTikiTorchOn(World world, int x, int y, int z) {
        if (world.func_147445_c(x, y, z, false)) {
            return true;
        }
        Block b = world.func_147439_a(x, y, z);
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        if (b == this && world.func_72805_g(x, y, z) == 1) {
            return true;
        }
        if (b != Blocks.field_150359_w && !(b instanceof BlockFence)) {
            int meta;
            return b != null && b instanceof BlockStairs && (4 & (meta = world.func_72805_g(x, y, z))) != 0;
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block oldBlock) {
        if (!world.field_72995_K && !this.canPlaceTikiTorchOn(world, x, y - 1, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, oldBlock);
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            while (world.func_147439_a(x, --y, z) == this) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        this.func_149664_b(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int l = world.func_72805_g(x, y, z);
        if (l == 0) {
            double d = (float)x + 0.5f;
            double d1 = (float)y + 0.7f;
            double d2 = (float)z + 0.5f;
            world.func_72869_a("smoke", d, d1, d2, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        if (l == 0) {
            return super.getLightValue(world, x, y, z);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    @Override
    public void func_149651_a(IIconRegister iconRegistry) {
        this.lowerTorch = iconRegistry.func_94245_a("tropicraft:tikiTorch_Lower");
        this.upperTorch = iconRegistry.func_94245_a("tropicraft:tikiTorch_Upper");
    }
}

