/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.entity.ai.jobs;

import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.util.CoroUtilBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.tropicraft.Tropicraft;
import net.tropicraft.block.tileentity.TileEntityPurchasePlate;
import net.tropicraft.economy.ItemEntry;
import net.tropicraft.economy.ItemValues;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCKoaCurrencyRegistry;

public class JobTrade
extends JobBase {
    public float tradeDistTrigger;
    public int tradeLastItemOffer;
    public ChunkCoordinates tradeBlockPos;
    public TileEntityPurchasePlate tradePlate;
    public EntityPlayer activeTrader;
    public ArrayList<ItemStack> offeredItems = new ArrayList();
    public Block idTradeBlock;

    public JobTrade(JobManager jm) {
        super(jm);
    }

    public void convertOfferingsToCurrency(int newCredit) {
        int leftToConvert;
        this.offeredItems.clear();
        for (leftToConvert = newCredit; leftToConvert > TCKoaCurrencyRegistry.currency.func_77976_d(); leftToConvert -= TCKoaCurrencyRegistry.currency.func_77976_d()) {
            this.offeredItems.add(new ItemStack(TCKoaCurrencyRegistry.currency.func_77973_b(), TCKoaCurrencyRegistry.currency.func_77976_d()));
        }
        if (leftToConvert > 0) {
            this.offeredItems.add(new ItemStack(TCKoaCurrencyRegistry.currency.func_77973_b(), leftToConvert));
        }
    }

    public int getOfferedItemsValue() {
        int value = 0;
        try {
            for (int i = 0; i < this.offeredItems.size(); ++i) {
                value += ItemValues.getItemEntry(this.offeredItems.get(i)).getTotalValue(this.offeredItems.get(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public int returnCredit() {
        int value = 0;
        try {
            for (int i = 0; i < this.offeredItems.size(); ++i) {
                this.activeTrader.field_71071_by.func_70441_a(this.offeredItems.get(i));
            }
            this.offeredItems.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public void tick() {
        if (this.tradeBlockPos != null && (this.ai.targX != this.tradeBlockPos.field_71574_a || this.ai.targY != this.tradeBlockPos.field_71572_b + 1 || this.ai.targZ != this.tradeBlockPos.field_71573_c) && this.ent.func_70011_f((double)this.tradeBlockPos.field_71574_a, (double)this.tradeBlockPos.field_71572_b, (double)this.tradeBlockPos.field_71573_c) > 15.0) {
            this.ent.func_70661_as().func_75499_g();
            this.ai.walkTo((Entity)this.ent, this.tradeBlockPos.field_71574_a, this.tradeBlockPos.field_71572_b + 1, this.tradeBlockPos.field_71573_c, (float)this.ai.maxPFRange, 600);
        }
        this.idTradeBlock = TCBlockRegistry.purchasePlate;
        this.ai.maxDistanceFromHome = 0.5;
        this.tradeDistTrigger = 4.0f;
        if (this.tradeBlockPos == null) {
            this.tradeBlockPos = this.tickFind(this.idTradeBlock, 25);
            if (this.tradeBlockPos != null) {
                TileEntity tile = this.ent.field_70170_p.func_147438_o(this.tradeBlockPos.field_71574_a, this.tradeBlockPos.field_71572_b, this.tradeBlockPos.field_71573_c);
                if (tile != null) {
                    ((TileEntityPurchasePlate)tile).tradeKoa = this.entInt;
                    this.tradePlate = (TileEntityPurchasePlate)tile;
                }
                this.ai.homeX = this.tradeBlockPos.field_71574_a;
                this.ai.homeY = this.tradeBlockPos.field_71572_b;
                this.ai.homeZ = this.tradeBlockPos.field_71573_c;
            }
        }
        if (this.activeTrader == null) {
            this.activeTrader = this.ent.field_70170_p.func_72890_a((Entity)this.ent, (double)this.tradeDistTrigger);
            if (this.activeTrader != null) {
                this.tradeStart();
            }
        } else if ((double)this.ent.func_70032_d((Entity)this.activeTrader) > (double)this.tradeDistTrigger * 1.5) {
            this.tradeReset();
        } else {
            this.tradeTick();
        }
    }

    public void tradeStart() {
        if (this.tradePlate != null) {
            this.tradePlate.tradeState = 1;
            this.tradePlate.credit = this.getOfferedItemsValue();
        }
    }

    public void tradeConfirmCallback() {
        int credit = this.getOfferedItemsValue();
        ItemEntry ie = ItemValues.itemsBuyable.get(this.tradePlate.itemIndex);
        int cost = ie.value;
        if (credit >= cost) {
            this.convertOfferingsToCurrency(credit -= cost);
            ItemStack is = ie.item.func_77946_l();
            this.activeTrader.field_71071_by.func_70441_a(is);
        }
        this.tradeSuccess();
    }

    public void tradeSuccess() {
        if (this.tradePlate != null) {
            this.tradePlate.tradeState = 1;
            this.tradePlate.credit = this.getOfferedItemsValue();
        }
    }

    public void tradeReset() {
        if (this.offeredItems != null) {
            this.returnCredit();
        }
        this.activeTrader = null;
        if (this.tradePlate != null) {
            this.tradePlate.tradeState = 0;
            this.tradePlate.credit = 0;
            this.tradePlate.activeTrader = null;
        }
        Tropicraft.dbg("trade reset");
    }

    public void tradeTick() {
        TileEntity tEnt = null;
        if (this.tradeBlockPos != null) {
            tEnt = this.ent.field_70170_p.func_147438_o(this.tradeBlockPos.field_71574_a, this.tradeBlockPos.field_71572_b, this.tradeBlockPos.field_71573_c);
        }
        if (this.tradeBlockPos != null && tEnt == null) {
            this.tradeBlockPos = null;
        } else if (tEnt instanceof TileEntityPurchasePlate) {
            ((TileEntityPurchasePlate)tEnt).activeTrader = this.activeTrader;
        }
    }

    public ChunkCoordinates tickFind(Block id, int range) {
        for (int i = 0; i < 30; ++i) {
            int randZ;
            int randY;
            int randX = (int)this.ent.field_70165_t + this.ent.field_70170_p.field_73012_v.nextInt(range) - range / 2;
            Block foundID = this.ent.field_70170_p.func_147439_a(randX, randY = (int)this.ent.field_70163_u + this.ent.field_70170_p.field_73012_v.nextInt(range) - range / 2, randZ = (int)this.ent.field_70161_v + this.ent.field_70170_p.field_73012_v.nextInt(range) - range / 2);
            if (foundID != id) continue;
            Tropicraft.dbg("found trade block");
            return new ChunkCoordinates(randX, randY, randZ);
        }
        return null;
    }

    public boolean shouldExecute() {
        return this.isAreaSecure();
    }

    public boolean shouldContinue() {
        return !this.isAreaSecure();
    }

    public boolean isAreaSecure() {
        if (this.tradeBlockPos != null) {
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, AxisAlignedBB.func_72330_a((double)this.tradeBlockPos.field_71574_a, (double)this.tradeBlockPos.field_71572_b, (double)this.tradeBlockPos.field_71573_c, (double)this.tradeBlockPos.field_71574_a, (double)this.tradeBlockPos.field_71572_b, (double)this.tradeBlockPos.field_71573_c).func_72314_b(6.0, 3.0, 6.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!this.entInt.isEnemy(entity1)) continue;
                return false;
            }
        }
        return true;
    }

    public void onIdleTickAct() {
        if (this.activeTrader != null) {
            this.ent.func_70625_a((Entity)this.activeTrader, 15.0f, 15.0f);
        } else if (this.tradeBlockPos != null) {
            // empty if block
        }
        if (this.activeTrader == null && this.ent.func_70661_as().func_75500_f()) {
            Random rand = new Random();
            if (this.tradeBlockPos != null && this.ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
                int tryX = this.tradeBlockPos.field_71574_a;
                int tryZ = this.tradeBlockPos.field_71573_c;
                if (!CoroUtilBlock.isAir((Block)this.ent.field_70170_p.func_147439_a(tryX, MathHelper.func_76128_c((double)(this.ent.field_70163_u - 1.0)), tryZ))) {
                    this.ai.walkTo((Entity)this.ent, this.tradeBlockPos.field_71574_a, MathHelper.func_76128_c((double)this.ent.field_70163_u), this.tradeBlockPos.field_71573_c, (float)this.ai.maxPFRange, 600);
                }
            }
        }
    }

    public boolean hookInteract(EntityPlayer par1EntityPlayer) {
        if (!this.ent.field_70170_p.field_72995_K) {
            ItemStack is;
            if (this.offeredItems == null) {
                this.offeredItems = new ArrayList();
            }
            if ((is = par1EntityPlayer.func_71045_bC()) != null && ItemValues.getItemEntry(is) != null) {
                par1EntityPlayer.field_71071_by.field_70462_a[par1EntityPlayer.field_71071_by.field_70461_c] = null;
                this.offeredItems.add(is);
                if (this.tradePlate != null) {
                    this.tradePlate.credit = this.getOfferedItemsValue();
                    System.out.println("VERIFY THIS CODE IN hookInteract()");
                    MinecraftServer.func_71276_C().func_71203_ab().func_148540_a(this.tradePlate.func_145844_m());
                }
            }
            return true;
        }
        return super.hookInteract(par1EntityPlayer);
    }
}

