/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.tropicraft.block.BlockTropicraft;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;

public class BlockBambooChute
extends BlockTropicraft
implements IPlantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon indentIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leafIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leafFlippedIcon;

    public BlockBambooChute() {
        super(Material.field_151585_k);
        this.func_149711_c(1.0f);
        this.func_149752_b(4.0f);
        float f = 0.375f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149658_d("bambooChute");
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("tropicraft:" + this.func_149641_N());
    }

    public static IIcon getBambooIcon(String iconString) {
        return null;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.func_147437_c(x, y + 1, z)) {
            int plantHeight = 1;
            while (world.func_147439_a(x, y - plantHeight, z) == TCBlockRegistry.bambooChute) {
                ++plantHeight;
            }
            if (plantHeight < 12) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    world.func_147449_b(x, y + 1, z, (Block)TCBlockRegistry.bambooChute);
                    world.func_72921_c(x, y, z, 0, 3);
                } else {
                    world.func_72921_c(x, y, z, meta + 1, 3);
                }
            }
        }
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        Block idBelow = world.func_147439_a(i, j - 1, k);
        Block idAdjacentX1 = world.func_147439_a(i - 1, j - 1, k);
        Block idAdjacentX2 = world.func_147439_a(i + 1, j - 1, k);
        Block idAdjacentZ1 = world.func_147439_a(i, j - 1, k - 1);
        Block idAdjacentZ2 = world.func_147439_a(i, j - 1, k + 1);
        if (idBelow == TCBlockRegistry.bambooChute) {
            return true;
        }
        if (idBelow != Blocks.field_150349_c && idBelow != Blocks.field_150346_d && idBelow != Blocks.field_150354_m) {
            return false;
        }
        if (idAdjacentX1 == Blocks.field_150346_d || idAdjacentX1 == Blocks.field_150349_c || idAdjacentX1 == Blocks.field_150354_m) {
            return true;
        }
        if (idAdjacentX2 == Blocks.field_150346_d || idAdjacentX2 == Blocks.field_150349_c || idAdjacentX2 == Blocks.field_150354_m) {
            return true;
        }
        if (idAdjacentZ1 == Blocks.field_150346_d || idAdjacentZ1 == Blocks.field_150349_c || idAdjacentZ1 == Blocks.field_150354_m) {
            return true;
        }
        return idAdjacentZ2 == Blocks.field_150349_c;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        return this.func_149742_c(par1World, par2, par3, par4);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborID) {
        this.checkBlockCoordValid(world, x, y, z);
    }

    protected final void checkBlockCoordValid(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        Block plantID = plant.getPlant(world, x, y + 1, z);
        EnumPlantType plantType = plant.getPlantType(world, x, y + 1, z);
        if (plantID == TCBlockRegistry.bambooChute) {
            return true;
        }
        BlockBambooChute blockID = TCBlockRegistry.bambooChute;
        switch (plantType) {
            case Desert: {
                return blockID == Blocks.field_150354_m;
            }
            case Nether: {
                return blockID == Blocks.field_150425_aM;
            }
            case Crop: {
                return blockID == Blocks.field_150458_ak;
            }
            case Cave: {
                return this.func_149747_d(world, x, y, z, direction.flag);
            }
            case Plains: {
                return blockID == Blocks.field_150349_c || blockID == Blocks.field_150346_d;
            }
            case Water: {
                return world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h && world.func_72805_g(x, y, z) == 0;
            }
            case Beach: {
                boolean isBeach = blockID == Blocks.field_150349_c || blockID == Blocks.field_150346_d || blockID == Blocks.field_150354_m;
                boolean hasWater = world.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151586_h || world.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y, z - 1).func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return TCBlockRegistry.bambooChute;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public Item func_149650_a(int meta, Random rand, int unused) {
        return TCItemRegistry.bambooChute;
    }
}

