/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.tropicraft.block.BlockTallFlowers;
import net.tropicraft.info.TCNames;
import net.tropicraft.registry.TCCreativeTabRegistry;

public class BlockPineapple
extends BlockTallFlowers
implements IGrowable {
    private static final int TOTAL_GROW_TICKS = 7;
    private static final int FULL_GROWTH = 8;

    public BlockPineapple(String[] names) {
        super(names);
        this.func_149663_c("pineapple");
        this.func_149658_d("tallFlower");
        this.func_149647_a(TCCreativeTabRegistry.tabFood);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta <= 7 ? this.bottomIcon : this.topIcons[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcons = new IIcon[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.topIcons[i] = iconRegister.func_94245_a(this.getActualName(this.getFormattedTextureName()) + "_" + TCNames.pineappleNames[i]);
        }
        this.bottomIcon = iconRegister.func_94245_a(this.getActualName(this.getFormattedTextureName()) + "_" + "Stem");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 8));
    }

    protected void func_149855_e(World p_149855_1_, int p_149855_2_, int p_149855_3_, int p_149855_4_) {
    }

    public void func_149681_a(World p_149681_1_, int p_149681_2_, int p_149681_3_, int p_149681_4_, int p_149681_5_, EntityPlayer p_149681_6_) {
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        this.checkFlowerChange(world, i, j, k);
        if (j > world.func_72800_K() - 2) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if (world.func_147439_a(i, j, k) == this && meta < 7 && world.func_147437_c(i, j + 1, k)) {
            int growth = meta;
            if (growth >= 6) {
                world.func_147465_d(i, j + 1, k, (Block)this, 8, 3);
                world.func_72921_c(i, j, k, 7, 3);
            } else {
                world.func_72921_c(i, j, k, growth + 1, 3);
            }
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemstack) {
    }

    @Override
    public Item func_149650_a(int meta, Random rand, int unused) {
        return null;
    }

    protected void checkFlowerChange(World world, int i, int j, int k) {
        if (!world.field_72995_K && !this.func_149718_j(world, i, j, k)) {
            if (world.func_72805_g(i, j, k) == 7) {
                this.func_149697_b(world, i, j, k, 0, 0);
            }
            world.func_147468_f(i, j, k);
        }
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        boolean belowCheck = false;
        belowCheck = world.func_147439_a(i, j, k) == this && world.func_72805_g(i, j, k) == 8 ? world.func_147439_a(i, j - 1, k) == this && world.func_72805_g(i, j - 1, k) == 7 : this.canThisPlantGrowOnThisBlock(world.func_147439_a(i, j - 1, k));
        return belowCheck && (world.func_72883_k(i, j, k) >= 8 || world.func_72937_j(i, j, k));
    }

    private boolean canThisPlantGrowOnThisBlock(Block b) {
        return b != null && (b.func_149688_o() == Material.field_151578_c || b.func_149688_o() == Material.field_151577_b);
    }

    protected String getFormattedTextureName() {
        return String.format("tile.%s%s", "tropicraft:", this.getActualName(this.func_149641_N()));
    }

    @Override
    public String func_149739_a() {
        return String.format("tile.%s%s", "tropicraft:", this.getActualName("tallFlower"));
    }

    @Override
    protected String getActualName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    @Override
    public boolean func_149851_a(World world, int x, int y, int z, boolean var5) {
        return true;
    }

    @Override
    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return world.func_72805_g(x, y, z) <= 7 && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        world.func_147465_d(x, y + 1, z, (Block)this, 8, 3);
    }
}

