/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.tropicraft.drinks.Ingredient;
import net.tropicraft.item.ItemCocktail;
import net.tropicraft.registry.TCDrinkMixerRegistry;
import net.tropicraft.registry.TCItemRegistry;

public class TileEntityEIHMixer
extends TileEntity {
    public int ticks;
    public static final int TICKS_TO_MIX = 80;
    public ItemStack[] ingredients = new ItemStack[2];
    public boolean mixing = false;
    public ItemStack result;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ticks = nbt.func_74762_e("MixTicks");
        this.mixing = nbt.func_74767_n("Mixing");
        this.ingredients[0] = nbt.func_74764_b("Ingredient1") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Ingredient1")) : null;
        this.ingredients[1] = nbt.func_74764_b("Ingredient2") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Ingredient2")) : null;
        this.result = nbt.func_74764_b("Result") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Result")) : null;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagCompound var4;
        super.func_145841_b(nbt);
        nbt.func_74768_a("MixTicks", this.ticks);
        nbt.func_74757_a("Mixing", this.mixing);
        if (this.ingredients[0] != null) {
            var4 = new NBTTagCompound();
            this.ingredients[0].func_77955_b(var4);
            nbt.func_74782_a("Ingredient1", (NBTBase)var4);
        }
        if (this.ingredients[1] != null) {
            var4 = new NBTTagCompound();
            this.ingredients[1].func_77955_b(var4);
            nbt.func_74782_a("Ingredient2", (NBTBase)var4);
        }
        if (this.result != null) {
            var4 = new NBTTagCompound();
            this.result.func_77955_b(var4);
            nbt.func_74782_a("Result", (NBTBase)var4);
        }
    }

    public void func_145845_h() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return this.result != null;
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public Ingredient[] listAllIngredients() {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (this.ingredients[0] == null || this.ingredients[1] == null) {
            return null;
        }
        is.addAll(TileEntityEIHMixer.listIngredients(this.ingredients[0]));
        is.addAll(TileEntityEIHMixer.listIngredients(this.ingredients[1]));
        Collections.sort(is);
        return is.toArray(new Ingredient[is.size()]);
    }

    public static Ingredient findMatchingIngredient(ItemStack stack) {
        for (Ingredient ingredient : Ingredient.ingredientsList) {
            if (ingredient == null || !ItemStack.func_77989_b((ItemStack)ingredient.getIngredient(), (ItemStack)stack)) continue;
            return ingredient;
        }
        return null;
    }

    public static List<Ingredient> listIngredients(ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() == TCItemRegistry.cocktail) {
            for (Ingredient ingredient : ItemCocktail.getIngredients(stack)) {
                is.add(ingredient);
            }
        } else {
            Ingredient i = TileEntityEIHMixer.findMatchingIngredient(stack);
            is.add(i);
        }
        return is;
    }

    public void startMixing() {
        this.ticks = 0;
        this.mixing = true;
        this.sync();
    }

    public void emptyMixer() {
        EntityItem item;
        if (this.ingredients[0] != null) {
            item = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.ingredients[0]);
            this.field_145850_b.func_72838_d((Entity)item);
            this.ingredients[0] = null;
        }
        if (this.ingredients[1] != null) {
            item = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.ingredients[1]);
            this.field_145850_b.func_72838_d((Entity)item);
            this.ingredients[1] = null;
        }
        this.ticks = 80;
        this.mixing = false;
        this.sync();
    }

    public void retrieveResult() {
        ItemStack container2;
        EntityItem e = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.result);
        this.field_145850_b.func_72838_d((Entity)e);
        ItemStack container1 = this.ingredients[0].func_77973_b().getContainerItem(this.ingredients[0]);
        if (container1 != null) {
            e = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, container1);
            this.field_145850_b.func_72838_d((Entity)e);
        }
        if ((container2 = this.ingredients[1].func_77973_b().getContainerItem(this.ingredients[1])) != null) {
            e = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, container2);
            this.field_145850_b.func_72838_d((Entity)e);
        }
        this.ingredients[0] = null;
        this.ingredients[1] = null;
        this.result = null;
        this.ticks = 0;
        this.mixing = false;
        this.sync();
    }

    public void finishMixing() {
        this.result = this.getResult(this.getIngredients());
        this.sync();
    }

    public boolean addToMixer(ItemStack ingredient) {
        if (this.ingredients[0] == null) {
            Ingredient i;
            if (!(ingredient.func_77973_b() == TCItemRegistry.cocktail || (i = TileEntityEIHMixer.findMatchingIngredient(ingredient)) != null && i.isPrimary())) {
                System.err.println("fail");
                return false;
            }
            this.ingredients[0] = ingredient;
            this.sync();
            return true;
        }
        if (this.ingredients[1] == null) {
            if (ingredient.func_77973_b() == TCItemRegistry.cocktail) {
                return false;
            }
            List<Ingredient> ingredients0 = TileEntityEIHMixer.listIngredients(this.ingredients[0]);
            Ingredient i = TileEntityEIHMixer.findMatchingIngredient(ingredient);
            if (i == null || i.isPrimary() || ingredients0.contains(i)) {
                return false;
            }
            this.ingredients[1] = ingredient;
            this.sync();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    private boolean isMixerFull() {
        return this.ingredients[0] != null && this.ingredients[1] != null;
    }

    public boolean canMix() {
        return !this.mixing && this.isMixerFull();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sync() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, nbttagcompound);
    }

    public ItemStack getResult(ItemStack[] ingredients2) {
        return TCDrinkMixerRegistry.getInstance().getResult(ingredients2);
    }
}

