/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.encyclopedia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.tropicraft.encyclopedia.TropicalBook;

public class Encyclopedia
extends TropicalBook {
    private HashMap<ItemStack, List<ShapedRecipes>> recipes = new HashMap();
    private HashMap<String, List<ItemStack>> itemEntries = new HashMap();

    public Encyclopedia(String savedDataFile, String contentsFile, String outsideTexture, String insideTexture) {
        super(savedDataFile, contentsFile, outsideTexture, insideTexture);
    }

    @Override
    public boolean hasRecipeList() {
        return true;
    }

    public void includeItem(String itemname, ItemStack item) {
        if (!this.itemEntries.containsKey(itemname)) {
            this.itemEntries.put(itemname, new ArrayList());
        }
        this.itemEntries.get(itemname).add(item);
    }

    public void includeRecipe(ItemStack result, Object[] aobj) {
        HashSet<ItemStack> recipeContents = new HashSet<ItemStack>();
        this.addItemToRecipeContents(recipeContents, result);
        String recipeString = "";
        int i = 0;
        int width = 0;
        int height = 0;
        if (aobj[i] instanceof String[]) {
            String[] cols = (String[])aobj[i++];
            for (int j = 0; j < cols.length; ++j) {
                String row = cols[j];
                ++height;
                width = row.length();
                recipeString = recipeString + row;
            }
        } else {
            while (aobj[i] instanceof String) {
                String row = (String)aobj[i++];
                ++height;
                width = row.length();
                recipeString = recipeString + row;
            }
        }
        HashMap<Character, ItemStack> charMap = new HashMap<Character, ItemStack>();
        while (i < aobj.length) {
            Character itemChar = (Character)aobj[i];
            ItemStack itemStack = null;
            if (aobj[i + 1] instanceof Item) {
                itemStack = new ItemStack((Item)aobj[i + 1]);
            } else if (aobj[i + 1] instanceof Block) {
                itemStack = new ItemStack((Block)aobj[i + 1], 1, -1);
            } else if (aobj[i + 1] instanceof ItemStack) {
                itemStack = (ItemStack)aobj[i + 1];
            }
            charMap.put(itemChar, itemStack);
            this.addItemToRecipeContents(recipeContents, itemStack);
            i += 2;
        }
        ItemStack[] slotArray = new ItemStack[width * height];
        for (int slots = 0; slots < width * height; ++slots) {
            char itemChar = recipeString.charAt(slots);
            slotArray[slots] = charMap.containsKey(Character.valueOf(itemChar)) ? ((ItemStack)charMap.get(Character.valueOf(itemChar))).func_77946_l() : null;
        }
        ShapedRecipes recipe = new ShapedRecipes(width, height, slotArray, result);
        for (ItemStack item : recipeContents) {
            boolean foundKey = false;
            for (ItemStack key : this.recipes.keySet()) {
                if (!item.func_77969_a(key)) continue;
                foundKey = true;
                this.recipes.get(key).add(recipe);
                break;
            }
            if (foundKey) continue;
            this.recipes.put(item, new ArrayList());
            this.recipes.get(item).add(recipe);
        }
    }

    public List<ShapedRecipes> getRecipesForEntry(int page) {
        List<ItemStack> entryItems = this.itemEntries.get(this.getPageName(page));
        ArrayList<ShapedRecipes> recipeList = new ArrayList<ShapedRecipes>();
        if (entryItems != null) {
            for (ItemStack item : entryItems) {
                for (ItemStack recipeItem : this.recipes.keySet()) {
                    List<ShapedRecipes> itemRecipes;
                    if (!recipeItem.func_77969_a(item) || (itemRecipes = this.recipes.get(recipeItem)) == null) continue;
                    recipeList.addAll(itemRecipes);
                }
            }
        }
        return recipeList;
    }

    @Override
    public int getContentPageCount(int page, TropicalBook.ContentMode mode) {
        if (page >= 0 && page < this.getPageCount()) {
            List<ShapedRecipes> recipeList;
            if (mode == TropicalBook.ContentMode.INFO) {
                return 1;
            }
            if (mode == TropicalBook.ContentMode.RECIPE && (recipeList = this.getRecipesForEntry(page)) != null) {
                return recipeList.size();
            }
        }
        return 0;
    }

    @Override
    public int entriesPerContentPage(TropicalBook.ContentMode mode) {
        if (mode == TropicalBook.ContentMode.RECIPE) {
            return 3;
        }
        return super.entriesPerContentPage(mode);
    }

    @Override
    public boolean hasIndexIcons() {
        return true;
    }

    @Override
    public ItemStack getPageItemStack(int page) {
        List<ItemStack> items;
        if (page >= 0 && page < this.getPageCount() && (items = this.itemEntries.get(this.getPageName(page))) != null && !items.isEmpty()) {
            return items.get(0);
        }
        return null;
    }

    @Override
    public void updatePagesFromInventory(InventoryPlayer inv) {
        for (ItemStack is : inv.field_70462_a) {
            if (is == null) continue;
            ItemStack comparison = new ItemStack(is.func_77973_b(), 1, is.func_77960_j());
            for (String entry : this.itemEntries.keySet()) {
                if (this.isPageVisible(entry)) continue;
                List<ItemStack> itemsInBook = this.itemEntries.get(entry);
                for (ItemStack itemInBook : itemsInBook) {
                    if (!ItemStack.func_77989_b((ItemStack)itemInBook, (ItemStack)comparison)) continue;
                    this.markPageAsNewlyVisible(entry);
                }
            }
        }
    }

    private void addItemToRecipeContents(Set<ItemStack> items, ItemStack i) {
        boolean shouldAdd = !items.contains(i);
        for (ItemStack listItem : items) {
            if (!listItem.func_77969_a(i)) continue;
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            items.add(i);
        }
    }

    public RecipeEntry getFormattedRecipe(ShapedRecipes recipe) {
        try {
            int width = recipe.field_77576_b;
            int height = recipe.field_77577_c;
            ItemStack[] items = recipe.field_77574_d;
            ItemStack output = recipe.func_77571_b();
            return new RecipeEntry(width, height, items, output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public class RecipeEntry {
        public int width;
        public int height;
        public ItemStack[] ingredients;
        public ItemStack output;

        public RecipeEntry(int width, int height, ItemStack[] ingredients, ItemStack output) {
            this.width = width;
            this.height = height;
            this.ingredients = ingredients;
            this.output = output;
        }
    }
}

