/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.entity.underdasea;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.tropicraft.entity.underdasea.EntityTropicraftWaterMob;
import net.tropicraft.registry.TCItemRegistry;

public class EntityTropicalFish
extends EntityTropicraftWaterMob {
    public boolean isLeader;
    public boolean inSchool;
    public EntityTropicalFish leader;
    public boolean targetHook;
    public Entity hook;
    public boolean hasBeenPlaced;
    public static final String[] names = new String[]{"Clownfish", "Queen Angelfish", "Yellow Tang", "Butterflyfish", "Geophagus Surinamensis", "Betta Fish", "Regal Tang", "Royal Gamma"};
    private static final int SHOULD_SPAWN_DATAWATCHER = 17;
    private static final int DATA_COLOR = 16;

    public EntityTropicalFish(World world) {
        super(world);
        this.targetHook = false;
        this.isLeader = true;
        this.inSchool = false;
        this.leader = null;
        this.func_70105_a(0.6f, 0.6f);
        this.setColor(this.field_70170_p.field_73012_v.nextInt(names.length));
        this.setShouldSpawnSchool(true);
        this.isCatchable = true;
        this.field_70728_aV = 3;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    public void setColor(int col) {
        this.field_70180_af.func_75692_b(16, (Object)col);
    }

    public int getColor() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setShouldSpawnSchool(boolean spawnStatus) {
        this.field_70180_af.func_75692_b(17, (Object)(spawnStatus ? Integer.valueOf(1) : Integer.valueOf(-1)));
    }

    public boolean getShouldSpawnSchool() {
        return this.field_70180_af.func_75679_c(17) == 1;
    }

    public EntityTropicalFish(World world, EntityLiving entityliving, int i) {
        super(world);
        this.setShouldSpawnSchool(false);
        this.targetHook = false;
        this.isLeader = true;
        this.inSchool = false;
        this.leader = null;
        this.setColor(i);
        this.func_70105_a(0.4f, 0.85f);
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
    }

    public EntityTropicalFish(EntityTropicalFish original) {
        this(original.field_70170_p);
        this.setShouldSpawnSchool(false);
        this.targetHook = false;
        this.isLeader = false;
        this.inSchool = true;
        this.leader = original;
        this.setColor(original.getColor());
        this.field_70129_M = 0.0f;
        this.func_70105_a(original.field_70130_N, original.field_70131_O);
        do {
            double offsetX = new Random().nextDouble() * 3.0 - 1.5;
            double offsetY = new Random().nextDouble() * 2.0 + 1.0;
            double offsetZ = new Random().nextDouble() * 3.0 - 1.5;
            this.func_70012_b(original.field_70165_t + offsetX, original.field_70163_u + offsetY, original.field_70161_v + offsetZ, original.field_70177_z, original.field_70125_A);
        } while (!this.func_70601_bi());
        this.field_70159_w = original.field_70159_w;
        this.field_70181_x = original.field_70181_x;
        this.field_70179_y = original.field_70179_y;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(17, (Object)-1);
    }

    public void checkForLeader() {
        List list = this.field_70170_p.func_72872_a(EntityTropicalFish.class, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
        for (Object ent : list) {
            if (((EntityTropicalFish)((Object)ent)).getColor() != this.getColor()) continue;
            if (this.func_145782_y() > ((Entity)ent).func_145782_y()) {
                this.leader = (EntityTropicalFish)((Object)ent);
                this.isLeader = false;
                continue;
            }
            this.isLeader = true;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Placed", this.hasBeenPlaced);
        nbttagcompound.func_74768_a("Color", Integer.valueOf(this.getColor()).intValue());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.hasBeenPlaced = nbttagcompound.func_74764_b("Placed") ? nbttagcompound.func_74767_n("Placed") : true;
        this.setShouldSpawnSchool(false);
        this.setColor(nbttagcompound.func_74762_e("Color"));
    }

    public EntityLivingBase func_70638_az() {
        if (this.leader != null && !this.inSchool && this.func_70685_l((Entity)this.leader)) {
            return this.leader;
        }
        return null;
    }

    public void checkForHook() {
        List list = this.field_70170_p.func_72872_a(EntityFishHook.class, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
        if (list.isEmpty()) {
            this.targetHook = false;
            this.hook = null;
            return;
        }
        this.hook = (EntityFishHook)list.get(0);
        this.targetHook = true;
    }

    @Override
    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.targetEntity != null && entity instanceof EntityTropicalFish) {
            this.targetEntity = null;
            this.inSchool = true;
        }
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() == null || entityplayer.func_71045_bC().func_77973_b() != TCItemRegistry.fishingNet) {
            return false;
        }
        if (!entityplayer.field_71071_by.func_146028_b((Item)TCItemRegistry.bucketTropicsWater)) {
            return false;
        }
        for (int i = 0; i < entityplayer.field_71071_by.field_70462_a.length; ++i) {
            if (entityplayer.field_71071_by.func_70301_a(i) == null || entityplayer.field_71071_by.func_70301_a(i).func_77973_b() != TCItemRegistry.bucketTropicsWater) continue;
            entityplayer.field_71071_by.field_70462_a[i] = new ItemStack((Item)TCItemRegistry.fishBucket, 1, this.getColor());
            this.func_70106_y();
            entityplayer.func_71038_i();
            return true;
        }
        return false;
    }

    @Override
    protected void func_70626_be() {
        if (this.getShouldSpawnSchool()) {
            int maxInSchool = 7;
            int minInSchool = 4;
            int numToSpawn = new Random().nextInt(1 + maxInSchool - minInSchool) + minInSchool - 1;
            for (int i = 0; i < numToSpawn; ++i) {
                if (this.field_70170_p.field_72995_K) continue;
            }
            this.setShouldSpawnSchool(false);
        }
        if (this.leader != null && this.func_70032_d((Entity)this.leader) < 1.5f) {
            this.inSchool = true;
        }
        if (this.leader != null && this.leader.field_70128_L) {
            this.leader = null;
        }
        if (this.leader == null || this.isLeader) {
            this.checkForLeader();
        }
        if (!this.inSchool || this.isLeader) {
            super.func_70626_be();
        } else if (this.inSchool && this.leader != null) {
            if (this.func_70032_d((Entity)this.leader) >= 2.25f && this.field_70173_aa % 40 == 0) {
                this.inSchool = false;
            }
            if (!this.leader.isLeader && this.leader.leader != null) {
                this.leader = this.leader.leader;
            }
            this.randomMotionVecX = this.leader.randomMotionVecX;
            this.randomMotionVecY = this.leader.randomMotionVecY;
            this.randomMotionVecZ = this.leader.randomMotionVecZ;
        }
    }

    @Override
    protected int attackStrength() {
        return 0;
    }

    @Override
    public boolean func_70692_ba() {
        return !this.hasBeenPlaced;
    }

    public void disableDespawning() {
        this.hasBeenPlaced = true;
    }
}

