/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.tropicraft.config.ConfigGenRates;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.worldgen.WorldGenBamboo;
import net.tropicraft.world.worldgen.WorldGenEIH;
import net.tropicraft.world.worldgen.WorldGenTallFlower;
import net.tropicraft.world.worldgen.WorldGenTropicraftCurvedPalm;
import net.tropicraft.world.worldgen.WorldGenTropicraftFlowers;
import net.tropicraft.world.worldgen.WorldGenTropicraftLargePalmTrees;
import net.tropicraft.world.worldgen.WorldGenTropicraftNormalPalms;

public class TCWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateSurface(world, random, chunkX, chunkZ);
    }

    public void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        int cx = chunkX;
        int cz = chunkZ;
        if (ConfigGenRates.genTropicraftInOverworld) {
            chunkX *= 16;
            chunkZ *= 16;
            if (world.field_73011_w.field_76574_g == 0) {
                WorldType cfr_ignored_0 = world.field_73011_w.field_76577_b;
                if (world.field_73011_w.field_76577_b != WorldType.field_77138_c) {
                    int k = chunkX + random.nextInt(16) + 8;
                    int l = random.nextInt(62) + 64;
                    int i1 = chunkZ + random.nextInt(16) + 8;
                    if (ConfigGenRates.genTropicraftFlowersInOverworld) {
                        for (int j3 = 0; j3 < 10; ++j3) {
                            l = random.nextInt(62) + 64;
                            new WorldGenTropicraftFlowers(world, random, (Block)TCBlockRegistry.flowers, BiomeGenTropicraft.DEFAULT_FLOWER_META).func_76484_a(world, random, k, l, i1);
                        }
                    }
                    if (ConfigGenRates.genTropicraftEIHInOverworld && random.nextInt(27) == 0) {
                        l = random.nextInt(62) + 64;
                        new WorldGenEIH(world, random).func_76484_a(world, random, k, l, i1);
                    }
                    if (ConfigGenRates.genPalmsInOverworld) {
                        BiomeGenBase biome = world.func_72959_q().func_76935_a(cx, cz);
                        if ((ConfigGenRates.genOverworldPalmsInBeachOnly && biome == BiomeGenBase.field_76787_r || !ConfigGenRates.genOverworldPalmsInBeachOnly) && (ConfigGenRates.palmChanceOfGenInOverworld < 0 || random.nextFloat() < (float)ConfigGenRates.palmChanceOfGenInOverworld / 100.0f)) {
                            for (int j3 = 0; j3 < ConfigGenRates.palmPopulationFactorInOverworld; ++j3) {
                                l = random.nextInt(62) + 64;
                                if (random.nextInt(5) == 0) {
                                    new WorldGenTropicraftLargePalmTrees().func_76484_a(world, random, k, l, i1);
                                    continue;
                                }
                                if (random.nextInt(5) < 3) {
                                    new WorldGenTropicraftCurvedPalm(world, random).func_76484_a(world, random, k, l, i1);
                                    continue;
                                }
                                new WorldGenTropicraftNormalPalms().func_76484_a(world, random, k, l, i1);
                            }
                        }
                    }
                    if (ConfigGenRates.genPineapplesInOverworld) {
                        l = random.nextInt(62) + 64;
                        new WorldGenTallFlower(world, random, (Block)TCBlockRegistry.tallFlowers, 0, 1).func_76484_a(world, random, k, l, i1);
                    }
                    if (ConfigGenRates.genBambooInOverworld && random.nextInt(3) == 0) {
                        l = random.nextInt(62) + 64;
                        new WorldGenBamboo(world, random).func_76484_a(world, random, k, l, i1);
                    }
                }
            }
        }
    }
}

