/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenCoffeePlant
extends TCGenBase {
    private static final ForgeDirection[] cardinalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};

    public WorldGenCoffeePlant(World world, Random rand) {
        super(world, rand);
    }

    @Override
    public boolean generate(int x, int y, int z) {
        int neighborz;
        int neighborx;
        int nz;
        int ny;
        int nx = x + this.rand.nextInt(8) - this.rand.nextInt(8);
        if (!this.worldObj.func_147437_c(nx, ny = y, nz = z + this.rand.nextInt(8) - this.rand.nextInt(8)) || this.worldObj.func_147439_a(nx, ny - 1, nz) != Blocks.field_150349_c) {
            return false;
        }
        ForgeDirection viableDirection = ForgeDirection.UNKNOWN;
        for (ForgeDirection dir : cardinalDirections) {
            neighborx = nx + dir.offsetX;
            neighborz = nz + dir.offsetZ;
            if (this.worldObj.func_147439_a(neighborx, ny - 1, neighborz).func_149688_o() != Material.field_151586_h) continue;
            viableDirection = dir;
            break;
        }
        if (viableDirection == ForgeDirection.UNKNOWN) {
            for (ForgeDirection dir : cardinalDirections) {
                neighborx = nx + dir.offsetX;
                neighborz = nz + dir.offsetZ;
                if (!this.worldObj.func_147437_c(neighborx, ny, neighborz) || this.worldObj.func_147439_a(neighborx, ny - 1, neighborz) != Blocks.field_150349_c || this.worldObj.func_147437_c(neighborx, ny - 2, neighborz)) continue;
                boolean surrounded = true;
                for (ForgeDirection surroundingDir : cardinalDirections) {
                    int surroundingx = neighborx + surroundingDir.offsetX;
                    int surroundingz = neighborz + surroundingDir.offsetZ;
                    if (this.worldObj.func_147437_c(surroundingx, ny, surroundingz) && this.worldObj.func_147439_a(surroundingx, ny - 1, surroundingz) == Blocks.field_150349_c) continue;
                    surrounded = false;
                    break;
                }
                if (!surrounded) continue;
                viableDirection = dir;
                break;
            }
        }
        if (viableDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        this.worldObj.func_147465_d(nx + viableDirection.offsetX, ny - 1, nz + viableDirection.offsetZ, Blocks.field_150355_j, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(nx, ny - 1, nz, Blocks.field_150458_ak, 7, blockGenNotifyFlag);
        for (int i = 0; i < 3 && this.worldObj.func_147437_c(nx, ny + i, nz); ++i) {
            this.worldObj.func_147465_d(nx, ny + i, nz, (Block)TCBlockRegistry.coffeePlant, 6, blockGenNotifyFlag);
        }
        return true;
    }
}

