/*
 * Decompiled with CFR 0.152.
 */
package build.playerdata;

import build.BuildMod;
import build.playerdata.IPlayerData;
import build.playerdata.PlayerDataObject;
import build.playerdata.objects.Clipboard;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerData {
    public static HashMap<String, PlayerDataObject> playerData = new HashMap();

    public static void initObjects(PlayerDataObject pdo) {
        PlayerDataObject.playerData.put("clipboard", new Clipboard());
        pdo.nbtLoad();
    }

    public static IPlayerData get(String username, String objectName) {
        return PlayerData.get(username).get(objectName);
    }

    public static PlayerDataObject get(String username) {
        if (!playerData.containsKey(username)) {
            NBTTagCompound nbt = PlayerData.tryLoadPlayerData(username);
            PlayerDataObject pd = new PlayerDataObject(username, nbt);
            PlayerData.initObjects(pd);
            playerData.put(username, pd);
        }
        return playerData.get(username);
    }

    public static NBTTagCompound tryLoadPlayerData(String username) {
        NBTTagCompound playerNBT = new NBTTagCompound();
        boolean firstTimeInit = false;
        try {
            String fileURL = BuildMod.getWorldSaveFolderPath() + BuildMod.getWorldFolderName() + File.separator + "BMPlayerData" + File.separator + username + ".dat";
            if (new File(fileURL).exists()) {
                playerNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            } else {
                BuildMod.dbg("no saved data found for " + username);
                firstTimeInit = true;
            }
        }
        catch (Exception ex) {
            BuildMod.dbg("error trying to load data for " + username);
            firstTimeInit = true;
        }
        if (firstTimeInit) {
            playerNBT.func_74757_a("newPlayer", true);
        }
        return playerNBT;
    }
}

