/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.block.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;

public class TileEntitySifter
extends TileEntity {
    public static final int SIFT_TIME = 80;
    public boolean isSifting;
    public int currentSiftTime = 80;
    private Random rand = new Random();
    public double yaw;
    public double yaw2 = 0.0;
    public ItemStack siftItem;

    public void func_145845_h() {
        if (this.currentSiftTime > 0 && this.isSifting) {
            --this.currentSiftTime;
        }
        if (this.field_145850_b.field_72995_K) {
            this.yaw2 = this.yaw % 360.0;
            this.yaw += 4.545454502105713;
        }
        if (!this.field_145850_b.field_72995_K && this.isSifting && this.currentSiftTime <= 0) {
            double x = (double)this.field_145851_c + this.field_145850_b.field_73012_v.nextDouble() * 1.4;
            double y = (double)this.field_145848_d + this.field_145850_b.field_73012_v.nextDouble() * 1.4;
            double z = (double)this.field_145849_e + this.field_145850_b.field_73012_v.nextDouble() * 1.4;
            this.dumpResults(x, y, z, this.isHeatedSifter() ? SiftType.HEATED : SiftType.REGULAR);
            this.currentSiftTime = 80;
            this.setSifting(false, 0, -1.0f);
        }
    }

    public void dumpResults(double x, double y, double z, SiftType type) {
        if (type == SiftType.HEATED) {
            float refinedAmt = this.getTagCompound(this.siftItem).func_74760_g("AmtRefined");
            if (this.siftItem.func_77973_b() == TCItemRegistry.ore) {
                refinedAmt = this.refine(refinedAmt);
            }
            if (this.siftItem.func_77973_b() == Item.func_150898_a((Block)TCBlockRegistry.mineralSands) && this.siftItem.func_77960_j() == 3) {
                this.siftItem = new ItemStack((Item)TCItemRegistry.ore, 1, 5);
            }
            if (refinedAmt == 100.0f) {
                this.siftItem = new ItemStack((Item)TCItemRegistry.ore, 1, 6);
            }
            this.getTagCompound(this.siftItem).func_74776_a("AmtRefined", refinedAmt);
            this.spawn(this.siftItem, x, y, z);
            this.spawn(new ItemStack((Block)TCBlockRegistry.purifiedSand), x, y, z);
        } else {
            this.dumpBeachResults(x, y, z);
        }
    }

    private void dumpBeachResults(double x, double y, double z) {
        this.spawn(new ItemStack((Block)TCBlockRegistry.purifiedSand), x, y, z);
        for (int dumpCount = this.rand.nextInt(3) + 1; dumpCount > 0; --dumpCount) {
            ItemStack stack = this.rand.nextInt(10) == 0 ? this.getRareItem() : this.getCommonItem();
            this.spawn(stack, x, y, z);
        }
    }

    private void spawn(ItemStack stack, double x, double y, double z) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EntityItem eitem = new EntityItem(this.field_145850_b, x, y, z, stack);
        eitem.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)eitem);
    }

    private ItemStack getCommonItem() {
        int dmg = this.rand.nextInt(8);
        switch (dmg) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return new ItemStack(TCItemRegistry.shells, 1, dmg);
            }
        }
        return this.getRareItem();
    }

    private ItemStack getRareItem() {
        int dmg = this.rand.nextInt(8);
        switch (dmg) {
            case 0: {
                return new ItemStack(TCItemRegistry.shells, 1, 3);
            }
            case 1: {
                return new ItemStack(Items.field_151074_bl, 1);
            }
            case 2: {
                return new ItemStack(Items.field_151133_ar, 1);
            }
            case 3: {
                return new ItemStack(Items.field_151038_n, 1);
            }
            case 4: {
                return new ItemStack(Items.field_151069_bo, 1);
            }
            case 5: {
                return new ItemStack((Item)TCItemRegistry.pearl, 1, 0);
            }
            case 6: {
                return new ItemStack((Item)TCItemRegistry.pearl, 1, 1);
            }
        }
        return new ItemStack(TCItemRegistry.shells, 1, 3);
    }

    private float refine(float refinedAmt) {
        if (refinedAmt == 0.0f) {
            return 33.333f;
        }
        if (refinedAmt > 32.0f && refinedAmt < 34.0f) {
            return 66.667f;
        }
        if (refinedAmt > 65.0f && refinedAmt < 67.0f) {
            return 100.0f;
        }
        return 0.0f;
    }

    public boolean isHeatedSifter() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return block.func_149688_o() == Material.field_151581_o || block.func_149688_o() == Material.field_151587_i;
    }

    public void setSifting(boolean flag, int type, float refined) {
        this.isSifting = flag;
        ItemStack itemStack = type == -1 ? null : (type == 1 ? new ItemStack((Block)Blocks.field_150354_m) : (this.siftItem = type == 2 ? new ItemStack((Block)TCBlockRegistry.mineralSands, 1, 3) : new ItemStack((Item)TCItemRegistry.ore, 1, 5)));
        if (this.siftItem.func_77973_b() == TCItemRegistry.ore) {
            this.getTagCompound(this.siftItem).func_74776_a("AmtRefined", refined);
        } else {
            System.err.println("stack is null : (");
        }
        this.sync();
    }

    public boolean isSifting() {
        return this.isSifting;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isSifting = nbt.func_74767_n("isSifting");
        this.currentSiftTime = nbt.func_74762_e("currentSiftTime");
        NBTTagList itemtaglist = nbt.func_150295_c("Item", 10);
        NBTTagCompound itemtagcompound = itemtaglist.func_150305_b(0);
        this.siftItem = ItemStack.func_77949_a((NBTTagCompound)itemtagcompound);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isSifting", this.isSifting);
        nbt.func_74768_a("currentSiftTime", this.currentSiftTime);
        NBTTagList nbttaglist = new NBTTagList();
        if (this.siftItem != null) {
            NBTTagCompound siftItemTagCompound = new NBTTagCompound();
            this.siftItem.func_77955_b(siftItemTagCompound);
            nbttaglist.func_74742_a((NBTBase)siftItemTagCompound);
        }
        nbt.func_74782_a("Item", (NBTBase)nbttaglist);
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sync() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, nbttagcompound);
    }

    public static enum SiftType {
        REGULAR,
        HEATED;

    }
}

