/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.tropicraft.block.tileentity.TileEntityBambooChest;
import net.tropicraft.block.tileentity.TileEntityTropicraftFlowerPot;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;
import net.tropicraft.world.worldgen.TCDirectionalGen;

public class WorldGenForestAltarRuin
extends TCDirectionalGen {
    public WorldGenForestAltarRuin(World world, Random random) {
        super(world, random, random.nextInt(4));
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int x;
        int z;
        j = Integer.MAX_VALUE;
        this.setOrigin(i, k);
        int width = (this.rand.nextInt(2) + 3) * 2;
        int length = this.rand.nextInt(6) + 10;
        int halfWidth = width / 2;
        boolean hasGennedTunnel = false;
        for (z = 0; z < length; ++z) {
            for (x = 0; x < width; ++x) {
                if (this.getTerrainHeightWithDir(x, z) >= j) continue;
                j = this.getTerrainHeightWithDir(x, z);
            }
        }
        int y = j;
        while (this.worldObj.func_147439_a(i, y, k) != Blocks.field_150350_a) {
            if (this.worldObj.func_147439_a(i, y, k) == TCBlockRegistry.tropicsWater) {
                return false;
            }
            ++y;
        }
        for (z = 0; z < length; ++z) {
            block4: for (x = 0; x < width; ++x) {
                int y2;
                for (y2 = 0; y2 < 4; ++y2) {
                    if (this.worldObj.func_147439_a(x, y2 + j, z) == TCBlockRegistry.logs) continue block4;
                    if (this.rand.nextInt(4) == 0) continue;
                    this.placeBlockWithDir(x, y2 + j, z, Blocks.field_150350_a, 0);
                }
                y2 = j;
                this.placeBlockWithDir(x, y2, z, TCBlockRegistry.logs, 1);
                if (z == 0) {
                    if (x == 0 || x == width - 1) {
                        this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.palmFence, 0);
                        this.placeBlockWithDir(x, y2 + 2, z, (Block)TCBlockRegistry.palmFence, 0);
                        continue;
                    }
                    this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.singleSlabs, 2);
                    this.placeBlockWithDir(x, y2 + 2, z, (Block)TCBlockRegistry.palmFence, 0);
                    continue;
                }
                if (z == 1) {
                    if (x == 0 || x == width - 1) {
                        this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.palmFence, 0);
                        continue;
                    }
                    if (x == 1 || x == width - 2) {
                        this.placeBlockWithDir(x, y2 + 1, z, TCBlockRegistry.chunkOHead, 0);
                        this.placeBlockWithDir(x, y2 + 2, z, TCBlockRegistry.flowerPot, 0);
                        TileEntityTropicraftFlowerPot pot = (TileEntityTropicraftFlowerPot)this.getTEWithDir(x, y2 + 2, z);
                        if (pot == null) continue;
                        pot.setFlowerID((short)(this.rand.nextInt(13) + 1));
                        continue;
                    }
                    if (x == halfWidth - 1 || x == halfWidth) {
                        this.placeBlockWithDir(x, y2, z, Blocks.field_150424_aL, 0);
                        this.placeBlockWithDir(x, y2 + 1, z, (Block)Blocks.field_150480_ab, 0);
                        continue;
                    }
                    this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.singleSlabs, 2);
                    continue;
                }
                if (z == 2) {
                    if (x == 0 || x == width - 1) {
                        this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.palmFence, 0);
                        continue;
                    }
                    this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.singleSlabs, 2);
                    continue;
                }
                if (z % 2 == 1) {
                    if (x != 0 && x != width - 1) continue;
                    this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.palmFence, 0);
                    continue;
                }
                if (x == 0 || x == width - 1) {
                    this.placeBlockWithDir(x, y2 + 1, z, TCBlockRegistry.tikiTorch, 1);
                    this.placeBlockWithDir(x, y2 + 2, z, TCBlockRegistry.tikiTorch, 1);
                    this.placeBlockWithDir(x, y2 + 3, z, TCBlockRegistry.tikiTorch, 0);
                    continue;
                }
                if (x == halfWidth - 1 || x == halfWidth) continue;
                this.placeBlockWithDir(x, y2 + 1, z, (Block)TCBlockRegistry.palmStairs, this.dir);
                if (hasGennedTunnel) continue;
                this.generateTunnel(x, y2, z);
                hasGennedTunnel = true;
            }
        }
        return true;
    }

    private void generateTunnel(int i, int j, int k) {
        int depth = this.rand.nextInt(5) + 8;
        for (int y = 0; y < depth; ++y) {
            this.placeBlockWithDir(i, j - y, k, Blocks.field_150350_a, 0);
        }
        j -= depth;
        int length = this.rand.nextInt(20) + 30;
        int dir = this.rand.nextInt(4);
        for (int x = 0; x < length; ++x) {
            switch (dir) {
                case 0: {
                    ++i;
                    break;
                }
                case 1: {
                    ++k;
                    break;
                }
                case 2: {
                    --i;
                    break;
                }
                case 3: {
                    --k;
                }
            }
            if (this.rand.nextInt(3) == 0) {
                j += this.rand.nextInt(3) - 1;
            }
            this.placeBlockWithDir(i, j, k, Blocks.field_150350_a, 0);
            this.placeBlockWithDir(i, j + 1, k, Blocks.field_150350_a, 0);
            this.placeBlockWithDir(i, j + 2, k, Blocks.field_150350_a, 0);
            if (this.rand.nextInt(5) != 0) continue;
            dir = this.rand.nextInt(4);
        }
        this.placeBlockWithDir(i, j, k, (Block)TCBlockRegistry.bambooChest, 0);
        TileEntityBambooChest chest = (TileEntityBambooChest)this.getTEWithDir(i, j, k);
        if (chest != null) {
            chest.func_70299_a(0, this.randLoot());
        }
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ItemStack((Block)TCBlockRegistry.bambooChute, this.rand.nextInt(20) + 1);
        }
        if (picker < 10) {
            return new ItemStack((Item)TCItemRegistry.scale, this.rand.nextInt(3) + 1);
        }
        if (picker < 12) {
            return new ItemStack((Block)TCBlockRegistry.thatchBundle, this.rand.nextInt(20) + 1);
        }
        if (picker < 14) {
            return new ItemStack((Item)TCItemRegistry.cookedFrogLeg, this.rand.nextInt(4) + 1);
        }
        return new ItemStack((Item)TCItemRegistry.blowGun, 1);
    }
}

