/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.pathfinding;

import CoroUtil.pathfinding.PathPointEx;

public class PathEx {
    private PathPointEx[] pathPoints = new PathPointEx[1024];
    private int count = 0;

    public PathPointEx addPoint(PathPointEx pathpoint) {
        if (pathpoint.index >= 0) {
            // empty if block
        }
        if (this.count == this.pathPoints.length) {
            PathPointEx[] apathpoint = new PathPointEx[this.count << 1];
            System.arraycopy(this.pathPoints, 0, apathpoint, 0, this.count);
            this.pathPoints = apathpoint;
        }
        this.pathPoints[this.count] = pathpoint;
        pathpoint.index = this.count;
        this.sortBack(this.count++);
        return pathpoint;
    }

    public void clearPath() {
        this.count = 0;
    }

    public PathPointEx dequeue() {
        PathPointEx pathpoint = this.pathPoints[0];
        this.pathPoints[0] = this.pathPoints[--this.count];
        this.pathPoints[this.count] = null;
        if (this.count > 0) {
            this.sortForward(0);
        }
        pathpoint.index = -1;
        return pathpoint;
    }

    public void changeDistance(PathPointEx pathpoint, float f) {
        float f1 = pathpoint.distanceToTarget;
        pathpoint.distanceToTarget = f;
        if (f < f1) {
            try {
                this.sortBack(pathpoint.index);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                boolean sdfsdf = false;
            }
        } else {
            this.sortForward(pathpoint.index);
        }
    }

    private void sortBack(int i) {
        PathPointEx pathpoint = this.pathPoints[i];
        if (pathpoint == null) {
            return;
        }
        float f = pathpoint.distanceToTarget;
        while (i > 0) {
            int j = i - 1 >> 1;
            PathPointEx pathpoint1 = this.pathPoints[j];
            if (pathpoint1 == null) {
                return;
            }
            if (f >= pathpoint1.distanceToTarget) break;
            this.pathPoints[i] = pathpoint1;
            pathpoint1.index = i;
            i = j;
        }
        this.pathPoints[i] = pathpoint;
        pathpoint.index = i;
    }

    private void sortForward(int i) {
        PathPointEx pathpoint = this.pathPoints[i];
        float f = pathpoint.distanceToTarget;
        while (true) {
            float f2;
            PathPointEx pathpoint2;
            int j = 1 + (i << 1);
            int k = j + 1;
            if (j >= this.count) break;
            PathPointEx pathpoint1 = this.pathPoints[j];
            float f1 = pathpoint1.distanceToTarget;
            if (k >= this.count) {
                pathpoint2 = null;
                f2 = Float.POSITIVE_INFINITY;
            } else {
                pathpoint2 = this.pathPoints[k];
                f2 = pathpoint2.distanceToTarget;
            }
            if (f1 < f2) {
                if (f1 >= f) break;
                this.pathPoints[i] = pathpoint1;
                pathpoint1.index = i;
                i = j;
                continue;
            }
            if (f2 >= f) break;
            this.pathPoints[i] = pathpoint2;
            pathpoint2.index = i;
            i = k;
        }
        this.pathPoints[i] = pathpoint;
        pathpoint.index = i;
    }

    public boolean isPathEmpty() {
        return this.count == 0;
    }
}

