/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.curare;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.tropicraft.curare.CurareMix;
import net.tropicraft.curare.CurareType;

public class CurareMixRegistry {
    private static CurareMixRegistry instance;
    private Map<CurareType, CurareMix> recipes = new HashMap<CurareType, CurareMix>();

    private CurareMixRegistry() {
    }

    public static CurareMixRegistry getInstance() {
        if (instance == null) {
            instance = new CurareMixRegistry();
        }
        return instance;
    }

    public void registerRecipe(CurareMix recipe) {
        this.recipes.put(recipe.getResult(), recipe);
    }

    public Collection<CurareMix> getRecipes() {
        return this.recipes.values();
    }

    public CurareMix getCurareMixFromType(CurareType type) {
        return this.recipes.get(type);
    }

    public int[] getSortedDamageVals(ItemStack[] ingredients) {
        int[] temp = new int[ingredients.length];
        int count = 0;
        for (ItemStack ing : ingredients) {
            System.out.println(ing.func_77960_j());
            temp[count] = ing.func_77960_j();
            ++count;
        }
        Arrays.sort(temp);
        return temp;
    }

    public CurareType getCurareFromIngredients(ItemStack ... ingredients) {
        for (CurareMix mix : this.getRecipes()) {
            if (!Arrays.equals(mix.getSortedDamageVals(), this.getSortedDamageVals(ingredients))) continue;
            return mix.getResult();
        }
        return CurareType.weakness;
    }
}

