/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.registry;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.tropicraft.block.BlockBambooChest;
import net.tropicraft.block.BlockBambooChute;
import net.tropicraft.block.BlockBambooDoor;
import net.tropicraft.block.BlockBambooMug;
import net.tropicraft.block.BlockBongoDrum;
import net.tropicraft.block.BlockBundle;
import net.tropicraft.block.BlockChunkOHead;
import net.tropicraft.block.BlockCoconut;
import net.tropicraft.block.BlockCoffeePlant;
import net.tropicraft.block.BlockCoral;
import net.tropicraft.block.BlockCurareBowl;
import net.tropicraft.block.BlockEIHMixer;
import net.tropicraft.block.BlockFirePit;
import net.tropicraft.block.BlockFruitLeaves;
import net.tropicraft.block.BlockKoaChest;
import net.tropicraft.block.BlockMineralSands;
import net.tropicraft.block.BlockPalmLeaves;
import net.tropicraft.block.BlockPineapple;
import net.tropicraft.block.BlockPortalWall;
import net.tropicraft.block.BlockPurchasePlate;
import net.tropicraft.block.BlockPurifiedSand;
import net.tropicraft.block.BlockRainStopper;
import net.tropicraft.block.BlockRainforestLeaves;
import net.tropicraft.block.BlockSifter;
import net.tropicraft.block.BlockTallFlowers;
import net.tropicraft.block.BlockTikiTorch;
import net.tropicraft.block.BlockTropicraft;
import net.tropicraft.block.BlockTropicraftFence;
import net.tropicraft.block.BlockTropicraftFenceGate;
import net.tropicraft.block.BlockTropicraftFlower;
import net.tropicraft.block.BlockTropicraftFlowerPot;
import net.tropicraft.block.BlockTropicraftLog;
import net.tropicraft.block.BlockTropicraftMulti;
import net.tropicraft.block.BlockTropicraftOre;
import net.tropicraft.block.BlockTropicraftPlank;
import net.tropicraft.block.BlockTropicraftSapling;
import net.tropicraft.block.BlockTropicraftSlab;
import net.tropicraft.block.BlockTropicraftStairs;
import net.tropicraft.block.BlockTropicsPortal;
import net.tropicraft.block.BlockTropicsWater;
import net.tropicraft.info.TCNames;
import net.tropicraft.item.ItemBlockTropicraft;
import net.tropicraft.item.ItemPineapple;
import net.tropicraft.item.ItemTallFlowers;
import net.tropicraft.item.ItemTropicraftSlab;
import net.tropicraft.registry.TCFluidRegistry;

public class TCBlockRegistry {
    private static final Map<String, Class<? extends ItemBlock>> multiBlockMap = new HashMap<String, Class<? extends ItemBlock>>();
    public static final BlockTropicraft chunkOHead;
    public static final BlockTropicraftStairs chunkStairs;
    public static final Block eudialyteOre;
    public static final Block zirconOre;
    public static final Block azuriteOre;
    public static final BlockTropicraft oreBlocks;
    public static final BlockTropicraft thatchBundle;
    public static final BlockTropicraft coral;
    public static final BlockTropicraft bambooBundle;
    public static final BlockTropicraft logs;
    public static final BlockTropicraft planks;
    public static final BlockTropicraftStairs bambooStairs;
    public static final BlockTropicraftStairs thatchStairs;
    public static final BlockTropicraftStairs palmStairs;
    public static final BlockTropicraftStairs mahoganyStairs;
    public static final BlockPineapple pineapple;
    public static final BlockTallFlowers tallFlowers;
    public static final BlockTropicraftFenceGate bambooFenceGate;
    public static final BlockTropicraftFenceGate palmFenceGate;
    public static final BlockTropicraftFence bambooFence;
    public static final BlockTropicraftFence palmFence;
    public static final BlockTropicraftSapling saplings;
    public static final BlockTropicraft coffeePlant;
    public static final BlockTropicraft tikiTorch;
    public static final BlockDoor bambooDoor;
    public static final BlockSlab singleSlabs;
    public static final BlockSlab doubleSlabs;
    public static final BlockTropicsWater tropicsWater;
    public static final BlockTropicraft rainStopper;
    public static final BlockTropicraftFlower flowers;
    public static final BlockTropicraftFlowerPot flowerPot;
    public static final Block firePit;
    public static final BlockCoconut coconut;
    public static final BlockPortalWall tropicsPortalWall;
    public static final BlockTropicsPortal tropicsPortal;
    public static final BlockBambooChest bambooChest;
    public static final BlockFruitLeaves fruitLeaves;
    public static final BlockPalmLeaves palmLeaves;
    public static final BlockRainforestLeaves rainforestLeaves;
    public static final BlockBambooChute bambooChute;
    public static final BlockFalling purifiedSand;
    public static final BlockMineralSands mineralSands;
    public static final BlockSifter sifter;
    public static final BlockCurareBowl curareBowl;
    public static final BlockBongoDrum bongoDrum;
    public static final BlockKoaChest koaChest;
    public static final BlockPurchasePlate purchasePlate;
    public static final BlockBambooMug bambooMug;
    public static final BlockEIHMixer eihMixer;

    public static void init() {
        TCBlockRegistry.registerBlock(chunkOHead, "chunk");
        TCBlockRegistry.registerBlock((Block)chunkStairs, "chunkStairs");
        TCBlockRegistry.registerBlock(eudialyteOre, "oreEudialyte");
        TCBlockRegistry.registerBlock(zirconOre, "oreZircon");
        TCBlockRegistry.registerBlock(azuriteOre, "oreAzurite");
        TCBlockRegistry.registerMultiBlock(oreBlocks, "blockOre", TCNames.oreBlockNames);
        TCBlockRegistry.registerBlock(thatchBundle, "thatch");
        TCBlockRegistry.registerMultiBlock(coral, "coral", TCNames.coralNames);
        TCBlockRegistry.registerBlock(bambooBundle, "bambooBundle");
        TCBlockRegistry.registerMultiBlock(logs, "log", TCNames.logNames);
        Blocks.field_150480_ab.setFireInfo((Block)logs, 5, 5);
        TCBlockRegistry.registerMultiBlock(planks, "plank", TCNames.plankNames);
        Blocks.field_150480_ab.setFireInfo((Block)planks, 5, 5);
        TCBlockRegistry.registerBlock((Block)bambooStairs, "bambooStairs");
        TCBlockRegistry.registerBlock((Block)thatchStairs, "thatchStairs");
        TCBlockRegistry.registerBlock((Block)palmStairs, "palmStairs");
        TCBlockRegistry.registerBlock((Block)mahoganyStairs, "mahoganyStairs");
        TCBlockRegistry.registerMultiBlock((Block)tallFlowers, "tallFlower", TCNames.tallFlowerNames);
        TCBlockRegistry.registerMultiBlock((Block)pineapple, "pineapple", TCNames.pineappleNames);
        TCBlockRegistry.registerBlockNoName((Block)bambooFence, "bambooFence");
        TCBlockRegistry.registerBlockNoName((Block)palmFence, "palmFence");
        TCBlockRegistry.registerMultiBlock((Block)saplings, "sapling", TCNames.saplingNames);
        TCBlockRegistry.registerBlock(coffeePlant, "coffeePlant");
        TCBlockRegistry.registerBlock((Block)bambooFenceGate, "bambooFenceGate");
        TCBlockRegistry.registerBlock((Block)palmFenceGate, "palmFenceGate");
        Blocks.field_150480_ab.setFireInfo((Block)palmFenceGate, 5, 5);
        TCBlockRegistry.registerBlock(tikiTorch, "tikiTorch");
        TCBlockRegistry.registerBlock((Block)bambooDoor, "bambooDoor");
        TCBlockRegistry.registerMultiBlock((Block)singleSlabs, "singleSlabs", ItemTropicraftSlab.class, new Object[]{singleSlabs, doubleSlabs, false});
        TCBlockRegistry.registerMultiBlock((Block)doubleSlabs, "doubleSlabs", ItemTropicraftSlab.class, new Object[]{doubleSlabs, singleSlabs, true});
        TCBlockRegistry.registerBlock((Block)tropicsWater, "tropicsWater");
        TCBlockRegistry.registerBlock(rainStopper, "rainStopper");
        TCBlockRegistry.registerMultiBlock((Block)flowers, "flower", TCNames.flowerIndices);
        TCBlockRegistry.registerBlock(flowerPot, "flowerPot");
        TCBlockRegistry.registerBlock(coconut, "coconut");
        TCBlockRegistry.registerBlock(firePit, "firePit");
        TCBlockRegistry.registerBlock((Block)bambooChest, "bambooChest");
        TCBlockRegistry.registerBlock((Block)tropicsPortal, "portal");
        TCBlockRegistry.registerBlock((Block)tropicsPortalWall, "portalWall");
        TCBlockRegistry.registerMultiBlock((Block)fruitLeaves, "leaf", TCNames.fruitLeafNames);
        Blocks.field_150480_ab.setFireInfo((Block)fruitLeaves, 30, 60);
        TCBlockRegistry.registerBlock((Block)palmLeaves, "leafPalm");
        Blocks.field_150480_ab.setFireInfo((Block)palmLeaves, 30, 60);
        TCBlockRegistry.registerMultiBlock((Block)rainforestLeaves, "leafRainforest", TCNames.rainforestLeafNames);
        TCBlockRegistry.registerBlock(bambooChute, "bambooChute");
        TCBlockRegistry.registerBlock((Block)purifiedSand, "purifiedSand");
        TCBlockRegistry.registerMultiBlock((Block)mineralSands, "mineralSand", TCNames.mineralSandNames);
        TCBlockRegistry.registerBlock(sifter, "sifter");
        TCBlockRegistry.registerBlock(curareBowl, "curareBowl");
        TCBlockRegistry.registerMultiBlock(bongoDrum, "bongoDrum", TCNames.bongoDrumNames);
        TCBlockRegistry.registerBlock((Block)koaChest, "koaChest");
        TCBlockRegistry.registerBlock((Block)purchasePlate, "purchasePlate");
        TCBlockRegistry.registerBlock((Block)bambooMug, "bambooMug");
        TCBlockRegistry.registerBlock(eihMixer, "eihMixer");
    }

    private static void registerMultiBlock(Block block, String name, Class<? extends ItemBlock> c, Object[] params) {
        GameRegistry.registerBlock((Block)block, c, (String)("tile." + name), (Object[])params);
        block.func_149663_c(name);
    }

    private static void registerMultiBlock(Block block, String name, String[] names) {
        ArrayList namesList = new ArrayList();
        Collections.addAll(namesList, names);
        Class<ItemBlockTropicraft> clazz = multiBlockMap.containsKey(name) ? multiBlockMap.get(name) : ItemBlockTropicraft.class;
        GameRegistry.registerBlock((Block)block, clazz, (String)("tile." + name), (Object[])new Object[]{namesList});
        block.func_149663_c(name);
    }

    private static void registerBlock(Block block, String name) {
        GameRegistry.registerBlock((Block)block, (String)("tile." + name));
        block.func_149663_c(name);
    }

    private static void registerBlockNoName(Block block, String name) {
        GameRegistry.registerBlock((Block)block, (String)("tile." + name));
    }

    static {
        multiBlockMap.put("pineapple", ItemPineapple.class);
        multiBlockMap.put("tallFlower", ItemTallFlowers.class);
        multiBlockMap.put("singleSlabs", ItemSlab.class);
        multiBlockMap.put("doubleSlabs", ItemSlab.class);
        chunkOHead = new BlockChunkOHead();
        chunkStairs = new BlockTropicraftStairs("chunkStairs", chunkOHead, 0);
        eudialyteOre = new BlockTropicraftOre().func_149711_c(3.0f).func_149752_b(5.0f);
        zirconOre = new BlockTropicraftOre().func_149711_c(4.0f).func_149752_b(5.0f);
        azuriteOre = new BlockTropicraftOre().func_149711_c(3.0f).func_149752_b(5.0f);
        oreBlocks = new BlockTropicraftMulti(TCNames.oreBlockNames);
        thatchBundle = new BlockBundle("thatch");
        coral = new BlockCoral(TCNames.coralNames);
        bambooBundle = (BlockTropicraft)new BlockBundle("bambooBundle").func_149711_c(1.0f).func_149752_b(0.1f);
        logs = new BlockTropicraftLog(TCNames.logNames);
        planks = new BlockTropicraftPlank(TCNames.plankNames);
        bambooStairs = new BlockTropicraftStairs("bambooStairs", bambooBundle, 0);
        thatchStairs = new BlockTropicraftStairs("thatchStairs", thatchBundle, 0);
        palmStairs = new BlockTropicraftStairs("palmStairs", planks, 0);
        mahoganyStairs = new BlockTropicraftStairs("mahoganyStairs", planks, 3);
        pineapple = new BlockPineapple(TCNames.pineappleNames);
        tallFlowers = new BlockTallFlowers(TCNames.tallFlowerNames);
        bambooFenceGate = new BlockTropicraftFenceGate(bambooBundle, 0, "bambooFenceGate", Material.field_151575_d);
        palmFenceGate = new BlockTropicraftFenceGate(planks, 1, "palmFenceGate", Material.field_151575_d);
        bambooFence = new BlockTropicraftFence("bambooFence", "bambooBundle_Side", bambooFenceGate, Material.field_151575_d);
        palmFence = new BlockTropicraftFence("palmFence", "plank_" + TCNames.plankNames[0], palmFenceGate, Material.field_151575_d);
        saplings = new BlockTropicraftSapling(TCNames.saplingNames);
        coffeePlant = new BlockCoffeePlant();
        tikiTorch = new BlockTikiTorch();
        bambooDoor = new BlockBambooDoor();
        singleSlabs = new BlockTropicraftSlab(false);
        doubleSlabs = new BlockTropicraftSlab(true);
        tropicsWater = new BlockTropicsWater(TCFluidRegistry.tropicsWater, Material.field_151586_h);
        rainStopper = new BlockRainStopper();
        flowers = new BlockTropicraftFlower(TCNames.flowerIndices);
        flowerPot = new BlockTropicraftFlowerPot();
        firePit = new BlockFirePit();
        coconut = new BlockCoconut();
        tropicsPortalWall = new BlockPortalWall();
        tropicsPortal = new BlockTropicsPortal(TCFluidRegistry.tropicsPortal, Material.field_151586_h);
        bambooChest = new BlockBambooChest();
        fruitLeaves = new BlockFruitLeaves();
        palmLeaves = new BlockPalmLeaves();
        rainforestLeaves = new BlockRainforestLeaves();
        bambooChute = new BlockBambooChute();
        purifiedSand = new BlockPurifiedSand();
        mineralSands = new BlockMineralSands();
        sifter = new BlockSifter();
        curareBowl = new BlockCurareBowl();
        bongoDrum = new BlockBongoDrum(TCNames.bongoDrumNames);
        koaChest = new BlockKoaChest();
        purchasePlate = new BlockPurchasePlate();
        bambooMug = new BlockBambooMug();
        eihMixer = new BlockEIHMixer();
    }
}

