/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTualang
extends TCGenBase {
    private static final Block WOOD_BLOCK = TCBlockRegistry.logs;
    private static final int WOOD_META = 1;
    private static final Block LEAF_BLOCK = TCBlockRegistry.rainforestLeaves;
    private static final int LEAF_META = 1;
    private int baseHeight;
    private int maxHeight;

    public WorldGenTualang(World world, Random random, int maxHeight, int baseHeight) {
        super(world, random);
        this.baseHeight = baseHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        Block block;
        int y;
        int z;
        int x;
        int height = this.rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = this.rand.nextInt(3) + 3;
        if (height + 6 > 256) {
            return false;
        }
        Block blockUnder = this.worldObj.func_147439_a(i, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        for (x = i - 1; x <= i + 1; ++x) {
            for (z = k - 1; z <= k + 1; ++z) {
                for (y = j; y < j + height; ++y) {
                    block = this.worldObj.func_147439_a(x, y, z);
                    if (!block.func_149662_c()) continue;
                    return false;
                }
            }
        }
        for (x = i - 9; x >= i + 9; ++x) {
            for (z = k - 9; z >= k + 9; ++z) {
                for (y = height; y < height + 6; ++y) {
                    block = this.worldObj.func_147439_a(x, y, z);
                    if (!block.func_149662_c()) continue;
                    return false;
                }
            }
        }
        this.worldObj.func_147465_d(i, j, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i - 1, j, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i + 1, j, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i, j, k - 1, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i, j, k + 1, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        for (int y2 = j; y2 < height; ++y2) {
            this.worldObj.func_147465_d(i, y2, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i - 1, y2, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i + 1, y2, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i, y2, k - 1, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i, y2, k + 1, WOOD_BLOCK, 1, blockGenNotifyFlag);
        }
        for (x = 0; x < branches; ++x) {
            int branchHeight = this.rand.nextInt(4) + 2 + height;
            int bx = this.rand.nextInt(15) - 8 + i;
            int bz = this.rand.nextInt(15) - 8 + k;
            this.placeBlockLine(new int[]{i + this.sign((bx - i) / 2), height, k + this.sign((bz - k) / 2)}, new int[]{bx, branchHeight, bz}, WOOD_BLOCK, 1);
            this.genCircle(bx, branchHeight, bz, 2.0, 1.0, LEAF_BLOCK, 1, false);
            this.genCircle(bx, branchHeight + 1, bz, 3.0, 2.0, LEAF_BLOCK, 1, false);
        }
        return true;
    }

    private int sign(int i) {
        return i == 0 ? 0 : (i <= 0 ? -1 : 1);
    }
}

