/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.pathfinding;

import CoroUtil.ChunkCoordinatesSize;
import CoroUtil.DimensionChunkCache;
import CoroUtil.OldUtil;
import CoroUtil.componentAI.IAdvPF;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFCallbackItem;
import CoroUtil.pathfinding.PFJobData;
import CoroUtil.pathfinding.PathEntityEx;
import CoroUtil.pathfinding.PathEx;
import CoroUtil.pathfinding.PathPointEx;
import CoroUtil.pathfinding.c_IEnhPF;
import CoroUtil.util.CoroUtilBlock;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PFQueue
implements Runnable {
    public static PFQueue instance;
    public static LinkedList<PFJobData> queue;
    public static HashMap pfDelays;
    public static boolean renderLine;
    public static long maxRequestAge;
    public static long maxNodeIterations;
    public IBlockAccess worldMap;
    private PathEx path = new PathEx();
    private IntHashMap pointMap = new IntHashMap();
    private PathPointEx[] pathOptions = new PathPointEx[32];
    public boolean foundEnd;
    public boolean canClimb = false;
    public int maxClimbHeight = 30;
    public boolean canUseLadder = true;
    public long dropSize = 4L;
    public EntityCreature entH = null;
    public static int lastQueueSize;
    public static long lastSuccessPFTime;
    public static int lastChunkCacheCount;
    public long statsPerSecondLastReset = 0L;
    public int statsPerSecondPathSoFar = 0;
    public int statsPerSecondPathSkippedSoFar = 0;
    public int statsPerSecondNodeSoFar = 0;
    public int statsPerSecondNodeMaxIterSoFar = 0;
    public static int statsPerSecondPath;
    public static int statsPerSecondPathSkipped;
    public static int statsPerSecondNode;
    public static int statsPerSecondNodeMaxIter;
    public static int pfDelayScale;
    public static int pfDelayMax;
    public static boolean debug;
    public static long lastCacheUpdate;

    public PFQueue(IBlockAccess var1) {
        this(var1, true);
    }

    public PFQueue(IBlockAccess var1, boolean singleton) {
        if (instance == null && singleton) {
            System.out.println("Initializing PFQueue");
            instance = this;
            queue = new LinkedList();
            pfDelays = new HashMap();
            new Thread((Runnable)this, "Pathfinder Thread").start();
        }
        if (var1 != null) {
            this.worldMap = var1;
        }
    }

    @Override
    public void run() {
        while (this == instance) {
            try {
                this.manageQueue();
            }
            catch (Exception ex) {
                System.out.println("Serious PFQueue crash, reinitializing");
                instance = null;
            }
        }
        System.out.println("Old PFQueue thread end");
    }

    public void manageQueue() {
        maxRequestAge = 2000L;
        boolean give1NodePathIfFail = false;
        Random rand = new Random();
        if (this.statsPerSecondLastReset < System.currentTimeMillis() / 10000L) {
            this.statsPerSecondLastReset = System.currentTimeMillis() / 10000L;
            statsPerSecondNode = this.statsPerSecondNodeSoFar;
            statsPerSecondPath = this.statsPerSecondPathSoFar;
            statsPerSecondPathSkipped = this.statsPerSecondPathSkippedSoFar;
            statsPerSecondNodeMaxIter = this.statsPerSecondNodeMaxIterSoFar;
            this.statsPerSecondNodeSoFar = 0;
            this.statsPerSecondNodeMaxIterSoFar = 0;
            this.statsPerSecondPathSoFar = 0;
            this.statsPerSecondPathSkippedSoFar = 0;
        }
        try {
            for (Map.Entry pairs : pfDelays.entrySet()) {
                long time = (Long)pairs.getValue();
                if (time >= System.currentTimeMillis() - 30000L) continue;
                pfDelays.remove(pairs.getKey());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean processed = false;
        while (!processed && queue.size() > 0) {
            if (queue.size() <= 0) continue;
            lastQueueSize = queue.size();
            if (queue.size() > 50 && System.currentTimeMillis() % 2000L == 0L) {
                System.out.println("PF Size: " + queue.size());
            }
            try {
                block39: {
                    if (PFQueue.queue.get((int)0).timeCreated + maxRequestAge > System.currentTimeMillis()) {
                        processed = true;
                        this.path.clearPath();
                        this.pointMap.func_76046_c();
                        this.pathOptions = new PathPointEx[32];
                        this.foundEnd = false;
                        this.canClimb = false;
                        this.canUseLadder = true;
                        ++this.statsPerSecondPathSoFar;
                        try {
                            this.dbg("PF TRY: " + PFQueue.queue.get((int)0).retryState + " | " + PFQueue.queue.get((int)0).sourceEntity);
                            if (PFQueue.queue.get((int)0).sourceEntity instanceof EntityCreature) {
                                this.entH = (EntityCreature)PFQueue.queue.get((int)0).sourceEntity;
                            }
                            this.dropSize = PFQueue.queue.get((int)0).safeDropHeight;
                            this.canUseLadder = PFQueue.queue.get((int)0).canUseLadder;
                            if (PFQueue.queue.get((int)0).sourceEntity instanceof IAdvPF) {
                                this.canUseLadder = ((IAdvPF)PFQueue.queue.get((int)0).sourceEntity).canClimbLadders();
                                this.canClimb = ((IAdvPF)PFQueue.queue.get((int)0).sourceEntity).canClimbWalls();
                                this.dropSize = ((IAdvPF)PFQueue.queue.get((int)0).sourceEntity).getDropSize();
                            }
                            maxNodeIterations = PFQueue.queue.get((int)0).maxNodeIterations;
                            this.worldMap = DimensionChunkCache.dimCacheLookup.get(PFQueue.queue.get((int)0).source.dimensionId);
                            PathEntityEx pathEnt = null;
                            if (PFQueue.queue.get((int)0).sourceEntity != null) {
                                double dist = PFQueue.queue.get((int)0).sourceEntity.func_70011_f((double)PFQueue.queue.get((int)0).dest.field_71574_a, (double)PFQueue.queue.get((int)0).dest.field_71572_b, (double)PFQueue.queue.get((int)0).dest.field_71573_c);
                                if (dist > 256.0) {
                                    this.dbg("B PF: " + PFQueue.queue.get((int)0).retryState + " | " + dist + " | " + PFQueue.queue.get((int)0).sourceEntity);
                                }
                                if (PFQueue.queue.get((int)0).retryState > 0) {
                                    this.dbg("B PF: " + PFQueue.queue.get((int)0).retryState + " | " + dist + " | " + PFQueue.queue.get((int)0).sourceEntity);
                                    this.dbg("PF R: " + PFQueue.queue.get((int)0).retryState + "|" + PFQueue.queue.get((int)0).maxNodeIterations);
                                } else {
                                    this.dbg("run path");
                                }
                                pathEnt = this.createPathTo(queue.get(0));
                            } else {
                                pathEnt = this.createPathTo(PFQueue.queue.get((int)0).source, PFQueue.queue.get((int)0).dest.field_71574_a, PFQueue.queue.get((int)0).dest.field_71572_b, PFQueue.queue.get((int)0).dest.field_71573_c, PFQueue.queue.get((int)0).distMax, 0);
                            }
                            if (pathEnt != null) {
                                this.dbg("returned a path size: " + pathEnt.pathLength);
                                try {
                                    if (PFQueue.queue.get((int)0).retryState > 0) {
                                        this.dbg("PF SUCCESS: " + PFQueue.queue.get((int)0).retryState + "|" + PFQueue.queue.get((int)0).maxNodeIterations);
                                    }
                                }
                                catch (Exception ex) {
                                    System.out.println("this error happens a lot, new bug?");
                                    ex.printStackTrace();
                                }
                            }
                            if (pathEnt != null) {
                                this.setPath(pathEnt);
                                break block39;
                            }
                            if (PFQueue.queue.get((int)0).sourceEntity != null && PFQueue.queue.get((int)0).retryState < 4) {
                                int tries;
                                Entity ent = PFQueue.queue.get((int)0).sourceEntity;
                                int x = PFQueue.queue.get((int)0).dest.field_71574_a;
                                int y = PFQueue.queue.get((int)0).dest.field_71572_b;
                                int z = PFQueue.queue.get((int)0).dest.field_71573_c;
                                double d = (double)((float)x + 0.5f) - ent.field_70165_t;
                                double d2 = (double)((float)z + 0.5f) - ent.field_70161_v;
                                double d1 = (double)((float)y + 0.5f) - (ent.field_70163_u + (double)ent.func_70047_e());
                                double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                                float rotationPitch = -f3;
                                float rotationYaw = f2;
                                EntityLiving center = (EntityLiving)PFQueue.queue.get((int)0).sourceEntity;
                                float look = rand.nextInt(90) - 45;
                                double dist = rand.nextInt(26) + PFQueue.queue.get((int)0).retryState * 6;
                                int gatherX = (int)Math.floor(center.field_70165_t + -Math.sin((rotationYaw + look) / 180.0f * (float)Math.PI) * dist);
                                int gatherY = (int)center.field_70163_u;
                                int gatherZ = (int)Math.floor(center.field_70161_v + Math.cos((rotationYaw + look) / 180.0f * (float)Math.PI) * dist);
                                Block block = this.getBlock(gatherX, gatherY, gatherZ);
                                if (!CoroUtilBlock.isAir(block)) {
                                    int offset = -5;
                                    for (tries = 0; tries < 30 && !CoroUtilBlock.isAir(block) && block.isSideSolid(this.worldMap, gatherX, gatherY, gatherZ, ForgeDirection.UP); ++tries) {
                                        block = this.getBlock(gatherX, gatherY += offset++, gatherZ);
                                    }
                                } else {
                                    while (tries < 30 && (CoroUtilBlock.isAir(block) || !block.isSideSolid(this.worldMap, gatherX, gatherY, gatherZ, ForgeDirection.UP))) {
                                        block = this.getBlock(gatherX, --gatherY, gatherZ);
                                        ++tries;
                                    }
                                }
                                if (tries < 30) {
                                    this.dbg(tries + "|" + PFQueue.queue.get((int)0).retryState + " partial path try: " + PFQueue.queue.get((int)0).sourceEntity);
                                    PFQueue.queue.get((int)0).dest = new ChunkCoordinatesSize(gatherX, gatherY, gatherZ, PFQueue.queue.get((int)0).source.dimensionId, PFQueue.queue.get((int)0).source.width, PFQueue.queue.get((int)0).source.height);
                                    ++PFQueue.queue.get((int)0).retryState;
                                    queue.add(queue.get(0));
                                }
                                break block39;
                            }
                            if (give1NodePathIfFail) {
                                PathPointEx[] points = new PathPointEx[]{new PathPointEx(PFQueue.queue.get((int)0).dest.field_71574_a, PFQueue.queue.get((int)0).dest.field_71572_b, PFQueue.queue.get((int)0).dest.field_71573_c)};
                                this.setPath(new PathEntityEx(points));
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        ++this.statsPerSecondPathSkippedSoFar;
                        if (give1NodePathIfFail) {
                            PathPointEx[] points = new PathPointEx[]{new PathPointEx(PFQueue.queue.get((int)0).dest.field_71574_a, PFQueue.queue.get((int)0).dest.field_71572_b, PFQueue.queue.get((int)0).dest.field_71573_c)};
                            this.setPath(new PathEntityEx(points));
                        }
                    }
                }
                queue.remove(0);
            }
            catch (Exception ex) {
                try {
                    queue.clear();
                }
                catch (Exception ex2) {
                    queue.clear();
                }
            }
        }
        if (processed || queue.size() == 0) {
            try {
                int sleep = 50 - queue.size();
                if (processed) {
                    sleep = 3;
                }
                if (sleep < 1) {
                    sleep = 1;
                }
                Thread.sleep(sleep);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void setPath(PathEntityEx pathEnt) {
        lastSuccessPFTime = System.currentTimeMillis();
        if (PFQueue.queue.get((int)0).sourceEntity instanceof c_IEnhPF) {
            ((c_IEnhPF)PFQueue.queue.get((int)0).sourceEntity).setPathExToEntity(pathEnt);
        } else if (PFQueue.queue.get((int)0).sourceEntity instanceof ICoroAI) {
            ((ICoroAI)PFQueue.queue.get((int)0).sourceEntity).setPathResultToEntity(this.convertToPathEntity(pathEnt));
        } else if (PFQueue.queue.get((int)0).sourceEntity instanceof EntityPlayer) {
            OldUtil.playerPathfindCallback(pathEnt);
        } else if (PFQueue.queue.get((int)0).sourceEntity instanceof EntityCreeper) {
            if (PFQueue.queue.get((int)0).callback != null) {
                PFQueue.queue.get((int)0).callback.pfComplete(new PFCallbackItem(this.convertToPathEntity(pathEnt), (EntityLiving)PFQueue.queue.get((int)0).sourceEntity, 1.0f));
            } else {
                ((EntityLiving)PFQueue.queue.get((int)0).sourceEntity).func_70661_as().func_75484_a(this.convertToPathEntity(pathEnt), 1.0);
            }
        } else if (PFQueue.queue.get((int)0).sourceEntity instanceof EntityLiving) {
            if (PFQueue.queue.get((int)0).callback != null) {
                PFQueue.queue.get((int)0).callback.pfComplete(new PFCallbackItem(this.convertToPathEntity(pathEnt), (EntityLiving)PFQueue.queue.get((int)0).sourceEntity, 1.0f));
            } else {
                ((EntityLiving)PFQueue.queue.get((int)0).sourceEntity).func_70661_as().func_75484_a(this.convertToPathEntity(pathEnt), (double)Float.valueOf(1.0f).floatValue());
            }
        } else if (PFQueue.queue.get((int)0).callback != null) {
            PFQueue.queue.get((int)0).callback.pfComplete(new PFCallbackItem(this.convertToPathEntity(pathEnt), null, 1.0f));
        }
    }

    public synchronized void cleanup(Entity ent) {
    }

    public static boolean getPath(Entity var1, Entity var2, float var3) {
        return PFQueue.getPath(var1, var2, var3, 0);
    }

    public static boolean getPath(Entity var1, Entity var2, float var3, int priority) {
        return PFQueue.getPath(var1, var2, var3, priority, null);
    }

    public static boolean getPath(Entity var1, Entity var2, float var3, int priority, IPFCallback parCallback) {
        if (var1 != null && var2 != null) {
            return PFQueue.tryPath(var1, (int)Math.floor(var2.field_70165_t), (int)Math.floor(var2.field_70121_D.field_72338_b + 0.5), (int)Math.floor(var2.field_70161_v), var3, priority, parCallback);
        }
        return false;
    }

    public static boolean getPath(Entity var1, int x, int y, int z, float var2) {
        return PFQueue.getPath(var1, x, y, z, var2, 0);
    }

    public static boolean getPath(Entity var1, int x, int y, int z, float var2, int priority) {
        return PFQueue.getPath(var1, x, y, z, var2, priority, null);
    }

    public static boolean getPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return PFQueue.tryPath(var1, x, y, z, var2, priority, parCallback);
    }

    public static boolean getPath(ChunkCoordinatesSize coordSize, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return PFQueue.tryPath(null, x, y, z, var2, priority, parCallback, coordSize);
    }

    public static boolean tryPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return PFQueue.tryPath(var1, x, y, z, var2, priority, parCallback, null);
    }

    public static boolean tryPath(PFJobData parJob) {
        parJob.initData();
        if (instance == null) {
            new PFQueue(null);
        }
        if (lastCacheUpdate < System.currentTimeMillis()) {
            lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCache.updateAllWorldCache();
        }
        int delay = 3000 + queue.size() * 20;
        boolean tryPath = true;
        if (parJob.sourceEntity != null) {
            Entity var1 = parJob.sourceEntity;
            if (pfDelays.containsKey(var1)) {
                Object obj = pfDelays.get(var1);
                long time = 0L;
                if (obj != null) {
                    time = (Long)obj;
                }
                if (time < System.currentTimeMillis()) {
                    pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
                } else {
                    tryPath = false;
                }
            } else {
                pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
            }
        }
        if (tryPath || parJob.priority == -1) {
            try {
                if (parJob.priority == 0) {
                    queue.addLast(parJob);
                } else if (parJob.priority == -1) {
                    queue.addFirst(parJob);
                } else {
                    int pos = 0;
                    while (queue.size() > 0 && parJob.priority < PFQueue.queue.get((int)pos++).priority) {
                    }
                    queue.add(pos, parJob);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean tryPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback, ChunkCoordinatesSize parCoordSize) {
        if (var1 != null && CoroUtilBlock.isAir(var1.field_70170_p.func_147439_a(x, y - 1, z))) {
            while (CoroUtilBlock.isAir(var1.field_70170_p.func_147439_a(x, --y, z)) && y > 0) {
                --y;
            }
        }
        if (instance == null) {
            if (var1 == null) {
                return false;
            }
            new PFQueue(null);
        }
        if (lastCacheUpdate < System.currentTimeMillis()) {
            lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCache.updateAllWorldCache();
        }
        int delay = 3000 + queue.size() * 20;
        boolean tryPath = true;
        if (pfDelays.containsKey(var1)) {
            Object obj = pfDelays.get(var1);
            long time = 0L;
            if (obj != null) {
                time = (Long)obj;
            }
            if (time < System.currentTimeMillis()) {
                pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
            } else {
                tryPath = false;
            }
        } else {
            pfDelays.put(var1, System.currentTimeMillis() + (long)delay);
        }
        if (tryPath || priority == -1) {
            if (priority == -1) {
                boolean hwta = false;
            }
            PFJobData job = null;
            if (var1 != null) {
                job = new PFJobData(var1, x, y, z, var2);
                job.callback = parCallback;
                job.canUseLadder = true;
            } else if (parCoordSize != null) {
                job = new PFJobData(parCoordSize, x, y, z, var2);
                job.callback = parCallback;
                job.canUseLadder = true;
            } else {
                System.out.println("invalid use of PFQueue");
            }
            try {
                if (priority == 0) {
                    queue.addLast(job);
                } else if (priority == -1) {
                    queue.addFirst(job);
                } else {
                    int pos = 0;
                    while (queue.size() > 0 && priority < PFQueue.queue.get((int)pos++).priority) {
                    }
                    queue.add(pos, job);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (var1 != null) {
                // empty if block
            }
            if (var1 instanceof c_IEnhPF) {
                c_IEnhPF entC = (c_IEnhPF)var1;
            } else if (var1 instanceof EntityLiving) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public PathEntity convertToPathEntity(PathEntityEx pathEx) {
        if (pathEx != null) {
            PathPoint[] points = new PathPoint[pathEx.pathLength];
            for (int i = 0; i < points.length; ++i) {
                int y = pathEx.points[i].yCoord;
                points[i] = new PathPoint(pathEx.points[i].xCoord, y, pathEx.points[i].zCoord);
            }
            return new PathEntity(points);
        }
        return null;
    }

    public PathEntityEx createPathTo(PFJobData parJob) {
        Block block = this.getBlock(parJob.source.field_71574_a, parJob.source.field_71572_b, parJob.source.field_71573_c);
        if (PFQueue.isFenceLike(block)) {
            if (parJob.sourceEntity != null) {
                double bestDist = 99999.0;
                ChunkCoordinatesSize bestCoords = null;
                Random rand = new Random();
                double dist = parJob.sourceEntity.func_70011_f((double)parJob.source.field_71574_a + 1.5, (double)parJob.source.field_71572_b, (double)parJob.source.field_71573_c + 0.5);
                ChunkCoordinatesSize coords = new ChunkCoordinatesSize(parJob.source.field_71574_a + 1, parJob.source.field_71572_b, parJob.source.field_71573_c, parJob.source.dimensionId, parJob.source.width, parJob.source.height);
                if (CoroUtilBlock.isAir(this.getBlock(coords.field_71574_a, coords.field_71572_b + 1, coords.field_71573_c)) && dist < bestDist && rand.nextInt(4) == 0) {
                    bestDist = dist;
                    bestCoords = coords;
                }
                dist = parJob.sourceEntity.func_70011_f((double)parJob.source.field_71574_a + 0.5, (double)parJob.source.field_71572_b, (double)parJob.source.field_71573_c + 1.5);
                coords = new ChunkCoordinatesSize(parJob.source.field_71574_a, parJob.source.field_71572_b, parJob.source.field_71573_c + 1, parJob.source.dimensionId, parJob.source.width, parJob.source.height);
                if (CoroUtilBlock.isAir(this.getBlock(coords.field_71574_a, coords.field_71572_b + 1, coords.field_71573_c)) && dist < bestDist && rand.nextInt(4) == 0) {
                    bestDist = dist;
                    bestCoords = coords;
                }
                dist = parJob.sourceEntity.func_70011_f((double)parJob.source.field_71574_a - 1.5, (double)parJob.source.field_71572_b, (double)parJob.source.field_71573_c + 0.5);
                coords = new ChunkCoordinatesSize(parJob.source.field_71574_a - 1, parJob.source.field_71572_b, parJob.source.field_71573_c, parJob.source.dimensionId, parJob.source.width, parJob.source.height);
                if (CoroUtilBlock.isAir(this.getBlock(coords.field_71574_a, coords.field_71572_b + 1, coords.field_71573_c)) && dist < bestDist && rand.nextInt(4) == 0) {
                    bestDist = dist;
                    bestCoords = coords;
                }
                dist = parJob.sourceEntity.func_70011_f((double)parJob.source.field_71574_a + 0.5, (double)parJob.source.field_71572_b, (double)parJob.source.field_71573_c - 1.5);
                coords = new ChunkCoordinatesSize(parJob.source.field_71574_a, parJob.source.field_71572_b, parJob.source.field_71573_c - 1, parJob.source.dimensionId, parJob.source.width, parJob.source.height);
                if (CoroUtilBlock.isAir(this.getBlock(coords.field_71574_a, coords.field_71572_b + 1, coords.field_71573_c)) && dist < bestDist && rand.nextInt(4) == 0) {
                    bestDist = dist;
                    bestCoords = coords;
                }
                if (bestCoords != null) {
                    parJob.source = bestCoords;
                }
            } else {
                ++parJob.source.field_71572_b;
            }
        }
        PathPointEx startPoint = this.openPoint(MathHelper.func_76128_c((double)parJob.source.field_71574_a), MathHelper.func_76128_c((double)parJob.source.field_71572_b), MathHelper.func_76128_c((double)parJob.source.field_71573_c));
        PathPointEx endPoint = this.openPoint(MathHelper.func_76128_c((double)((double)parJob.dest.field_71574_a - (double)(parJob.source.width / 2.0f))), MathHelper.func_76128_c((double)parJob.dest.field_71572_b), MathHelper.func_76128_c((double)((double)parJob.dest.field_71573_c - (double)(parJob.source.width / 2.0f))));
        PathPointEx size = new PathPointEx((int)Math.ceil(parJob.source.width), (int)Math.ceil(parJob.source.height), (int)Math.ceil(parJob.source.width));
        PathEntityEx var12 = this.addToPath(parJob, startPoint, endPoint, size, parJob.distMax);
        if (parJob == null || parJob.sourceEntity != null) {
            // empty if block
        }
        return var12;
    }

    public PathEntityEx createEntityPathTo(Entity var1, Entity var2, float var3) {
        return this.createEntityPathTo(var1, var2.field_70165_t, var2.field_70121_D.field_72338_b, var2.field_70161_v, var3);
    }

    @Deprecated
    public PathEntityEx createEntityPathTo(Entity var1, int var2, int var3, int var4, float var5) {
        int y = 0;
        Block block = this.getBlock(MathHelper.func_76128_c((double)var1.field_70121_D.field_72340_a), MathHelper.func_76128_c((double)var1.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)var1.field_70121_D.field_72339_c));
        if (block instanceof BlockSlab) {
            ++y;
        }
        return this.createEntityPathTo(var1, var2, var3, var4, var5, y);
    }

    @Deprecated
    public PathEntityEx createEntityPathTo(Entity var1, double var2, double var4, double var6, float var8) {
        return this.createEntityPathTo(var1, var2, var4, var6, var8, 0);
    }

    @Deprecated
    public PathEntityEx createPathTo(ChunkCoordinatesSize parCoordSize, double var2, double var4, double var6, float parMaxDistPF, int yOffset) {
        PathPointEx startPoint = this.openPoint(MathHelper.func_76128_c((double)parCoordSize.field_71574_a), MathHelper.func_76128_c((double)parCoordSize.field_71572_b) + yOffset, MathHelper.func_76128_c((double)parCoordSize.field_71573_c));
        PathPointEx endPoint = this.openPoint(MathHelper.func_76128_c((double)(var2 - (double)(parCoordSize.width / 2.0f))), MathHelper.func_76128_c((double)var4), MathHelper.func_76128_c((double)(var6 - (double)(parCoordSize.width / 2.0f))));
        PathPointEx size = new PathPointEx(MathHelper.func_76141_d((float)(parCoordSize.width + 1.0f)), MathHelper.func_76141_d((float)(parCoordSize.height + 1.0f)), MathHelper.func_76141_d((float)(parCoordSize.width + 1.0f)));
        PathEntityEx var12 = this.addToPath(null, startPoint, endPoint, size, parMaxDistPF);
        return var12;
    }

    @Deprecated
    public PathEntityEx createEntityPathTo(Entity var1, double var2, double var4, double var6, float var8, int yOffset) {
        PathPointEx var11;
        PathPointEx var10;
        PathPointEx var9 = this.openPoint(MathHelper.func_76128_c((double)var1.field_70121_D.field_72340_a), MathHelper.func_76128_c((double)var1.field_70121_D.field_72338_b) + yOffset, MathHelper.func_76128_c((double)var1.field_70121_D.field_72339_c));
        PathEntityEx var12 = this.addToPath(null, var9, var10 = this.openPoint(MathHelper.func_76128_c((double)(var2 - (double)(var1.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)var4), MathHelper.func_76128_c((double)(var6 - (double)(var1.field_70130_N / 2.0f)))), var11 = new PathPointEx(MathHelper.func_76141_d((float)(var1.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(var1.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(var1.field_70130_N + 1.0f))), var8);
        if (var12 != null) {
            // empty if block
        }
        return var12;
    }

    private PathEntityEx addToPath(PFJobData parJob, PathPointEx parStartPoint, PathPointEx endPoint, PathPointEx size, float parMaxDistPF) {
        parStartPoint.totalPathDistance = 0.0f;
        parStartPoint.distanceToTarget = parStartPoint.distanceToNext = parStartPoint.distanceTo(endPoint);
        this.path.clearPath();
        this.path.addPoint(parStartPoint);
        PathPointEx curPoint = parStartPoint;
        int lookCount = 0;
        int sleepCount = 0;
        long maxNodeIts = maxNodeIterations;
        if (parJob != null) {
            maxNodeIts = parJob.maxNodeIterations;
        }
        boolean lastIterationProgressed = false;
        while (!this.path.isPathEmpty() && (long)lookCount++ < maxNodeIts) {
            ++this.statsPerSecondNodeSoFar;
            try {
                if (sleepCount++ > 100) {
                    Thread.sleep(1L);
                    sleepCount = 0;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            PathPointEx nextBestPoint = this.path.dequeue();
            if (nextBestPoint.equals(endPoint)) {
                this.postPF(parJob, endPoint, nextBestPoint, lookCount);
                return this.createEntityPath(parStartPoint, endPoint);
            }
            if (nextBestPoint.distanceTo(endPoint) < curPoint.distanceTo(endPoint)) {
                curPoint = nextBestPoint;
            }
            nextBestPoint.isFirst = true;
            int var8 = this.findPathOptions(parJob, nextBestPoint, size, endPoint, parMaxDistPF);
            for (int var9 = 0; var9 < var8; ++var9) {
                PathPointEx potentialPoint = this.pathOptions[var9];
                float potentialPointPathDist = nextBestPoint.totalPathDistance + nextBestPoint.distanceTo(potentialPoint);
                if (potentialPoint.isAssigned() && !(potentialPointPathDist < potentialPoint.totalPathDistance)) continue;
                potentialPoint.previous = nextBestPoint;
                potentialPoint.totalPathDistance = potentialPointPathDist;
                potentialPoint.distanceToNext = potentialPoint.distanceTo(endPoint);
                lastIterationProgressed = true;
                if (potentialPoint.isAssigned()) {
                    this.path.changeDistance(potentialPoint, potentialPoint.totalPathDistance + potentialPoint.distanceToNext);
                    continue;
                }
                potentialPoint.distanceToTarget = potentialPoint.totalPathDistance + potentialPoint.distanceToNext;
                this.path.addPoint(potentialPoint);
            }
            if (!lastIterationProgressed && parJob != null && parJob.mapOutPathfind) {
                boolean proxFail = false;
                for (int j = 0; j < parJob.listConnectablePoints.size(); ++j) {
                    if (!(Math.sqrt(parJob.listConnectablePoints.get(j).func_71569_e(nextBestPoint.xCoord, nextBestPoint.yCoord, nextBestPoint.zCoord)) < (double)parJob.mapOutDistBetweenPoints)) continue;
                    proxFail = true;
                    break;
                }
                if (!proxFail) {
                    parJob.listConnectablePoints.add(new ChunkCoordinates(nextBestPoint.xCoord, nextBestPoint.yCoord, nextBestPoint.zCoord));
                }
            }
            lastIterationProgressed = false;
        }
        if ((long)lookCount >= maxNodeIts) {
            ++this.statsPerSecondNodeMaxIterSoFar;
        }
        this.postPF(parJob, endPoint, curPoint, lookCount);
        if (curPoint == parStartPoint) {
            return null;
        }
        return this.createEntityPath(parStartPoint, curPoint);
    }

    public void postPF(PFJobData parJob, PathPointEx source, PathPointEx dest, int lookCount) {
        if (Math.abs(source.xCoord - dest.xCoord) < 2 && Math.abs(source.yCoord - dest.yCoord) < 2 && Math.abs(source.zCoord - dest.zCoord) < 2) {
            this.foundEnd = true;
            if (parJob != null) {
                parJob.foundEnd = this.foundEnd;
            }
        }
        if (parJob != null) {
            if (parJob.sourceEntity != null) {
                pfDelays.put(parJob.sourceEntity, Math.min((long)((double)System.currentTimeMillis() + (double)lookCount * ((double)pfDelayScale / 10.0)), (long)pfDelayMax));
            }
            String info = String.valueOf("FE: " + this.foundEnd + " - LC: " + lookCount);
            parJob.pfComplete();
        }
    }

    private int findPathOptions(PFJobData parJob, PathPointEx curPoint, PathPointEx size, PathPointEx endPoint, float var5) {
        PathPointEx vvar11;
        PathPointEx vvar10;
        PathPointEx vvar9;
        PathPointEx vvar8;
        int var6 = 0;
        int var7 = 0;
        Entity sourceEntity = null;
        if (parJob != null) {
            sourceEntity = parJob.sourceEntity;
        }
        if (this.getVerticalOffset(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord + 1, curPoint.zCoord, size) == 1) {
            var7 = 1;
        }
        PathPointEx var8 = this.getSafePoint(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord + 1, size, var7);
        PathPointEx var9 = this.getSafePoint(parJob, sourceEntity, curPoint.xCoord - 1, curPoint.yCoord, curPoint.zCoord, size, var7);
        PathPointEx var10 = this.getSafePoint(parJob, sourceEntity, curPoint.xCoord + 1, curPoint.yCoord, curPoint.zCoord, size, var7);
        PathPointEx var11 = this.getSafePoint(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord - 1, size, var7);
        if (var8 != null && !var8.isFirst && var8.distanceTo(endPoint) < var5) {
            this.pathOptions[var6++] = var8;
        }
        if (var9 != null && !var9.isFirst && var9.distanceTo(endPoint) < var5) {
            this.pathOptions[var6++] = var9;
        }
        if (var10 != null && !var10.isFirst && var10.distanceTo(endPoint) < var5) {
            this.pathOptions[var6++] = var10;
        }
        if (var11 != null && !var11.isFirst && var11.distanceTo(endPoint) < var5) {
            this.pathOptions[var6++] = var11;
        }
        if (parJob.useFlyPathfinding || parJob.useSwimPathfinding) {
            PathPointEx var12 = this.getSafePoint(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord + 1, curPoint.zCoord, size, var7);
            PathPointEx var13 = this.getSafePoint(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord - 1, curPoint.zCoord, size, var7);
            if (var12 != null && !var12.isFirst && var12.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = var12;
            }
            if (var13 != null && !var13.isFirst && var13.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = var13;
            }
        }
        if (parJob != null && parJob.climbHeight > 1) {
            vvar8 = this.getClimbPoint(parJob, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord + 1, size, var7, curPoint.xCoord, curPoint.zCoord);
            vvar9 = this.getClimbPoint(parJob, curPoint.xCoord - 1, curPoint.yCoord, curPoint.zCoord, size, var7, curPoint.xCoord, curPoint.zCoord);
            vvar10 = this.getClimbPoint(parJob, curPoint.xCoord + 1, curPoint.yCoord, curPoint.zCoord, size, var7, curPoint.xCoord, curPoint.zCoord);
            vvar11 = this.getClimbPoint(parJob, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord - 1, size, var7, curPoint.xCoord, curPoint.zCoord);
            if (vvar8 != null && !vvar8.isFirst && vvar8.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar8;
            }
            if (vvar9 != null && !vvar9.isFirst && vvar9.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar9;
            }
            if (vvar10 != null && !vvar10.isFirst && vvar10.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar10;
            }
            if (vvar11 != null && !vvar11.isFirst && vvar11.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar11;
            }
        }
        if (this.canUseLadder && !CoroUtilBlock.isAir(this.getBlock(curPoint.xCoord, curPoint.yCoord, curPoint.zCoord)) && this.getBlock(curPoint.xCoord, curPoint.yCoord, curPoint.zCoord).isLadder(this.worldMap, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord, null)) {
            vvar8 = this.getLadderPoint(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord + 1, size, var7, curPoint.xCoord, curPoint.zCoord);
            vvar9 = this.getLadderPoint(parJob, sourceEntity, curPoint.xCoord - 1, curPoint.yCoord, curPoint.zCoord, size, var7, curPoint.xCoord, curPoint.zCoord);
            vvar10 = this.getLadderPoint(parJob, sourceEntity, curPoint.xCoord + 1, curPoint.yCoord, curPoint.zCoord, size, var7, curPoint.xCoord, curPoint.zCoord);
            vvar11 = this.getLadderPoint(parJob, sourceEntity, curPoint.xCoord, curPoint.yCoord, curPoint.zCoord - 1, size, var7, curPoint.xCoord, curPoint.zCoord);
            if (vvar8 != null && !vvar8.isFirst && vvar8.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar8;
            }
            if (vvar9 != null && !vvar9.isFirst && vvar9.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar9;
            }
            if (vvar10 != null && !vvar10.isFirst && vvar10.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar10;
            }
            if (vvar11 != null && !vvar11.isFirst && vvar11.distanceTo(endPoint) < var5) {
                this.pathOptions[var6++] = vvar11;
            }
        }
        return var6;
    }

    private PathPointEx getLadderPoint(PFJobData parJob, Entity var1, int x, int y, int z, PathPointEx var5, int var6, int origX, int origZ) {
        PathPointEx var7 = null;
        if (this.getVerticalOffset(parJob, var1, x, y, z, var5) == 1) {
            var7 = this.openPoint(x, y, z);
        }
        if (var7 == null && var6 > 0 && this.getVerticalOffset(parJob, var1, x, y + var6, z, var5) == 1) {
            var7 = this.openPoint(x, y + var6, z);
            y += var6;
        }
        if (var7 == null) {
            int var8 = 0;
            int var9 = 0;
            int var10 = 0;
            while (y > 0 && y < 256 && (var9 = this.getVerticalOffset(parJob, var1, x, y + 1, z, var5)) == 0 && !CoroUtilBlock.isAir(this.getBlock(origX, y + 1, origZ)) && this.getBlock(origX, y + 1, origZ).isLadder(null, origX, y, origZ, null)) {
                var10 = this.getVerticalOffset(parJob, var1, origX, y + 1, origZ, var5);
                ++var8;
                if (++y <= 0 || y >= 256) continue;
                var7 = this.openPoint(x, y + 1, z);
            }
            if (var10 != 1) {
                return null;
            }
            if (var9 == -2) {
                return null;
            }
        }
        return var7;
    }

    private PathPointEx getClimbPoint(PFJobData parJob, int x, int y, int z, PathPointEx var5, int var6, int origX, int origZ) {
        PathPointEx var7 = null;
        if (this.getVerticalOffset(parJob, parJob.sourceEntity, x, y, z, var5) == 1) {
            var7 = this.openPoint(x, y, z);
        }
        if (var7 == null && var6 > 0 && this.getVerticalOffset(parJob, parJob.sourceEntity, x, y + var6, z, var5) == 1) {
            var7 = this.openPoint(x, y + var6, z);
            y += var6;
        }
        if (var7 == null) {
            int var8 = 0;
            int var9 = 0;
            int var10 = 0;
            while (y > 0 && y < 256 && (var9 = this.getVerticalOffset(parJob, parJob.sourceEntity, x, y, z, var5)) == 0 && (var10 = this.getVerticalOffset(parJob, parJob.sourceEntity, origX, y, origZ, var5)) == 1 && (var10 = this.getVerticalOffset(parJob, parJob.sourceEntity, origX, y + 1, origZ, var5)) == 1) {
                if (++var8 >= parJob.climbHeight + 1) {
                    return null;
                }
                if (++y <= 0 || y >= 256) continue;
                var7 = this.openPoint(x, y, z);
            }
            if (var10 != 1) {
                return null;
            }
            if (var9 == -2) {
                return null;
            }
        }
        return var7;
    }

    private PathPointEx getSafePoint(PFJobData parJob, Entity var1, int var2, int var3, int var4, PathPointEx size, int var6) {
        PathPointEx var7 = null;
        if (this.getVerticalOffset(parJob, var1, var2, var3, var4, size) == 1) {
            var7 = this.openPoint(var2, var3, var4);
        }
        if (var7 == null && var6 > 0 && this.getVerticalOffset(parJob, var1, var2, var3 + var6, var4, size) == 1) {
            var7 = this.openPoint(var2, var3 + var6, var4);
            var3 += var6;
        }
        if (!parJob.useFlyPathfinding && var7 != null) {
            int var8 = 0;
            int var9 = 0;
            while (var3 > 0 && (var9 = this.getVerticalOffset(parJob, var1, var2, var3 - 1, var4, size)) == 1) {
                if ((long)(++var8) >= this.dropSize) {
                    return null;
                }
                if (--var3 <= 0) continue;
                var7 = this.openPoint(var2, var3, var4);
            }
            if (var9 == -2) {
                return null;
            }
        }
        return var7;
    }

    private final PathPointEx openPoint(int var1, int var2, int var3) {
        int var4 = PathPointEx.makeHash(var1, var2, var3);
        PathPointEx var5 = (PathPointEx)this.pointMap.func_76041_a(var4);
        if (var5 == null) {
            var5 = new PathPointEx(var1, var2, var3);
            this.pointMap.func_76038_a(var4, (Object)var5);
        }
        return var5;
    }

    private int getVerticalOffset(PFJobData parJob, Entity var1, int var2, int var3, int var4, PathPointEx size) {
        for (int var6 = var2; var6 < var2 + size.xCoord; ++var6) {
            for (int var7 = var3; var7 < var3 + size.yCoord; ++var7) {
                for (int var8 = var4; var8 < var4 + size.zCoord; ++var8) {
                    int override;
                    Block var9 = this.getBlock(var6, var7, var8);
                    if (CoroUtilBlock.isAir(var9)) continue;
                    if (PFQueue.isFenceLike(var9)) {
                        return -2;
                    }
                    Material var11 = var9.func_149688_o();
                    int meta = this.getBlockMetadata(var2, var3, var4);
                    int noOverrideID = -66;
                    if (var1 instanceof ICoroAI && var1 instanceof IAdvPF && (override = ((IAdvPF)var1).overrideBlockPathOffset((ICoroAI)var1, var9, meta, var2, var3, var4)) != noOverrideID) {
                        return override;
                    }
                    if (OldUtil.isNoPathBlock(var1, var9, meta)) {
                        return 2;
                    }
                    if (var11 == Material.field_151594_q || var11 == Material.field_151597_y || var11 == Material.field_151585_k) {
                        return 1;
                    }
                    if (PFQueue.isPressurePlate(var9)) {
                        return 1;
                    }
                    if (var11.func_76220_a()) {
                        return 0;
                    }
                    if (PFQueue.isNotPathable(var9)) {
                        return -2;
                    }
                    if (var11 == Material.field_151586_h) {
                        if (parJob.useSwimPathfinding) {
                            return 1;
                        }
                        return -1;
                    }
                    if (var11 == Material.field_151587_i || var11 == Material.field_151570_A) {
                        return -2;
                    }
                    if (!var9.func_149655_b(this.worldMap, var6, var7, var8)) continue;
                    return -2;
                }
            }
        }
        return 1;
    }

    private PathEntityEx createEntityPath(PathPointEx var1, PathPointEx var2) {
        int var3 = 1;
        PathPointEx var4 = var2;
        while (var4.previous != null) {
            ++var3;
            var4 = var4.previous;
        }
        PathPointEx[] var5 = new PathPointEx[var3];
        var4 = var2;
        var5[--var3] = var2;
        while (var4.previous != null) {
            var4 = var4.previous;
            var5[--var3] = var4;
        }
        return new PathEntityEx(var5);
    }

    public PathEntityEx simplifyPath(PFJobData parJob, PathEntityEx pathentity, PathPointEx pathpoint) {
        if (pathentity == null) {
            return pathentity;
        }
        LinkedList<PathPointEx> linkedlist = new LinkedList<PathPointEx>();
        PathPointEx pathpoint1 = null;
        PathPointEx pathpoint2 = null;
        PathPointEx pathpoint3 = null;
        PathPointEx[] apathpoint = pathentity.points;
        int j = apathpoint.length;
        int sleepCount = 0;
        for (int k = 0; k < j; ++k) {
            try {
                if (sleepCount++ > 10) {
                    Thread.sleep(1L);
                    sleepCount = 0;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            PathPointEx pathpoint4 = apathpoint[k];
            if (pathpoint1 == null) {
                pathpoint1 = pathpoint4;
                linkedlist.add(pathpoint4);
                continue;
            }
            if (pathpoint2 == null) {
                if (pathpoint1.yCoord != pathpoint4.yCoord) {
                    pathpoint1 = pathpoint4;
                    linkedlist.add(pathpoint4);
                    continue;
                }
                pathpoint2 = pathpoint4;
                continue;
            }
            if (pathpoint2.yCoord != pathpoint4.yCoord) {
                linkedlist.add(pathpoint2);
                linkedlist.add(pathpoint4);
                pathpoint1 = pathpoint4;
                pathpoint2 = null;
                continue;
            }
            int l = pathpoint4.xCoord - pathpoint1.xCoord;
            int i1 = pathpoint4.zCoord - pathpoint1.zCoord;
            if (Math.abs(l) < Math.abs(i1)) {
                float f = 0.0f;
                float f2 = (float)l / (float)Math.abs(i1);
                int byte0 = 1;
                if (i1 < 0) {
                    byte0 = -1;
                }
                for (int j1 = 1; j1 < Math.abs(i1); ++j1) {
                    if (this.getVerticalOffset(parJob, null, pathpoint1.xCoord + (int)Math.floor(f), pathpoint1.yCoord, pathpoint1.zCoord + j1 * byte0, pathpoint) != 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + (int)Math.floor(f), pathpoint1.yCoord - 1, pathpoint1.zCoord + j1 * byte0, pathpoint) == 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + (int)Math.floor(f) + 1, pathpoint1.yCoord, pathpoint1.zCoord + j1 * byte0, pathpoint) != 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + (int)Math.floor(f) + 1, pathpoint1.yCoord - 1, pathpoint1.zCoord + j1 * byte0, pathpoint) == 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + (int)Math.floor(f) - 1, pathpoint1.yCoord, pathpoint1.zCoord + j1 * byte0, pathpoint) != 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + (int)Math.floor(f) - 1, pathpoint1.yCoord - 1, pathpoint1.zCoord + j1 * byte0, pathpoint) == 1) {
                        pathpoint1 = pathpoint2;
                        linkedlist.add(pathpoint2);
                        pathpoint2 = pathpoint4;
                        continue;
                    }
                    f += f2;
                }
            } else {
                float f1 = 0.0f;
                float f3 = (float)i1 / (float)Math.abs(l);
                int byte1 = 1;
                if (l < 0) {
                    byte1 = -1;
                }
                for (int k1 = 1; k1 < Math.abs(l); ++k1) {
                    if (this.getVerticalOffset(parJob, null, pathpoint1.xCoord + k1 * byte1, pathpoint1.yCoord, pathpoint1.zCoord + (int)Math.floor(f1), pathpoint) != 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + k1 * byte1, pathpoint1.yCoord - 1, pathpoint1.zCoord + (int)Math.floor(f1), pathpoint) == 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + k1 * byte1, pathpoint1.yCoord, pathpoint1.zCoord + (int)Math.floor(f1) + 1, pathpoint) != 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + k1 * byte1, pathpoint1.yCoord - 1, pathpoint1.zCoord + (int)Math.floor(f1) + 1, pathpoint) == 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + k1 * byte1, pathpoint1.yCoord, pathpoint1.zCoord + (int)Math.floor(f1) - 1, pathpoint) != 1 || this.getVerticalOffset(parJob, null, pathpoint1.xCoord + k1 * byte1, pathpoint1.yCoord - 1, pathpoint1.zCoord + (int)Math.floor(f1) - 1, pathpoint) == 1) {
                        pathpoint1 = pathpoint2;
                        linkedlist.add(pathpoint2);
                        pathpoint2 = pathpoint4;
                        continue;
                    }
                    f1 += f3;
                }
            }
            pathpoint3 = pathpoint4;
        }
        if (pathpoint3 != null) {
            linkedlist.add(pathpoint3);
        } else if (pathpoint2 != null) {
            linkedlist.add(pathpoint2);
        }
        int i = 0;
        PathPointEx[] apathpoint1 = new PathPointEx[linkedlist.size()];
        for (PathPointEx pathpoint5 : linkedlist) {
            apathpoint1[i++] = pathpoint5;
        }
        return new PathEntityEx(apathpoint1);
    }

    private Block getBlock(int x, int y, int z) {
        return this.worldMap.func_147439_a(x, y, z);
    }

    private int getBlockMetadata(int x, int y, int z) {
        return this.worldMap.func_72805_g(x, y, z);
    }

    public void dbg(Object obj) {
    }

    public static boolean isFenceLike(Block block) {
        return block == Blocks.field_150422_aJ || block == Blocks.field_150411_aY || block == Blocks.field_150396_be || block == Blocks.field_150463_bK || block == Blocks.field_150386_bk;
    }

    public static boolean isPressurePlate(Block block) {
        return block == Blocks.field_150445_bS || block == Blocks.field_150443_bT || block == Blocks.field_150456_au || block == Blocks.field_150452_aw;
    }

    public static boolean isNotPathable(Block block) {
        return block == Blocks.field_150381_bn;
    }

    static {
        pfDelays = new HashMap();
        renderLine = true;
        maxRequestAge = 8000L;
        maxNodeIterations = 15000L;
        lastQueueSize = 0;
        lastSuccessPFTime = 0L;
        lastChunkCacheCount = 0;
        statsPerSecondPath = 0;
        statsPerSecondPathSkipped = 0;
        statsPerSecondNode = 0;
        statsPerSecondNodeMaxIter = 0;
        pfDelayScale = 5;
        pfDelayMax = 500;
        debug = true;
        lastCacheUpdate = 0L;
    }
}

