/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

class Installer {
    static int filesCopied = 0;
    static ProgressMonitor progressMonitor;

    Installer() {
    }

    public static void install() {
        String curDir = System.getProperty("user.dir");
        File minecraftDir = Installer.getMinecraftDirectory();
        if (minecraftDir == null) {
            JOptionPane.showMessageDialog(null, "Unable to find the Minecraft directory", "Error", 0);
            return;
        }
        File binDir = new File(minecraftDir, "/bin/");
        if (!binDir.exists() || !binDir.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Unable to find the Minecraft bin directory", "Error", 0);
            return;
        }
        File minecraftJar = new File(binDir, "minecraft.jar");
        if (!minecraftJar.exists() || !minecraftJar.isFile()) {
            JOptionPane.showMessageDialog(null, "minecraft.jar doesn't exist", "Error", 0);
            return;
        }
        if (minecraftJar.length() != 1465375L) {
            JOptionPane.showMessageDialog(null, "The minecraft.jar is not from a fresh install or isn't 1.7.3", "Error", 0);
            return;
        }
        int numFiles = Installer.countFiles(new File(String.valueOf(minecraftDir.getAbsolutePath()) + "/bin/"));
        filesCopied = 0;
        progressMonitor = new ProgressMonitor(null, "Installing AdventureCraft", "", 0, numFiles += Installer.countFiles(new File(String.valueOf(minecraftDir.getAbsolutePath()) + "/resources/")));
        try {
            Installer.copyDir(new File(String.valueOf(minecraftDir.getAbsolutePath()) + "/bin/"), new File(String.valueOf(curDir) + "/.minecraft/bin/"));
            Installer.copyDir(new File(String.valueOf(minecraftDir.getAbsolutePath()) + "/resources/"), new File(String.valueOf(curDir) + "/.minecraft/resources/"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
        }
        progressMonitor.close();
        JOptionPane.showMessageDialog(null, "Finished Installing!", "Installed", 1);
    }

    public static int countFiles(File source) {
        File[] children = source.listFiles();
        int numFiles = 0;
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceChild = fileArray[n2];
            numFiles = sourceChild.isDirectory() ? (numFiles += Installer.countFiles(sourceChild)) : ++numFiles;
            ++n2;
        }
        return numFiles;
    }

    public static void copyDir(File source, File target) throws IOException {
        File[] children;
        if (!target.exists()) {
            target.mkdirs();
        }
        File[] fileArray = children = source.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceChild = fileArray[n2];
            File targetFile = new File(target, sourceChild.getName());
            progressMonitor.setNote(sourceChild.getName());
            if (sourceChild.isDirectory()) {
                Installer.copyDir(sourceChild, targetFile);
            } else if (sourceChild.getName().equals("minecraft.jar")) {
                Installer.copyJar(sourceChild, targetFile);
                ++filesCopied;
            } else {
                Installer.copyFile(sourceChild, targetFile);
                ++filesCopied;
            }
            progressMonitor.setProgress(filesCopied);
            ++n2;
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        if (!target.exists()) {
            target.createNewFile();
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            byte[] buffer = new byte[4096];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyJar(File source, File target) throws IOException {
        if (!target.exists()) {
            target.createNewFile();
        }
        JarFile jar = new JarFile(source);
        JarOutputStream outputJar = new JarOutputStream(new FileOutputStream(target));
        byte[] buffer = new byte[1024];
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            int bytesRead;
            JarEntry entry = entries.nextElement();
            if (entry.getName().startsWith("META-INF")) continue;
            InputStream entryStream = jar.getInputStream(entry);
            outputJar.putNextEntry(entry);
            while ((bytesRead = entryStream.read(buffer)) != -1) {
                outputJar.write(buffer, 0, bytesRead);
            }
        }
        jar.close();
        outputJar.close();
    }

    public static File getMinecraftDirectory() {
        String applicationData;
        String osName = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home", ".");
        File minecraftDirectory = osName.contains("solaris") || osName.contains("linux") ? new File(userHome, ".minecraft/") : (osName.contains("win") ? ((applicationData = System.getenv("APPDATA")) != null ? new File(applicationData, ".minecraft/") : new File(userHome, ".minecraft/")) : (osName.contains("mac") ? new File(userHome, "Library/Application Support/minecraft") : new File(userHome, "minecraft/")));
        if (!minecraftDirectory.exists()) {
            JOptionPane.showMessageDialog(null, "Couldn't find the Minecraft directory", "Error", 0);
            return null;
        }
        return minecraftDirectory;
    }
}

