/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LauncherPanel
extends JPanel
implements ActionListener {
    JButton start;
    JButton install;
    JButton installViaLogin;
    JButton update;
    JPanel theButtonPanel;
    String updateTo;
    boolean updated = false;
    private static ArrayList<String> mcBinFiles = new ArrayList();

    static {
        mcBinFiles.add("jinput.jar");
        mcBinFiles.add("lwjgl.jar");
        mcBinFiles.add("lwjgl_util.jar");
    }

    public LauncherPanel() {
        super(new BorderLayout());
        this.add((Component)this.createButtonPanel(), "South");
    }

    public boolean isInstalled() {
        File mcDir = new File(".minecraft");
        if (!mcDir.exists() || !mcDir.isDirectory()) {
            return false;
        }
        File binDir = new File(mcDir, "bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            return false;
        }
        File mcJar = new File(binDir, "minecraft.jar");
        if (!mcJar.exists() || !mcJar.isFile() || mcJar.length() != 1407240L) {
            return false;
        }
        for (String fName : mcBinFiles) {
            File binFile = new File(binDir, fName);
            if (binFile.exists() && binFile.isFile()) continue;
            return false;
        }
        return true;
    }

    public JPanel createButtonPanel() {
        JPanel buttonPanel;
        this.theButtonPanel = buttonPanel = new JPanel(new FlowLayout(1, 4, 4));
        this.updateButtonPanel();
        return buttonPanel;
    }

    private void updateButtonPanel() {
        this.theButtonPanel.removeAll();
        if (this.isInstalled()) {
            this.start = new JButton("Start");
            this.start.setVerticalTextPosition(0);
            this.start.setHorizontalTextPosition(0);
            this.start.setActionCommand("start");
            this.start.addActionListener(this);
            this.theButtonPanel.add(this.start);
        } else {
            this.install = new JButton("Install");
            this.install.setVerticalTextPosition(0);
            this.install.setHorizontalTextPosition(0);
            this.install.setActionCommand("install");
            this.install.addActionListener(this);
            this.installViaLogin = new JButton("Install via Login");
            this.installViaLogin.setVerticalTextPosition(0);
            this.installViaLogin.setHorizontalTextPosition(0);
            this.installViaLogin.setActionCommand("installViaLogin");
            this.installViaLogin.addActionListener(this);
            this.theButtonPanel.add(this.install);
            this.theButtonPanel.add(this.installViaLogin);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LauncherPanel.this.checkForUpdate();
            }
        });
        this.validate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("start")) {
            AdventureCraft.startNewAC();
            ACLauncher.frame.setVisible(false);
            this.removeAll();
            System.exit(0);
        }
        if (e.getActionCommand().equals("install")) {
            Installer.install();
        } else if (e.getActionCommand().equals("installViaLogin")) {
            InstallerLogin.installViaLogin();
        } else if (e.getActionCommand().equals("update")) {
            this.downloadUpdate();
        }
        this.updateButtonPanel();
    }

    public void checkForUpdate() {
        String currentVersion = this.getVersion();
        if (!currentVersion.isEmpty()) {
            ACLauncher.frame.setTitle(String.format("AdventureCraft - %s", currentVersion));
        }
        try {
            URL url = new URL("http://www.adventurecraft.org/files/version.txt");
            URLConnection urlconnection = url.openConnection();
            urlconnection.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlconnection.getInputStream()));
            String version = reader.readLine();
            if (version.equals(currentVersion)) {
                return;
            }
            this.update = new JButton(String.format("Update to %s", version));
            this.update.setVerticalTextPosition(0);
            this.update.setHorizontalTextPosition(0);
            this.update.setActionCommand("update");
            this.update.addActionListener(this);
            this.theButtonPanel.add(this.update);
            this.updateTo = version;
            this.validate();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getVersion() {
        try {
            File versionFile = new File("version.txt");
            if (versionFile.exists()) {
                BufferedReader versionReader = new BufferedReader(new FileReader(versionFile));
                String fileInVersion = versionReader.readLine();
                return fileInVersion;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public void downloadUpdate() {
        String downloadFile = String.format("http://www.adventurecraft.org/files/updates/ACBin_%s.jar", this.updateTo);
        if (InstallerLogin.downloadFile(downloadFile, "ACBin.jar")) {
            File versionFile = new File("version.txt");
            versionFile.delete();
            try {
                OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(versionFile));
                out.write(this.updateTo);
                ((Writer)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.theButtonPanel.remove(this.update);
            this.theButtonPanel.updateUI();
            ACLauncher.frame.setTitle(String.format("AdventureCraft - %s", this.updateTo));
            this.updated = true;
        }
    }
}

