/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.components.DefaultWebBrowserDecorator;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAuthenticationHandler;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserDecorator;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserFunction;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationParameters;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeWebBrowserStatic;
import chrriis.dj.nativeswing.swtimpl.internal.NativeCoreObjectFactory;
import java.awt.Component;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;

public class JWebBrowser
extends NSPanelComponent {
    public static final String COMMAND_FUNCTION = "sendNSCommand";
    public static final String COMMAND_LOCATION_PREFIX = "command://";
    public static final String COMMAND_STATUS_PREFIX = "scommand://";
    private static final String USE_XULRUNNER_RUNTIME_OPTION_KEY = "XULRunner Runtime";
    private static final NSOption XUL_RUNNER_RUNTIME_OPTION = new NSOption((Object)"XULRunner Runtime");
    private static final String USE_WEBKIT_RUNTIME_OPTION_KEY = "Webkit Runtime";
    private static final NSOption WEBKIT_RUNTIME_OPTION = new NSOption((Object)"Webkit Runtime");
    private static WebBrowserDecoratorFactory webBrowserDecoratorFactory;
    private WebBrowserDecorator webBrowserDecorator;
    private static INativeWebBrowserStatic webBrowserStatic;
    private INativeWebBrowser nativeWebBrowser;
    private Map<WebBrowserListener, NativeWebBrowserListener> webBrowserListenerToNativeWebBrowserListenerMap = new HashMap<WebBrowserListener, NativeWebBrowserListener>();

    static {
        webBrowserStatic = NativeCoreObjectFactory.create(INativeWebBrowserStatic.class, "chrriis.dj.nativeswing.swtimpl.components.core.NativeWebBrowserStatic", new Class[0], new Object[0]);
    }

    public static NSOption useXULRunnerRuntime() {
        return XUL_RUNNER_RUNTIME_OPTION;
    }

    public static NSOption useWebkitRuntime() {
        return WEBKIT_RUNTIME_OPTION;
    }

    public static void setWebBrowserDecoratorFactory(WebBrowserDecoratorFactory webBrowserDecoratorFactory) {
        JWebBrowser.webBrowserDecoratorFactory = webBrowserDecoratorFactory;
    }

    WebBrowserDecorator getWebBrowserDecorator() {
        return this.webBrowserDecorator;
    }

    protected WebBrowserDecorator createWebBrowserDecorator(Component renderingComponent) {
        WebBrowserDecorator webBrowserDecorator;
        if (webBrowserDecoratorFactory != null && (webBrowserDecorator = webBrowserDecoratorFactory.createWebBrowserDecorator(this, renderingComponent)) != null) {
            return webBrowserDecorator;
        }
        return new DefaultWebBrowserDecorator(this, renderingComponent);
    }

    public static void clearSessionCookies() {
        webBrowserStatic.clearSessionCookies();
    }

    public static String getCookie(String url, String name) {
        return webBrowserStatic.getCookie(url, name);
    }

    public static void setCookie(String url, String value) {
        webBrowserStatic.setCookie(url, value);
    }

    public static void copyAppearance(JWebBrowser fromWebBrowser, JWebBrowser toWebBrowser) {
        toWebBrowser.setLocationBarVisible(fromWebBrowser.isLocationBarVisible());
        toWebBrowser.setButtonBarVisible(fromWebBrowser.isButtonBarVisible());
        toWebBrowser.setMenuBarVisible(fromWebBrowser.isMenuBarVisible());
        toWebBrowser.setStatusBarVisible(fromWebBrowser.isStatusBarVisible());
    }

    public static void copyContent(JWebBrowser fromWebBrowser, JWebBrowser toWebBrowser) {
        String location = fromWebBrowser.getResourceLocation();
        if ("about:blank".equals(location)) {
            toWebBrowser.setHTMLContent(fromWebBrowser.getHTMLContent());
        } else {
            toWebBrowser.navigate(location);
        }
    }

    public JWebBrowser(NSOption ... options) {
        Map optionMap = NSOption.createOptionMap((NSOption[])options);
        INativeWebBrowser.WebBrowserRuntime runtime = INativeWebBrowser.WebBrowserRuntime.DEFAULT;
        if (optionMap.get(USE_XULRUNNER_RUNTIME_OPTION_KEY) != null) {
            runtime = INativeWebBrowser.WebBrowserRuntime.XULRUNNER;
        }
        if (optionMap.get(USE_WEBKIT_RUNTIME_OPTION_KEY) != null) {
            if (runtime != INativeWebBrowser.WebBrowserRuntime.DEFAULT) {
                throw new IllegalStateException("Only one web browser runtime can be specified!");
            }
            runtime = INativeWebBrowser.WebBrowserRuntime.WEBKIT;
        }
        this.nativeWebBrowser = NativeCoreObjectFactory.create(INativeWebBrowser.class, "chrriis.dj.nativeswing.swtimpl.components.core.NativeWebBrowser", new Class[]{JWebBrowser.class, INativeWebBrowser.WebBrowserRuntime.class}, new Object[]{this, runtime});
        this.initialize((NativeComponent)((Object)this.nativeWebBrowser));
        this.webBrowserDecorator = this.createWebBrowserDecorator(this.nativeWebBrowser.createEmbeddableComponent(optionMap));
        this.add((Component)this.webBrowserDecorator, "Center");
    }

    public void setStatusBarVisible(boolean isStatusBarVisible) {
        this.webBrowserDecorator.setStatusBarVisible(isStatusBarVisible);
    }

    public boolean isStatusBarVisible() {
        return this.webBrowserDecorator.isStatusBarVisible();
    }

    public void setMenuBarVisible(boolean isMenuBarVisible) {
        this.webBrowserDecorator.setMenuBarVisible(isMenuBarVisible);
    }

    public boolean isMenuBarVisible() {
        return this.webBrowserDecorator.isMenuBarVisible();
    }

    public void setButtonBarVisible(boolean isButtonBarVisible) {
        this.webBrowserDecorator.setButtonBarVisible(isButtonBarVisible);
    }

    public boolean isButtonBarVisible() {
        return this.webBrowserDecorator.isButtonBarVisible();
    }

    public void setLocationBarVisible(boolean isLocationBarVisible) {
        this.webBrowserDecorator.setLocationBarVisible(isLocationBarVisible);
    }

    public boolean isLocationBarVisible() {
        return this.webBrowserDecorator.isLocationBarVisible();
    }

    public String getPageTitle() {
        return this.nativeWebBrowser.getPageTitle();
    }

    public String getStatusText() {
        return this.nativeWebBrowser.getStatusText();
    }

    public String getHTMLContent() {
        return this.nativeWebBrowser.getHTMLContent();
    }

    public boolean setHTMLContent(String html) {
        return this.nativeWebBrowser.setHTMLContent(html);
    }

    public String getResourceLocation() {
        return this.nativeWebBrowser.getResourceLocation();
    }

    public boolean navigate(String resourceLocation) {
        return this.navigate(resourceLocation, null);
    }

    public boolean navigate(String resourceLocation, WebBrowserNavigationParameters parameters) {
        return this.nativeWebBrowser.navigate(resourceLocation, parameters);
    }

    public boolean isBackNavigationEnabled() {
        return this.nativeWebBrowser.isBackNavigationEnabled();
    }

    public void navigateBack() {
        this.nativeWebBrowser.navigateBack();
    }

    public boolean isForwardNavigationEnabled() {
        return this.nativeWebBrowser.isForwardNavigationEnabled();
    }

    public void navigateForward() {
        this.nativeWebBrowser.navigateForward();
    }

    public void reloadPage() {
        this.nativeWebBrowser.reloadPage();
    }

    public void stopLoading() {
        this.nativeWebBrowser.stopLoading();
    }

    public boolean isJavascriptEnabled() {
        return this.nativeWebBrowser.isJavascriptEnabled();
    }

    public void setJavascriptEnabled(boolean isJavascriptEnabled) {
        this.nativeWebBrowser.setJavascriptEnabled(isJavascriptEnabled);
    }

    public void executeJavascript(String javascript) {
        this.nativeWebBrowser.executeJavascript(javascript);
    }

    public Object executeJavascriptWithResult(String javascript) {
        Object[] result;
        if (!javascript.endsWith(";")) {
            javascript = String.valueOf(javascript) + ";";
        }
        if ((result = this.executeJavascriptWithCommandResult("[[getScriptResult]]", "try {  sendNSCommand('[[getScriptResult]]', (function() {" + javascript + "})());" + "} catch(exxxxx) {" + "  " + COMMAND_FUNCTION + "('[[getScriptResult]]');" + "}")) == null) {
            return null;
        }
        return result.length == 0 ? null : result[0];
    }

    public static String createJavascriptFunctionCall(String functionName, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(functionName).append('(');
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(JWebBrowser.convertJavaObjectToJavascript(args[i]));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String convertJavaObjectToJavascript(Object o) {
        String encodedArg;
        if (o == null) {
            return "null";
        }
        if (o instanceof Boolean || o instanceof Number) {
            return o.toString();
        }
        if (o.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int length = Array.getLength(o);
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(JWebBrowser.convertJavaObjectToJavascript(Array.get(o, i)));
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }
        if ((o = o.toString()).equals(encodedArg = Utils.encodeURL((String)((String)o)))) {
            return String.valueOf('\'') + (String)o + '\'';
        }
        return "decodeURIComponent('" + encodedArg + "')";
    }

    private Object[] executeJavascriptWithCommandResult(String command, String script) {
        if (!((NativeComponent)((Object)this.nativeWebBrowser)).isNativePeerInitialized()) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        NCommandListener webBrowserListener = new NCommandListener(command, result);
        this.nativeWebBrowser.addWebBrowserListener(webBrowserListener);
        if (this.nativeWebBrowser.executeJavascriptAndWait(script)) {
            int i = 0;
            while (i < 20) {
                EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                    public boolean getValue() {
                        return result.get() != null;
                    }
                }, 50);
                ++i;
            }
        }
        this.nativeWebBrowser.removeWebBrowserListener(webBrowserListener);
        return (Object[])result.get();
    }

    public int getLoadingProgress() {
        return this.nativeWebBrowser.getLoadingProgress();
    }

    public void setAuthenticationHandler(WebBrowserAuthenticationHandler authenticationHandler) {
        this.nativeWebBrowser.setAuthenticationHandler(authenticationHandler);
    }

    public WebBrowserAuthenticationHandler getAuthenticationHandler() {
        return this.nativeWebBrowser.getAuthenticationHandler();
    }

    public void addWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.add(WebBrowserListener.class, listener);
        NativeWebBrowserListener nativeWebBrowserListener = new NativeWebBrowserListener(listener);
        this.webBrowserListenerToNativeWebBrowserListenerMap.put(listener, nativeWebBrowserListener);
        this.nativeWebBrowser.addWebBrowserListener(nativeWebBrowserListener);
    }

    public void removeWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.remove(WebBrowserListener.class, listener);
        NativeWebBrowserListener nativeWebBrowserListener = this.webBrowserListenerToNativeWebBrowserListenerMap.remove(listener);
        if (nativeWebBrowserListener != null) {
            this.nativeWebBrowser.removeWebBrowserListener(nativeWebBrowserListener);
        }
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return (WebBrowserListener[])this.listenerList.getListeners(WebBrowserListener.class);
    }

    public void setBarsVisible(boolean areBarsVisible) {
        this.setMenuBarVisible(areBarsVisible);
        this.setButtonBarVisible(areBarsVisible);
        this.setLocationBarVisible(areBarsVisible);
        this.setStatusBarVisible(areBarsVisible);
    }

    public JWebBrowserWindow getWebBrowserWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JWebBrowserWindow) {
            return (JWebBrowserWindow)((Object)window);
        }
        return null;
    }

    public void setDefaultPopupMenuRegistered(boolean isDefaultPopupMenuRegistered) {
        this.nativeWebBrowser.setDefaultPopupMenuRegistered(isDefaultPopupMenuRegistered);
    }

    public void registerFunction(WebBrowserFunction function) {
        this.nativeWebBrowser.registerFunction(function);
    }

    public void unregisterFunction(WebBrowserFunction function) {
        this.nativeWebBrowser.unregisterFunction(function);
    }

    public String getBrowserType() {
        return this.nativeWebBrowser.getBrowserType();
    }

    public String getBrowserVersion() {
        return this.nativeWebBrowser.getBrowserVersion();
    }

    public boolean disposeNativePeer(boolean isConfirmationDialogAllowed) {
        if (isConfirmationDialogAllowed) {
            return this.nativeWebBrowser.unloadAndDispose();
        }
        this.disposeNativePeer();
        return true;
    }

    public boolean print(boolean isShowingDialog) {
        return this.nativeWebBrowser.print(isShowingDialog);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NCommandListener
    extends WebBrowserAdapter {
        private String command;
        private AtomicReference<Object[]> result;

        private NCommandListener(String command, AtomicReference<Object[]> result) {
            this.command = command;
            this.result = result;
        }

        @Override
        public void commandReceived(WebBrowserCommandEvent e) {
            if (this.command.equals(e.getCommand())) {
                this.result.set(e.getParameters());
                ((INativeWebBrowser)((Object)e.getWebBrowser().getNativeComponent())).removeWebBrowserListener(this);
            }
        }
    }

    private static class NativeWebBrowserListener
    implements WebBrowserListener {
        private Reference<WebBrowserListener> webBrowserListener;

        public NativeWebBrowserListener(WebBrowserListener webBrowserListener) {
            this.webBrowserListener = new WeakReference<WebBrowserListener>(webBrowserListener);
        }

        public void commandReceived(WebBrowserCommandEvent e) {
            boolean isInternal;
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null && (!(isInternal = e.getCommand().startsWith("[Chrriis]")) || webBrowserListener.getClass().getName().startsWith("chrriis."))) {
                webBrowserListener.commandReceived(e);
            }
        }

        public void loadingProgressChanged(WebBrowserEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.loadingProgressChanged(e);
            }
        }

        public void locationChangeCanceled(WebBrowserNavigationEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.locationChangeCanceled(e);
            }
        }

        public void locationChanged(WebBrowserNavigationEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.locationChanged(e);
            }
        }

        public void locationChanging(WebBrowserNavigationEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.locationChanging(e);
            }
        }

        public void statusChanged(WebBrowserEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.statusChanged(e);
            }
        }

        public void titleChanged(WebBrowserEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.titleChanged(e);
            }
        }

        public void windowClosing(WebBrowserEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.windowClosing(e);
            }
        }

        public void windowOpening(WebBrowserWindowOpeningEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.windowOpening(e);
            }
        }

        public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
            WebBrowserListener webBrowserListener = this.webBrowserListener.get();
            if (webBrowserListener != null) {
                webBrowserListener.windowWillOpen(e);
            }
        }
    }

    public static interface WebBrowserDecoratorFactory {
        public WebBrowserDecorator createWebBrowserDecorator(JWebBrowser var1, Component var2);
    }
}

