/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Vec3D;
import org.lwjgl.opengl.GL11;

public class CutsceneCamera {
    long startTime;
    CutsceneCameraPoint curPoint = new CutsceneCameraPoint(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0);
    CutsceneCameraPoint prevPrevPoint;
    CutsceneCameraPoint prevPoint;
    List<net.minecraft.src.CutsceneCameraPoint> cameraPoints = new LinkedList<net.minecraft.src.CutsceneCameraPoint>();
    List<Vec3D> lineVecs = new LinkedList<Vec3D>();
    int startType = 2;

    void addCameraPoint(float time, float posX, float posY, float posZ, float yaw, float pitch, int type) {
        int index = 0;
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            if (time < cutsceneCameraPoint.time) break;
            ++index;
        }
        this.cameraPoints.add(index, (net.minecraft.src.CutsceneCameraPoint)new CutsceneCameraPoint(time, posX, posY, posZ, yaw, pitch, type));
        this.fixYawPitch(0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void loadCameraEntities() {
        for (Object e : Minecraft.minecraftInstance.f.b) {
            if (!(e instanceof EntityCamera)) continue;
            ((sn)e).K();
        }
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            EntityCamera entityCamera = new EntityCamera(Minecraft.minecraftInstance.f, cutsceneCameraPoint.time, cutsceneCameraPoint.cameraBlendType, cutsceneCameraPoint.cameraID);
            entityCamera.b(cutsceneCameraPoint.posX, cutsceneCameraPoint.posY, cutsceneCameraPoint.posZ, cutsceneCameraPoint.rotYaw, cutsceneCameraPoint.rotPitch);
            Minecraft.minecraftInstance.f.b(entityCamera);
        }
        CutsceneCamera c2 = new CutsceneCamera();
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            c2.addCameraPoint(cutsceneCameraPoint.time, cutsceneCameraPoint.posX, cutsceneCameraPoint.posY, cutsceneCameraPoint.posZ, cutsceneCameraPoint.rotYaw, cutsceneCameraPoint.rotPitch, cutsceneCameraPoint.cameraBlendType);
        }
        Object var2_6 = null;
        this.lineVecs.clear();
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            void var2_7;
            if (var2_7 != null) {
                for (int i = 0; i < 25; ++i) {
                    float lerpValue = (float)(i + 1) / 25.0f;
                    float time = this.lerp(lerpValue, var2_7.time, cutsceneCameraPoint.time);
                    CutsceneCameraPoint point = c2.getPoint(time);
                    bt v = bt.a((double)point.posX, (double)point.posY, (double)point.posZ);
                    this.lineVecs.add((Vec3D)v);
                }
            } else {
                this.lineVecs.add((Vec3D)bt.a((double)cutsceneCameraPoint.posX, (double)cutsceneCameraPoint.posY, (double)cutsceneCameraPoint.posZ));
            }
            CutsceneCameraPoint cutsceneCameraPoint2 = cutsceneCameraPoint;
        }
    }

    public void drawLines(ls entityplayer, float f) {
        double offX = entityplayer.bl + (entityplayer.aM - entityplayer.bl) * (double)f;
        double offY = entityplayer.bm + (entityplayer.aN - entityplayer.bm) * (double)f;
        double offZ = entityplayer.bn + (entityplayer.aO - entityplayer.bn) * (double)f;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)0.2f, (float)0.0f, (float)1.0f);
        GL11.glLineWidth((float)5.0f);
        GL11.glDisable((int)3553);
        nw tessellator = nw.a;
        tessellator.a(3);
        for (bt bt2 : this.lineVecs) {
            tessellator.a(bt2.a - offX, bt2.b - offY, bt2.c - offZ);
        }
        tessellator.a();
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void fixYawPitch(float startYaw, float startPitch) {
        float yawOffset = 0.0f;
        float pitchOffset = 0.0f;
        CutsceneCameraPoint prevPoint = new CutsceneCameraPoint(0.0f, 0.0f, 0.0f, 0.0f, startYaw, startPitch, 0);
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            if (prevPoint != null) {
                float delta;
                cutsceneCameraPoint.rotYaw += yawOffset;
                boolean keepUpdating = true;
                do {
                    if ((delta = cutsceneCameraPoint.rotYaw - prevPoint.rotYaw) > 180.0f) {
                        yawOffset -= 360.0f;
                        cutsceneCameraPoint.rotYaw -= 360.0f;
                        continue;
                    }
                    if (delta < -180.0f) {
                        yawOffset += 360.0f;
                        cutsceneCameraPoint.rotYaw += 360.0f;
                        continue;
                    }
                    keepUpdating = false;
                } while (keepUpdating);
                cutsceneCameraPoint.rotPitch += pitchOffset;
                keepUpdating = true;
                do {
                    if ((delta = cutsceneCameraPoint.rotPitch - prevPoint.rotPitch) > 180.0f) {
                        pitchOffset -= 360.0f;
                        cutsceneCameraPoint.rotPitch -= 360.0f;
                        continue;
                    }
                    if (delta < -180.0f) {
                        pitchOffset += 360.0f;
                        cutsceneCameraPoint.rotPitch += 360.0f;
                        continue;
                    }
                    keepUpdating = false;
                } while (keepUpdating);
            }
            prevPoint = cutsceneCameraPoint;
        }
    }

    void clearPoints() {
        this.prevPrevPoint = null;
        this.prevPoint = null;
        this.cameraPoints.clear();
    }

    void startCamera() {
        this.prevPrevPoint = null;
        this.prevPoint = null;
        this.startTime = Minecraft.minecraftInstance.f.t();
    }

    private float cubicInterpolation(float mu, float y0, float y1, float y2, float y3) {
        float mu2 = mu * mu;
        float a0 = -0.5f * y0 + 1.5f * y1 - 1.5f * y2 + 0.5f * y3;
        float a1 = y0 - 2.5f * y1 + 2.0f * y2 - 0.5f * y3;
        float a2 = -0.5f * y0 + 0.5f * y2;
        float a3 = y1;
        return a0 * mu * mu2 + a1 * mu2 + a2 * mu + a3;
    }

    private float lerp(float mu, float y0, float y1) {
        return (1.0f - mu) * y0 + mu * y1;
    }

    boolean isEmpty() {
        return this.cameraPoints.isEmpty();
    }

    float getLastTime() {
        return ((CutsceneCameraPoint)this.cameraPoints.get((int)(this.cameraPoints.size() - 1))).time;
    }

    CutsceneCameraPoint getCurrentPoint(float partialTickTime) {
        float elapsed = ((float)(Minecraft.minecraftInstance.f.t() - this.startTime) + partialTickTime) / 20.0f;
        return this.getPoint(elapsed);
    }

    CutsceneCameraPoint getPoint(float elapsed) {
        CutsceneCameraPoint nextNextPoint;
        if (this.prevPoint == null) {
            if (this.cameraPoints.isEmpty()) {
                return this.curPoint;
            }
            if (this.startType != 0) {
                dc player = Minecraft.minecraftInstance.h;
                this.prevPoint = new CutsceneCameraPoint(0.0f, (float)player.aM, (float)player.aN, (float)player.aO, player.aS, player.aT, this.startType);
                this.fixYawPitch(player.aS, player.aT);
            } else {
                CutsceneCameraPoint start = (CutsceneCameraPoint)this.cameraPoints.get(0);
                this.prevPoint = new CutsceneCameraPoint(0.0f, start.posX, start.posY, start.posZ, start.rotYaw, start.rotPitch, this.startType);
            }
        }
        if (this.prevPoint.time > elapsed || this.cameraPoints.isEmpty()) {
            return this.prevPoint;
        }
        CutsceneCameraPoint nextPoint = (CutsceneCameraPoint)this.cameraPoints.get(0);
        while (nextPoint != null && nextPoint.time < elapsed && !this.cameraPoints.isEmpty()) {
            this.prevPrevPoint = this.prevPoint;
            this.prevPoint = (CutsceneCameraPoint)this.cameraPoints.remove(0);
            nextPoint = null;
            if (this.cameraPoints.isEmpty()) continue;
            nextPoint = (CutsceneCameraPoint)this.cameraPoints.get(0);
            if (this.prevPrevPoint == null) continue;
            float timeDiff1 = nextPoint.time - this.prevPoint.time;
            float timeDiff2 = this.prevPoint.time - this.prevPrevPoint.time;
            if (timeDiff2 > 0.0f) {
                float m = timeDiff1 / timeDiff2;
                this.prevPrevPoint = new CutsceneCameraPoint(0.0f, this.prevPoint.posX - m * (this.prevPoint.posX - this.prevPrevPoint.posX), this.prevPoint.posY - m * (this.prevPoint.posY - this.prevPrevPoint.posY), this.prevPoint.posZ - m * (this.prevPoint.posZ - this.prevPrevPoint.posZ), this.prevPoint.rotYaw - m * (this.prevPoint.rotYaw - this.prevPrevPoint.rotYaw), this.prevPoint.rotPitch - m * (this.prevPoint.rotPitch - this.prevPrevPoint.rotPitch), 0);
                continue;
            }
            this.prevPrevPoint = new CutsceneCameraPoint(0.0f, this.prevPoint.posX, this.prevPoint.posY, this.prevPoint.posZ, this.prevPoint.rotYaw, this.prevPoint.rotPitch, 0);
        }
        if (nextPoint == null) {
            return this.prevPoint;
        }
        if (this.prevPrevPoint == null) {
            this.prevPrevPoint = new CutsceneCameraPoint(0.0f, 2.0f * this.prevPoint.posX - nextPoint.posX, 2.0f * this.prevPoint.posY - nextPoint.posY, 2.0f * this.prevPoint.posZ - nextPoint.posZ, 2.0f * this.prevPoint.rotYaw - nextPoint.rotYaw, 2.0f * this.prevPoint.rotPitch - nextPoint.rotPitch, 0);
        }
        if (this.cameraPoints.size() > 1) {
            nextNextPoint = (CutsceneCameraPoint)this.cameraPoints.get(1);
            float timeDiff1 = nextPoint.time - this.prevPoint.time;
            float timeDiff2 = nextNextPoint.time - nextPoint.time;
            if (timeDiff2 > 0.0f) {
                float m = timeDiff1 / timeDiff2;
                nextNextPoint = new CutsceneCameraPoint(0.0f, nextPoint.posX + m * (nextNextPoint.posX - nextPoint.posX), nextPoint.posY + m * (nextNextPoint.posY - nextPoint.posY), nextPoint.posZ + m * (nextNextPoint.posZ - nextPoint.posZ), nextPoint.rotYaw + m * (nextNextPoint.rotYaw - nextPoint.rotYaw), nextPoint.rotPitch + m * (nextNextPoint.rotPitch - nextPoint.rotPitch), 0);
            } else {
                nextNextPoint = new CutsceneCameraPoint(0.0f, nextPoint.posX, nextPoint.posY, nextPoint.posZ, nextPoint.rotYaw, nextPoint.rotPitch, 0);
            }
        } else {
            nextNextPoint = new CutsceneCameraPoint(0.0f, 2.0f * nextPoint.posX - this.prevPoint.posX, 2.0f * nextPoint.posY - this.prevPoint.posY, 2.0f * nextPoint.posZ - this.prevPoint.posZ, 2.0f * nextPoint.rotYaw - this.prevPoint.rotYaw, 2.0f * nextPoint.rotPitch - this.prevPoint.rotPitch, 0);
        }
        float lerp = (elapsed - this.prevPoint.time) / (nextPoint.time - this.prevPoint.time);
        this.curPoint.time = elapsed;
        switch (this.prevPoint.cameraBlendType) {
            case 1: {
                this.curPoint.posX = this.lerp(lerp, this.prevPoint.posX, nextPoint.posX);
                this.curPoint.posY = this.lerp(lerp, this.prevPoint.posY, nextPoint.posY);
                this.curPoint.posZ = this.lerp(lerp, this.prevPoint.posZ, nextPoint.posZ);
                this.curPoint.rotYaw = this.lerp(lerp, this.prevPoint.rotYaw, nextPoint.rotYaw);
                this.curPoint.rotPitch = this.lerp(lerp, this.prevPoint.rotPitch, nextPoint.rotPitch);
                break;
            }
            case 2: {
                this.curPoint.posX = this.cubicInterpolation(lerp, this.prevPrevPoint.posX, this.prevPoint.posX, nextPoint.posX, nextNextPoint.posX);
                this.curPoint.posY = this.cubicInterpolation(lerp, this.prevPrevPoint.posY, this.prevPoint.posY, nextPoint.posY, nextNextPoint.posY);
                this.curPoint.posZ = this.cubicInterpolation(lerp, this.prevPrevPoint.posZ, this.prevPoint.posZ, nextPoint.posZ, nextNextPoint.posZ);
                this.curPoint.rotYaw = this.cubicInterpolation(lerp, this.prevPrevPoint.rotYaw, this.prevPoint.rotYaw, nextPoint.rotYaw, nextNextPoint.rotYaw);
                this.curPoint.rotPitch = this.cubicInterpolation(lerp, this.prevPrevPoint.rotPitch, this.prevPoint.rotPitch, nextPoint.rotPitch, nextNextPoint.rotPitch);
                break;
            }
            default: {
                this.curPoint.posX = this.prevPoint.posX;
                this.curPoint.posY = this.prevPoint.posY;
                this.curPoint.posZ = this.prevPoint.posZ;
                this.curPoint.rotYaw = this.prevPoint.rotYaw;
                this.curPoint.rotPitch = this.prevPoint.rotPitch;
            }
        }
        return this.curPoint;
    }

    void deletePoint(int id) {
        CutsceneCameraPoint deleting = null;
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            if (cutsceneCameraPoint.cameraID != id) continue;
            deleting = cutsceneCameraPoint;
            break;
        }
        if (deleting != null) {
            this.cameraPoints.remove(deleting);
        }
    }

    void setPointType(int id, int type) {
        for (CutsceneCameraPoint cutsceneCameraPoint : this.cameraPoints) {
            if (cutsceneCameraPoint.cameraID != id) continue;
            cutsceneCameraPoint.cameraBlendType = type;
            this.loadCameraEntities();
            return;
        }
    }
}

