/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.script.ScriptUIContainer;
import net.minecraft.src.GuiMapElement;
import org.lwjgl.opengl.GL11;

class GuiMapDownload
extends da {
    static final String url = "http://www.adventurecraft.org/";
    public ScriptUIContainer ui = new ScriptUIContainer(0, 26, null);
    protected da parentScreen;
    private File mapDownloadFolder;
    private GuiMapElement mouseOver;
    private ArrayList<GuiMapElement> maps = new ArrayList();
    private boolean downloading = true;
    private int mapImagesDownloaded = 0;
    private int totalMaps = 0;
    private boolean downloadingMap = false;
    private String downloadingMapName;
    private int downloadedAmount;
    private int downloadSize;
    private String mapUrl;
    private String mapName;
    private GuiMapElement downloadingMapElement;
    private boolean rightClickDown = false;
    private int mouseY;
    private int maxOffset;
    private int scrollBarX;
    private boolean scrolling = false;

    GuiMapDownload(da guiscreen) {
        this.mapDownloadFolder = new File("./mapDownloads/");
        if (!this.mapDownloadFolder.exists()) {
            this.mapDownloadFolder.mkdirs();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiMapDownload.this.downloadAndLoadMapInfo();
            }
        });
        this.mouseOver = null;
        this.parentScreen = guiscreen;
    }

    @Override
    public void b() {
        this.e.add(new ke(0, 2, 2, 50, 20, "Back"));
    }

    @Override
    protected void a(ke guibutton) {
        if (guibutton.f == 0) {
            this.b.a(this.parentScreen);
        }
    }

    @Override
    protected void a(int i, int j, int k) {
        super.a(i, j, k);
        if (!this.downloading) {
            if (k == 0) {
                GuiMapElement map;
                if (j > 24 && (map = this.getMapAtCoord(i, j)) != null) {
                    if (j - map.y - this.ui.y > 85) {
                        map.ratingClicked(i - map.x - this.ui.x, j - map.y - this.ui.y);
                    } else {
                        this.mapUrl = map.mapURL;
                        this.mapName = map.mapName;
                        this.downloadingMapElement = map;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiMapDownload.this.downloadMap();
                            }
                        });
                    }
                }
                if (this.maxOffset < 26 && i >= this.scrollBarX && i <= this.scrollBarX + 8 && j > 26) {
                    float yOffset = Math.max(Math.min((float)(j - 8 - 26) / ((float)this.d - 26.0f - 16.0f - 32.0f), 1.0f), 0.0f);
                    this.ui.y = 26 - (int)(yOffset * (float)(26 - this.maxOffset));
                    this.scrolling = true;
                }
            } else if (k == 1) {
                this.rightClickDown = true;
                this.mouseY = j;
            }
        }
    }

    @Override
    protected void b(int i, int j, int k) {
        if (!this.downloading) {
            if (this.rightClickDown && j != this.mouseY) {
                this.ui.y += j - this.mouseY;
                this.mouseY = j;
                if (this.ui.y > 26) {
                    this.ui.y = 26;
                } else if (this.ui.y < this.maxOffset) {
                    this.ui.y = this.maxOffset;
                }
            } else if (this.scrolling) {
                float yOffset = Math.max(Math.min((float)(j - 8 - 26) / ((float)this.d - 26.0f - 16.0f - 32.0f), 1.0f), 0.0f);
                this.ui.y = 26 - (int)(yOffset * (float)(26 - this.maxOffset));
            }
            if (k == 0) {
                this.scrolling = false;
            } else if (k == 1) {
                this.rightClickDown = false;
            }
            for (GuiMapElement guiMapElement : this.maps) {
                guiMapElement.mouseMoved(i - guiMapElement.x - this.ui.x, j - guiMapElement.y - this.ui.y);
            }
        }
        super.b(i, j, k);
    }

    @Override
    public void a(int i, int j, float f) {
        this.i();
        if (!this.downloading) {
            this.a(0, 24, this.c + 32, this.d + 32, 0x40000000);
            this.a(0, 24, this.c + 32, 32, -16777216, 0);
            this.a(0, this.d - 32 - 8, this.c + 32, this.d - 32, 0, -16777216);
            GuiMapElement newMap = this.getMapAtCoord(i, j);
            if (newMap != this.mouseOver) {
                if (newMap != null) {
                    newMap.fadeDescriptionIn();
                }
                if (this.mouseOver != null) {
                    this.mouseOver.fadeDescriptionOut();
                }
            }
            this.mouseOver = newMap;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2929);
            this.ui.render(this.g, this.b.p);
            GL11.glEnable((int)2929);
            if (this.maxOffset < 26) {
                this.a(this.scrollBarX, 26, this.scrollBarX + 8, this.d - 32, Integer.MIN_VALUE);
                float yOffset = 1.0f - (float)(this.ui.y - this.maxOffset) / (26.0f - (float)this.maxOffset);
                int y = (int)((float)(this.d - 26 - 16 - 32) * yOffset);
                this.a(this.scrollBarX, 26 + y, this.scrollBarX + 8, 26 + y + 16, -1325400065);
            }
            this.drawBackground(0, 24, 255, 255);
            this.drawBackground(this.d - 32, this.d, 255, 255);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2929);
            int w = this.g.a("Maps Available For Download");
            this.g.b("Maps Available For Download", this.c / 2 - w / 2, 8, 0xFFFFFF);
            String s = "Additional maps can be found on the AdventureCraft Wiki";
            w = this.g.a(s);
            this.g.b(s, this.c / 2 - w / 2, this.d - 26, 0xFFFFFF);
            s = "http://adventurecraft.wikkii.com/";
            w = this.g.a(s);
            this.g.b(s, this.c / 2 - w / 2, this.d - 14, 0xFFFFFF);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        } else if (!this.downloadingMap) {
            this.drawStatus("Downloading Map Info", this.mapImagesDownloaded, this.totalMaps);
        } else {
            this.drawStatus("Downloading Map: " + this.mapName, this.downloadedAmount, this.downloadSize);
            if (this.downloadSize != 0) {
                float downloadedAmountMegs = (float)this.downloadedAmount / 1024.0f / 1024.0f;
                float downloadSizeMegs = (float)this.downloadSize / 1024.0f / 1024.0f;
                String downloaded = String.format("Downloaded %.2f/%.2f MBs", Float.valueOf(downloadedAmountMegs), Float.valueOf(downloadSizeMegs));
                int w = this.g.a(downloaded);
                this.g.b(downloaded, this.c / 2 - w / 2, this.d / 2 + 15, 0xFFFFFF);
            }
        }
        super.a(i, j, f);
    }

    private void drawStatus(String s, int cur, int total) {
        int w = this.g.a(s);
        this.g.b(s, this.c / 2 - w / 2, this.d / 2 - 4, 0xFFFFFF);
        this.a(this.c / 2 - 50, this.d / 2 + 5, this.c / 2 + 50, this.d / 2 + 13, Integer.MIN_VALUE);
        if (total > 0) {
            int xOffset = (int)(100.0 * (double)cur / (double)total - 50.0);
            this.a(this.c / 2 - 50, this.d / 2 + 5, this.c / 2 + xOffset, this.d / 2 + 13, -15675632);
        }
    }

    @Override
    public void a(Minecraft minecraft, int i, int j) {
        super.a(minecraft, i, j);
        this.ui.x = i / 2 - 152;
        this.scrollBarX = 1 + this.c / 2 + 152;
        this.maxOffset = Math.min(this.d - 32 - 102 * (this.maps.size() + 2) / 3, 26);
        if (this.ui.y < this.maxOffset) {
            this.ui.y = this.maxOffset;
        }
    }

    private GuiMapElement addMap(String title, String topDescription, String description, String texture, String mURL, int mapID, int totalRating, int numRatings) {
        int i = this.maps.size();
        GuiMapElement r = new GuiMapElement(102 * (i % 3), 102 * (i / 3), this.ui, title, topDescription, description, texture, mURL, mapID, totalRating, numRatings);
        this.maps.add((GuiMapElement)r);
        this.maxOffset = Math.min(this.d - 32 - 102 * (this.maps.size() + 2) / 3, 26);
        return r;
    }

    private GuiMapElement getMapAtCoord(int x, int y) {
        for (GuiMapElement guiMapElement : this.maps) {
            int dX = x - (guiMapElement.x + this.ui.x);
            int dY = y - (guiMapElement.y + this.ui.y);
            if (dX < 0 || dX >= 100 || dY < 0 || dY >= 100) continue;
            return guiMapElement;
        }
        return null;
    }

    private void downloadAndLoadMapInfo() {
        this.downloadFile("http://www.adventurecraft.org/cgi-bin/mapData2.py", "./mapDownloads/mapInfo.txt");
        File mapInfo = new File(this.mapDownloadFolder, "mapInfo.txt");
        if (mapInfo.exists()) {
            try {
                BufferedReader input = new BufferedReader(new FileReader(mapInfo));
                ArrayList<String> lines = new ArrayList<String>();
                while (input.ready()) {
                    String line = input.readLine();
                    line = line.replace("\\n", "\n");
                    lines.add(line);
                }
                this.totalMaps = lines.size();
                for (String line : lines) {
                    String[] parts = line.split(", ");
                    if (parts.length >= 12) {
                        int mapID = new Integer(parts[9]);
                        String mapName = parts[0];
                        String mapDescription = parts[4];
                        String mapTexture = "http://www.adventurecraft.org/mapThumbnails/" + parts[0].replace(" ", "%20") + ".png";
                        String mapURL = String.format("http://www.adventurecraft.org/cgi-bin/downloadMap.py?mapID=%d", mapID);
                        mapTexture = mapTexture.replace(" ", "%20");
                        boolean first = true;
                        String topDescription = "";
                        if (!parts[2].equals("")) {
                            topDescription = topDescription + "by " + parts[2];
                            first = false;
                        }
                        if (!parts[8].equals("")) {
                            if (!first) {
                                topDescription = topDescription + "\n";
                            }
                            topDescription = topDescription + "Downloads: " + parts[8];
                            first = false;
                        }
                        int totalRating = new Integer(parts[10]);
                        int numRatings = new Integer(parts[11]);
                        this.downloadFile(mapTexture, "./mapDownloads/" + mapName + ".png");
                        GuiMapElement map = this.addMap(mapName, topDescription, mapDescription, "./mapDownloads/" + mapName + ".png", mapURL, mapID, totalRating, numRatings);
                        File mFolder = new File("./maps/" + map.mapName);
                        if (mFolder.exists()) {
                            map.setAsDownloaded();
                        }
                    }
                    ++this.mapImagesDownloaded;
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.downloading = false;
    }

    private void deleteFilesInFolder(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFilesInFolder(f);
            }
            f.delete();
        }
    }

    private void downloadMap() {
        this.downloadSize = 0;
        this.downloading = true;
        this.downloadingMap = true;
        this.downloadingMapName = this.mapName;
        this.downloadFile(this.mapUrl, "./mapDownloads/map.zip");
        File mapZip = new File(this.mapDownloadFolder, "map.zip");
        File mapDir = new File("./maps/" + this.mapName);
        if (mapDir.exists()) {
            if (mapDir.isDirectory()) {
                this.deleteFilesInFolder(mapDir);
            }
            mapDir.delete();
        }
        mapDir.mkdir();
        ZipInputStream zipinputstream = null;
        try {
            byte[] buf = new byte[8192];
            zipinputstream = new ZipInputStream(new FileInputStream(mapZip));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                String entryName = zipentry.getName();
                File f = new File(mapDir, entryName);
                if (!zipentry.isDirectory()) {
                    try {
                        int n2;
                        f.createNewFile();
                        FileOutputStream fileoutputstream = new FileOutputStream(f);
                        while ((n2 = zipinputstream.read(buf, 0, 8192)) > -1) {
                            fileoutputstream.write(buf, 0, n2);
                        }
                        fileoutputstream.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    f.mkdirs();
                }
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        mapZip.delete();
        this.downloadingMapElement.setAsDownloaded();
        this.downloading = false;
        this.downloadingMap = false;
    }

    private boolean downloadFile(String downloadSite, String outputFileName) {
        try {
            int buffersize;
            URL url = new URL(downloadSite);
            URLConnection urlconnection = url.openConnection();
            urlconnection.connect();
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            File output = new File(outputFileName);
            output.mkdirs();
            if (output.exists()) {
                output.delete();
            }
            output.createNewFile();
            FileOutputStream fos = new FileOutputStream(output);
            bis = new BufferedInputStream(urlconnection.getInputStream());
            bos = new BufferedOutputStream(fos);
            this.downloadedAmount = 0;
            this.downloadSize = urlconnection.getContentLength();
            byte[] buffer = new byte[65536];
            while ((buffersize = bis.read(buffer, 0, 65536)) != -1) {
                bos.write(buffer, 0, buffersize);
                this.downloadedAmount += buffersize;
            }
            bos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void drawBackground(int top, int bottom, int topAlpha, int bottomAlpha) {
        nw tessellator = nw.a;
        GL11.glBindTexture((int)3553, (int)this.b.p.b("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.b();
        tessellator.a(0x404040, bottomAlpha);
        tessellator.a(0.0, (double)bottom, 0.0, 0.0, (double)((float)bottom / f));
        tessellator.a((double)this.c, (double)bottom, 0.0, (double)((float)this.c / f), (double)((float)bottom / f));
        tessellator.a(0x404040, topAlpha);
        tessellator.a((double)this.c, (double)top, 0.0, (double)((float)this.c / f), (double)((float)top / f));
        tessellator.a(0.0, (double)top, 0.0, 0.0, (double)((float)top / f));
        tessellator.a();
    }
}

