/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class JScriptHandler {
    fd world;
    File scriptDir;
    HashMap<String, Script> scripts;

    JScriptHandler(fd w, File mapDir) {
        this.world = w;
        this.scriptDir = new File(mapDir, "scripts");
        this.scripts = new HashMap();
        this.loadScripts();
    }

    public void loadScripts() {
        this.scripts.clear();
        if (this.scriptDir.exists()) {
            for (File f : this.scriptDir.listFiles()) {
                String fileName = f.getName().toLowerCase();
                if (!fileName.endsWith(".js")) continue;
                System.out.printf("Compiling %s\n", fileName);
                String script = this.readFile(f);
                this.scripts.put(fileName, this.world.script.compileString(script, fileName));
            }
        }
    }

    public Object runScript(String fileName, Scriptable scope) {
        return this.runScript(fileName, scope, true);
    }

    public Object runScript(String fileName, Scriptable scope, boolean verbose) {
        Script script = this.scripts.get(fileName.toLowerCase());
        if (script != null) {
            return this.world.script.runScript(script, scope);
        }
        if (verbose) {
            Minecraft.minecraftInstance.v.a(String.format("Missing '%s'", fileName));
        }
        return null;
    }

    private String readFile(File f) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String buffer = "";
            try {
                while (reader.ready()) {
                    buffer = buffer + reader.readLine() + "\n";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return buffer;
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return "";
        }
    }
}

