/*
 * Decompiled with CFR 0.152.
 */
class LightCache {
    static final int cacheSize = 16384;
    static final int cacheSizeThird = 5461;
    static final int cacheSizeTwoThird = 10922;
    BlockCoord[] coords = new BlockCoord[16384];
    float[] lightValues = new float[16384];
    static LightCache cache = new LightCache();

    public void clear() {
        for (int i2 = 0; i2 < 16384; ++i2) {
            this.coords[i2] = null;
        }
    }

    private int calcHash(int x, int y, int z) {
        int m = 1540483477;
        int r = 24;
        int h2 = 1234567890;
        int k = x;
        k *= m;
        k ^= k >>> r;
        h2 *= m;
        h2 ^= (k *= m);
        k = y;
        k *= m;
        k ^= k >>> r;
        h2 *= m;
        h2 ^= (k *= m);
        k = z;
        k *= m;
        k ^= k >>> r;
        h2 *= m;
        h2 ^= (k *= m);
        h2 ^= h2 >>> 13;
        h2 *= m;
        h2 ^= h2 >>> 15;
        return h2;
    }

    private int findEntry(int x, int y, int z) {
        int i2;
        int h2 = i2 = Math.abs(this.calcHash(x, y, z)) % 16384;
        int j = 0;
        while (this.coords[i2] != null && !this.coords[i2].isEqual(x, y, z)) {
            i2 = (i2 + 1) % 16384;
            if (j++ <= 16384) continue;
            throw new RuntimeException("Light cache full");
        }
        return i2;
    }

    public float getLightValue(int x, int y, int z) {
        int i2 = this.findEntry(x, y, z);
        if (this.coords[i2] == null) {
            return -1.0f;
        }
        return this.lightValues[i2];
    }

    public void setLightValue(int x, int y, int z, float l) {
        int i2 = this.findEntry(x, y, z);
        this.coords[i2] = BlockCoord.getFromPool(x, y, z);
        this.lightValues[i2] = l;
    }
}

