/*
 * Decompiled with CFR 0.152.
 */
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.glu.GLU;

class MapEditing {
    Minecraft mc;
    fd world;
    vf cursor;
    private cv renderBlocks;
    int selectedBlockID;
    int selectedMetadata;

    MapEditing(Minecraft mcInstance, fd w) {
        this.mc = mcInstance;
        this.world = w;
        this.renderBlocks = new cv(w);
    }

    public void updateWorld(fd w) {
        this.world = w;
        this.renderBlocks.c = w;
    }

    public void updateCursor(ls camera, float fov, float time) {
        if (this.mc.N) {
            this.cursor = null;
            return;
        }
        int x = Mouse.getX();
        int y = Mouse.getY();
        IntBuffer viewport = BufferUtils.createIntBuffer((int)16);
        FloatBuffer modelview = BufferUtils.createFloatBuffer((int)16);
        FloatBuffer projection = BufferUtils.createFloatBuffer((int)16);
        FloatBuffer position = BufferUtils.createFloatBuffer((int)3);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelview);
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        GL11.glGetInteger((int)2978, (IntBuffer)viewport);
        float winX = x;
        float winY = y;
        GLU.gluUnProject((float)winX, (float)winY, (float)1.0f, (FloatBuffer)modelview, (FloatBuffer)projection, (IntBuffer)viewport, (FloatBuffer)position);
        bt pos = camera.e(time);
        bt mouseLoc = pos.c((double)(position.get(0) * 1024.0f), (double)(position.get(1) * 1024.0f), (double)(position.get(2) * 1024.0f));
        this.cursor = this.world.a(pos, mouseLoc);
    }

    public void paint() {
        if (this.cursor != null && this.cursor.a == jg.a) {
            int x = this.cursor.b;
            int y = this.cursor.c;
            int z = this.cursor.d;
            this.setBlock(x + this.getCursorXOffset(), y + this.getCursorYOffset(), z + this.getCursorZOffset(), this.selectedBlockID, this.selectedMetadata);
        }
    }

    int getCursorXOffset() {
        if (this.cursor.e == 4) {
            return -1;
        }
        if (this.cursor.e == 5) {
            return 1;
        }
        return 0;
    }

    int getCursorYOffset() {
        if (this.cursor.e == 0) {
            return -1;
        }
        if (this.cursor.e == 1) {
            return 1;
        }
        return 0;
    }

    int getCursorZOffset() {
        if (this.cursor.e == 2) {
            return -1;
        }
        if (this.cursor.e == 3) {
            return 1;
        }
        return 0;
    }

    private void setBlock(int x, int y, int z, int blockID, int metadata) {
        if (y >= 0 && y < 128) {
            this.world.b(x, y, z, blockID, metadata);
        }
    }

    public void render(float time) {
        ls camera = Minecraft.minecraftInstance.i;
        if (!this.mc.N) {
            this.drawCursor(camera, time);
            if (this.cursor != null) {
                float x = (float)(camera.bl + (camera.aM - camera.bl) * (double)time);
                float y = (float)(camera.bm + (camera.aN - camera.bm) * (double)time);
                float z = (float)(camera.bn + (camera.aO - camera.bn) * (double)time);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(-x), (float)(-y), (float)(-z));
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)32771, (int)32772);
                this.mc.p.b(this.mc.p.b("/terrain.png"));
                this.renderBlocks.startRenderingBlocks(this.world);
                this.drawBlock(this.cursor.b + this.getCursorXOffset(), this.cursor.c + this.getCursorYOffset(), this.cursor.d + this.getCursorZOffset(), this.selectedBlockID, this.selectedMetadata);
                this.renderBlocks.stopRenderingBlocks();
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    private void drawBlock(int x, int y, int z, int blockID, int metadata) {
        uu block = uu.m[blockID];
        if (block != null) {
            int prevBlockID = this.world.a(x, y, z);
            int prevMetadata = this.world.e(x, y, z);
            this.world.a(x, y, z, blockID, metadata);
            this.renderBlocks.b(block, x, y, z);
            this.world.a(x, y, z, prevBlockID, prevMetadata);
        }
    }

    private void drawBox(eq axisalignedbb) {
        nw tessellator = nw.a;
        tessellator.a(3);
        tessellator.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.b, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        tessellator.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.f);
        tessellator.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c);
        tessellator.a();
        tessellator.a(3);
        tessellator.a(axisalignedbb.a, axisalignedbb.e, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f);
        tessellator.a(axisalignedbb.a, axisalignedbb.e, axisalignedbb.f);
        tessellator.a(axisalignedbb.a, axisalignedbb.e, axisalignedbb.c);
        tessellator.a();
        tessellator.a(1);
        tessellator.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c);
        tessellator.a(axisalignedbb.a, axisalignedbb.e, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.b, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.c);
        tessellator.a(axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        tessellator.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f);
        tessellator.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.f);
        tessellator.a(axisalignedbb.a, axisalignedbb.e, axisalignedbb.f);
        tessellator.a();
    }

    private void drawCursor(ls camera, float time) {
        if (this.cursor != null && this.cursor.a == jg.a) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f1 = 0.002f;
            int j = this.world.a(this.cursor.b, this.cursor.c, this.cursor.d);
            if (j > 0) {
                uu.m[j].a((xp)this.world, this.cursor.b, this.cursor.c, this.cursor.d);
                double d2 = camera.bl + (camera.aM - camera.bl) * (double)time;
                double d1 = camera.bm + (camera.aN - camera.bm) * (double)time;
                double d22 = camera.bn + (camera.aO - camera.bn) * (double)time;
                eq box = uu.m[j].f(this.world, this.cursor.b, this.cursor.c, this.cursor.d).b((double)f1, (double)f1, (double)f1).c(-d2, -d1, -d22);
                this.drawBox(box);
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GL11.glLineWidth((float)4.0f);
                nw tessellator = nw.a;
                tessellator.a(3);
                if (this.cursor.e == 0) {
                    tessellator.a(box.a, box.b, box.c);
                    tessellator.a(box.d, box.b, box.c);
                    tessellator.a(box.d, box.b, box.f);
                    tessellator.a(box.a, box.b, box.f);
                    tessellator.a(box.a, box.b, box.c);
                } else if (this.cursor.e == 1) {
                    tessellator.a(box.a, box.e, box.c);
                    tessellator.a(box.d, box.e, box.c);
                    tessellator.a(box.d, box.e, box.f);
                    tessellator.a(box.a, box.e, box.f);
                    tessellator.a(box.a, box.e, box.c);
                } else if (this.cursor.e == 2) {
                    tessellator.a(box.a, box.b, box.c);
                    tessellator.a(box.d, box.b, box.c);
                    tessellator.a(box.d, box.e, box.c);
                    tessellator.a(box.a, box.e, box.c);
                    tessellator.a(box.a, box.b, box.c);
                } else if (this.cursor.e == 3) {
                    tessellator.a(box.a, box.b, box.f);
                    tessellator.a(box.d, box.b, box.f);
                    tessellator.a(box.d, box.e, box.f);
                    tessellator.a(box.a, box.e, box.f);
                    tessellator.a(box.a, box.b, box.f);
                } else if (this.cursor.e == 4) {
                    tessellator.a(box.a, box.b, box.c);
                    tessellator.a(box.a, box.e, box.c);
                    tessellator.a(box.a, box.e, box.f);
                    tessellator.a(box.a, box.b, box.f);
                    tessellator.a(box.a, box.b, box.c);
                } else if (this.cursor.e == 5) {
                    tessellator.a(box.d, box.b, box.c);
                    tessellator.a(box.d, box.e, box.c);
                    tessellator.a(box.d, box.e, box.f);
                    tessellator.a(box.d, box.b, box.f);
                    tessellator.a(box.d, box.b, box.c);
                }
                tessellator.a();
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    void setBlock(int bID, int m) {
        this.selectedBlockID = bID;
        this.selectedMetadata = m;
    }
}

