/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class MapList {
    private List<net.minecraft.src.ACMapInfo> availableMaps = new ArrayList<net.minecraft.src.ACMapInfo>();
    private File mapDir;

    public MapList(File file) {
        this.mapDir = new File(file, "../maps");
        if (!this.mapDir.exists()) {
            this.mapDir.mkdirs();
        }
        this.findMaps();
    }

    public void findMaps() {
        ArrayList<net.minecraft.src.ACMapInfo> arraylist = new ArrayList<net.minecraft.src.ACMapInfo>();
        if (this.mapDir.exists() && this.mapDir.isDirectory()) {
            File[] afile;
            for (File file : afile = this.mapDir.listFiles()) {
                if (!file.isDirectory()) continue;
                String mapName = file.getName();
                String description1 = "";
                String description2 = "";
                File infoFile = new File(file, "description.txt");
                try {
                    BufferedReader input = new BufferedReader(new FileReader(infoFile));
                    description1 = input.readLine();
                    description2 = input.readLine();
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                File thumbnailFile = new File(file, "thumbnail.png");
                BufferedImage thumbnail = null;
                try {
                    thumbnail = ImageIO.read(thumbnailFile);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                arraylist.add((net.minecraft.src.ACMapInfo)new ACMapInfo(mapName, description1, description2, thumbnail));
            }
        }
        this.availableMaps = arraylist;
    }

    public List<net.minecraft.src.ACMapInfo> availableMaps() {
        return new ArrayList<net.minecraft.src.ACMapInfo>(this.availableMaps);
    }
}

