/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.script.Script;
import org.mozilla.javascript.Scriptable;

public class MusicScripts {
    ArrayList<net.minecraft.src.MusicScriptEntry> musicEntries = new ArrayList();
    JScriptHandler handler;
    public Scriptable scope;

    MusicScripts(Script script, File mapDir, JScriptHandler h2) {
        this.handler = h2;
        this.scope = script.getNewScope();
        this.loadMusic(mapDir);
    }

    public void loadMusic(File mapDir) {
        this.musicEntries.clear();
        File musicFile = new File(mapDir, "musicScripts.txt");
        if (musicFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(musicFile));
                try {
                    while (reader.ready()) {
                        this.processLine(reader.readLine());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void processLine(String line) {
        String[] parts = line.split(",", 3);
        if (parts.length == 3) {
            this.musicEntries.add((net.minecraft.src.MusicScriptEntry)new MusicScriptEntry(parts[0].trim(), parts[1].trim(), parts[2].trim()));
        }
    }

    public String executeMusic(String music) {
        for (MusicScriptEntry musicScriptEntry : this.musicEntries) {
            if (!musicScriptEntry.music.equals(music)) continue;
            this.handler.runScript(musicScriptEntry.scriptFile, this.scope);
            return musicScriptEntry.songName;
        }
        return null;
    }
}

