/*
 * Decompiled with CFR 0.152.
 */
import net.minecraft.client.Minecraft;

public class PlayerTorch {
    static boolean torchActive;
    static float posX;
    static float posY;
    static float posZ;
    static int iX;
    static int iY;
    static int iZ;
    static int torchBrightness;
    static int range;
    static float[] cache;

    public static boolean isTorchActive() {
        return torchActive;
    }

    public static void setTorchState(fd world, boolean active) {
        if (torchActive != active) {
            torchActive = active;
            PlayerTorch.markBlocksDirty(world);
        }
    }

    public static void setTorchPos(fd world, float x2, float y, float z) {
        long avgTime = Minecraft.minecraftInstance.getAvgFrameTime();
        int updateRate = 1;
        if (avgTime > 33333333L) {
            updateRate = 3;
        } else if (avgTime > 16666666L) {
            updateRate = 2;
        }
        if (world.t() % (long)updateRate == 0L && (posX != x2 || posY != y || posZ != z)) {
            posX = x2;
            posY = y;
            posZ = z;
            iX = (int)posX;
            iY = (int)posY;
            iZ = (int)posZ;
            PlayerTorch.markBlocksDirty(world);
        }
    }

    public static float getTorchLight(fd world, int x2, int y, int z) {
        if (torchActive) {
            int diffX = x2 - iX + torchBrightness;
            int diffY = y - iY + torchBrightness;
            int diffZ = z - iZ + torchBrightness;
            if (diffX >= 0 && diffX < range && diffY >= 0 && diffY < range && diffZ >= 0 && diffZ < range) {
                return cache[diffX * range * range + diffY * range + diffZ];
            }
        }
        return 0.0f;
    }

    private static void markBlocksDirty(fd world) {
        float xDiff = posX - (float)iX;
        float yDiff = posY - (float)iY;
        float zDiff = posZ - (float)iZ;
        int index = 0;
        for (int i2 = -torchBrightness; i2 <= torchBrightness; ++i2) {
            int blockX = i2 + iX;
            for (int j = -torchBrightness; j <= torchBrightness; ++j) {
                int blockY = j + iY;
                for (int k = -torchBrightness; k <= torchBrightness; ++k) {
                    int blockZ = k + iZ;
                    int blockId = world.a(blockX, blockY, blockZ);
                    if (blockId != 0 && uu.m[blockId].c() && blockId != uu.al.bn && blockId != uu.aB.bn) {
                        PlayerTorch.cache[index++] = 0.0f;
                        continue;
                    }
                    float distance = (float)(Math.abs((double)i2 + 0.5 - (double)xDiff) + Math.abs((double)j + 0.5 - (double)yDiff) + Math.abs((double)k + 0.5 - (double)zDiff));
                    if (distance <= (float)torchBrightness) {
                        if ((float)torchBrightness - distance > (float)world.n(blockX, blockY, blockZ)) {
                            world.j(blockX, blockY, blockZ);
                        }
                        PlayerTorch.cache[index++] = (float)torchBrightness - distance;
                        continue;
                    }
                    PlayerTorch.cache[index++] = 0.0f;
                }
            }
        }
    }

    static {
        torchBrightness = 15;
        range = torchBrightness * 2 + 1;
        cache = new float[range * range * range];
    }
}

