/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.src.ProfileContext;

public class Profiler {
    static Stack<ProfileContext> profileStack;
    static HashMap<String, Long> times;
    static long startTime;

    public static void startTiming(String context) {
        if (profileStack != null) {
            profileStack.push((ProfileContext)new ProfileContext(context));
        }
    }

    public static void stopTiming() {
        if (profileStack != null) {
            ProfileContext c2 = (ProfileContext)profileStack.pop();
            long t2 = c2.getTime();
            if (times.containsKey(c2.contextName)) {
                times.put(c2.contextName, times.get(c2.contextName) + t2);
            } else {
                times.put(c2.contextName, t2);
            }
        }
    }

    public static void startFrame() {
        profileStack = new Stack();
        times = new HashMap();
        startTime = System.nanoTime();
    }

    public static void stopFrame() {
        if (profileStack != null) {
            long time = System.nanoTime() - startTime;
            if (time > 100000000L) {
                for (Map.Entry<String, Long> e : times.entrySet()) {
                    System.out.printf("%s\t\t%d\n", e.getKey(), e.getValue());
                }
            }
            profileStack = null;
            times = null;
        }
    }
}

