/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class TerrainImage {
    private static int[] biomeInfo;
    private static int[] terrainInfo;
    private static int[] waterInfo;
    private static int imageHeight;
    private static int imageWidth;
    private static int halfHeight;
    private static int halfWidth;
    public static boolean isLoaded;
    public static boolean isWaterLoaded;

    private static int getOffset(int x2, int z) {
        z += halfHeight;
        if ((x2 += halfWidth) < 0) {
            x2 = 0;
        } else if (x2 >= imageWidth) {
            x2 = imageWidth - 1;
        }
        if (z < 0) {
            z = 0;
        } else if (z >= imageHeight) {
            z = imageHeight - 1;
        }
        return x2 + z * imageWidth;
    }

    public static int getTerrainInfo(int x2, int z) {
        return terrainInfo[TerrainImage.getOffset(x2, z)];
    }

    public static int getBiomeInfo(int x2, int z) {
        return biomeInfo[TerrainImage.getOffset(x2, z)];
    }

    public static int getWaterColor(int x2, int z) {
        if (isWaterLoaded) {
            return waterInfo[TerrainImage.getOffset(x2, z)];
        }
        return 4221183;
    }

    public static int getTerrainHeight(int x2, int z) {
        if (!isLoaded) {
            return 64;
        }
        int value = TerrainImage.getTerrainInfo(x2, z);
        return (value >> 8 & 0xFF) / 2;
    }

    public static int getWaterHeight(int x2, int z) {
        if (!isLoaded) {
            return 0;
        }
        int value = TerrainImage.getTerrainInfo(x2, z);
        return (value & 0xFF) / 2;
    }

    public static boolean hasSandNearWaterEdge(int x2, int z) {
        if (!isLoaded) {
            return false;
        }
        int value = TerrainImage.getTerrainInfo(x2, z);
        return (value >> 16 & 0xFF) > 127;
    }

    public static double getTerrainHumidity(int x2, int z) {
        if (!isLoaded) {
            return 0.25;
        }
        return (double)(TerrainImage.getBiomeInfo(x2, z) & 0xFF) / 255.0;
    }

    public static double getTerrainTemperature(int x2, int z) {
        if (!isLoaded) {
            return 0.75;
        }
        return (double)(TerrainImage.getBiomeInfo(x2, z) >> 16 & 0xFF) / 255.0;
    }

    public static boolean loadBiomeMap(File biomeFile) {
        try {
            BufferedImage bufferedimage = ImageIO.read(biomeFile);
            assert (imageWidth == bufferedimage.getWidth()) : "biomeMap.png width doesn't match the width of terrainMap.png";
            assert (imageHeight == bufferedimage.getHeight()) : "biomeMap.png height doesn't match the height of terrainMap.png";
            bufferedimage.getRGB(0, 0, imageWidth, imageHeight, biomeInfo, 0, imageWidth);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean loadWaterMap(File waterFile) {
        try {
            BufferedImage bufferedimage = ImageIO.read(waterFile);
            assert (imageWidth == bufferedimage.getWidth()) : "waterMap.png width doesn't match the width of terrainMap.png";
            assert (imageHeight == bufferedimage.getHeight()) : "waterMap.png height doesn't match the height of terrainMap.png";
            waterInfo = new int[imageWidth * imageHeight];
            bufferedimage.getRGB(0, 0, imageWidth, imageHeight, waterInfo, 0, imageWidth);
            isWaterLoaded = true;
        }
        catch (Exception exception) {
            isWaterLoaded = false;
            return false;
        }
        return true;
    }

    public static boolean loadMap(File f) {
        biomeInfo = new int[0];
        terrainInfo = new int[0];
        waterInfo = new int[0];
        imageWidth = 0;
        imageHeight = 0;
        halfWidth = 0;
        halfHeight = 0;
        isWaterLoaded = false;
        try {
            File terrainFile = new File(f, "terrainMap.png");
            System.out.printf("Exists: %b Path: %s\n", terrainFile.exists(), terrainFile.getCanonicalPath());
            BufferedImage bufferedimage = ImageIO.read(terrainFile);
            imageWidth = bufferedimage.getWidth();
            imageHeight = bufferedimage.getHeight();
            halfWidth = imageWidth / 2;
            halfHeight = imageHeight / 2;
            terrainInfo = new int[imageWidth * imageHeight];
            biomeInfo = new int[imageWidth * imageHeight];
            bufferedimage.getRGB(0, 0, imageWidth, imageHeight, terrainInfo, 0, imageWidth);
            File biomeFile = new File(f, "biomeMap.png");
            if (!TerrainImage.loadBiomeMap(biomeFile)) {
                isLoaded = false;
                return false;
            }
            File waterFile = new File(f, "waterMap.png");
            TerrainImage.loadWaterMap(waterFile);
            isLoaded = true;
        }
        catch (Exception exception) {
            isLoaded = false;
            return false;
        }
        return true;
    }
}

