/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.script.ScopeTag;
import net.minecraft.script.ScriptEntity;
import net.minecraft.src.Entity;
import org.mozilla.javascript.Scriptable;

public class TileEntityMobSpawnerNew
extends TileEntityScript {
    public int delay = 20;
    public String entityID = "Pig";
    public int spawnNumber = 3;
    public int respawnDelay = 1200;
    public int dropItem = 0;
    public boolean hasDroppedItem = false;
    public boolean spawnOnTrigger = true;
    public boolean spawnOnDetrigger = false;
    public List<Entity> spawnedEntities = new ArrayList<Entity>();
    public List<Entity> entitiesLeft = new ArrayList<Entity>();
    public int spawnID;
    public int spawnMeta;
    Random rand = new Random();
    public Coord[] minVec = new Coord[8];
    public Coord[] maxVec = new Coord[8];
    public Coord minSpawnVec;
    public Coord maxSpawnVec;
    public int ticksBeforeLoad = 20;
    public nu delayLoadData;
    private boolean spawnStill = false;
    Scriptable scope;

    public TileEntityMobSpawnerNew() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.minVec[i2] = new Coord();
            this.maxVec[i2] = new Coord();
        }
        this.minSpawnVec = new Coord();
        this.maxSpawnVec = new Coord();
        this.delayLoadData = null;
        this.scope = Minecraft.minecraftInstance.f.script.getNewScope();
    }

    public int getNumAlive() {
        int numAlive = 0;
        for (sn sn2 : this.spawnedEntities) {
            if (!sn2.be) {
                ++numAlive;
                continue;
            }
            if (!this.entitiesLeft.contains(sn2)) continue;
            this.entitiesLeft.remove(sn2);
        }
        return numAlive;
    }

    public void resetMobs() {
        for (sn sn2 : this.spawnedEntities) {
            if (sn2.be) continue;
            sn2.K();
        }
        this.spawnedEntities.clear();
        this.entitiesLeft.clear();
        this.deactivateTriggers();
    }

    private boolean canSpawn(sn entity) {
        return this.d.a(entity.aW) && this.d.a(entity, entity.aW).size() == 0 && !this.d.b(entity.aW);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void spawnMobs() {
        if (this.delay > 0 || this.getNumAlive() > 0 || this.delayLoadData != null) {
            return;
        }
        for (int i2 = 0; i2 < this.spawnNumber * 6; ++i2) {
            gi w2;
            fr rider;
            String spawnEntityID = this.entityID.replace(" ", "");
            if (spawnEntityID.equalsIgnoreCase("FallingBlock")) {
                spawnEntityID = "FallingSand";
            } else if (spawnEntityID.startsWith("Slime")) {
                spawnEntityID = "Slime";
            } else if (spawnEntityID.startsWith("Minecart")) {
                spawnEntityID = "Minecart";
            } else if (spawnEntityID.startsWith("Spider")) {
                spawnEntityID = "Spider";
            } else if (spawnEntityID.startsWith("Wolf")) {
                spawnEntityID = "Wolf";
            } else if (spawnEntityID.endsWith("(Scripted)")) {
                spawnEntityID = "Script";
            }
            sn entity = jc.a(spawnEntityID, this.d);
            if (entity == null) {
                return;
            }
            if (spawnEntityID.equalsIgnoreCase("FallingSand")) {
                if (this.spawnID >= 256 || uu.m[this.spawnID] == null) return;
                ((ju)entity).a = this.spawnID;
                ((ju)entity).metadata = this.spawnMeta;
            } else if (spawnEntityID.equalsIgnoreCase("Item")) {
                if (gm.c[this.spawnID] == null) return;
                ((hl)entity).a = new iz(this.spawnID, 1, this.spawnMeta);
            } else if (this.entityID.startsWith("Slime") && this.entityID.length() > 6) {
                int size = Integer.parseInt(this.entityID.split(":")[1].trim());
                ((uw)entity).e(size);
            } else if (this.entityID.equalsIgnoreCase("Minecart Chest")) {
                ((yl)entity).d = 1;
            } else if (this.entityID.equalsIgnoreCase("Minecart Furnace")) {
                ((yl)entity).d = 2;
            }
            double posY = this.maxSpawnVec.y == this.minSpawnVec.y ? (double)(this.f + this.maxSpawnVec.y) : (double)(this.f + this.minSpawnVec.y + this.d.r.nextInt(this.maxSpawnVec.y - this.minSpawnVec.y));
            double posX = (double)(this.e + this.minSpawnVec.x) + this.d.r.nextDouble() * (double)(this.maxSpawnVec.x - this.minSpawnVec.x) + 0.5;
            double posZ = (double)(this.g + this.minSpawnVec.z) + this.d.r.nextDouble() * (double)(this.maxSpawnVec.z - this.minSpawnVec.z) + 0.5;
            float rot = !spawnEntityID.equalsIgnoreCase("FallingSand") ? this.d.r.nextFloat() * 360.0f : 0.0f;
            entity.c(posX, posY, posZ, rot, 0.0f);
            if (!this.canSpawn(entity)) continue;
            this.d.b(entity);
            if (this.entityID.equalsIgnoreCase("Spider Skeleton")) {
                rider = new fr(this.d);
                rider.c(posX, posY, posZ, rot, 0.0f);
                this.d.b(rider);
                rider.i(entity);
                this.spawnedEntities.add((Entity)rider);
                this.entitiesLeft.add((Entity)rider);
            } else if (this.entityID.equalsIgnoreCase("Spider Skeleton Sword")) {
                rider = new EntitySkeletonSword(this.d);
                rider.c(posX, posY, posZ, rot, 0.0f);
                this.d.b(rider);
                rider.i(entity);
                this.spawnedEntities.add((Entity)rider);
                this.entitiesLeft.add((Entity)rider);
            } else if (this.entityID.equalsIgnoreCase("Wolf (Angry)")) {
                w2 = (gi)((Object)entity);
                w2.c(true);
            } else if (this.entityID.equalsIgnoreCase("Wolf (Tame)")) {
                w2 = (gi)((Object)entity);
                w2.d(true);
                w2.a(null);
                w2.Y = 20;
                w2.a(Minecraft.minecraftInstance.h.l);
                w2.a(true);
                this.d.a((sn)((Object)w2), (byte)7);
            }
            if (this.entityID.endsWith("(Scripted)")) {
                EntityLivingScript els = (EntityLivingScript)entity;
                els.setEntityDescription(this.entityID.replace(" (Scripted)", ""));
            }
            if (entity instanceof ls) {
                ((ls)entity).V();
            }
            this.spawnedEntities.add((Entity)entity);
            this.entitiesLeft.add((Entity)entity);
            if (this.spawnedEntities.size() >= this.spawnNumber) break;
        }
        if (this.spawnNumber > 0 && this.spawnedEntities.size() == 0) {
            this.delay = 20;
            this.spawnStill = true;
            return;
        } else {
            this.activateTriggers();
            this.executeScript(this.onTriggerScriptFile);
            this.spawnStill = false;
        }
    }

    @Override
    public void n_() {
        if (this.delayLoadData != null) {
            if (this.ticksBeforeLoad == 0) {
                int num = this.delayLoadData.d("numEntities");
                block0: for (int i2 = 0; i2 < num; ++i2) {
                    int entID = this.delayLoadData.e(String.format("entID_%d", i2));
                    for (Object obj : this.d.b) {
                        sn e = (sn)obj;
                        if (e.aD != entID) continue;
                        this.spawnedEntities.add((Entity)e);
                        if (!e.W()) continue block0;
                        this.entitiesLeft.add((Entity)e);
                        continue block0;
                    }
                }
                this.delayLoadData = null;
                if (num > 0) {
                    this.executeScript(this.onTriggerScriptFile);
                }
            }
            --this.ticksBeforeLoad;
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (!this.spawnedEntities.isEmpty()) {
            if (this.getNumAlive() == 0) {
                this.spawnedEntities.clear();
                this.entitiesLeft.clear();
                this.delay = this.respawnDelay;
                if (this.dropItem > 0 && !this.hasDroppedItem) {
                    hl entityitem = new hl(this.d, (double)this.e + 0.5, (double)this.f + 0.5, (double)this.g + 0.5, new iz(this.dropItem, 1, 0));
                    entityitem.c = 10;
                    this.d.b(entityitem);
                    for (int i3 = 0; i3 < 20; ++i3) {
                        double d2 = this.rand.nextGaussian() * 0.02;
                        double d1 = this.rand.nextGaussian() * 0.02;
                        double d22 = this.rand.nextGaussian() * 0.02;
                        double d3 = 10.0;
                        this.d.a("explode", entityitem.aM + (double)(this.rand.nextFloat() * 2.0f) - 1.0 - d2 * d3, entityitem.aN + (double)this.rand.nextFloat() - d1 * d3, entityitem.aO + (double)(this.rand.nextFloat() * 2.0f) - 1.0 - d22 * d3, d2, d1, d22);
                    }
                    this.hasDroppedItem = true;
                }
                this.executeScript(this.onDetriggerScriptFile);
                for (int i4 = 4; i4 < 8; ++i4) {
                    if (!this.isTriggerSet(i4)) continue;
                    this.activateTrigger(i4, this.minVec[i4], this.maxVec[i4]);
                }
                this.deactivateTriggers();
            } else {
                this.executeScript(this.onUpdateScriptFile);
            }
            return;
        }
        if (this.spawnStill || !this.spawnOnTrigger && !this.spawnOnDetrigger) {
            this.spawnMobs();
        }
        super.n_();
    }

    public void setSpawnVec() {
        this.minSpawnVec.set(ItemCursor.minX - this.e, ItemCursor.minY - this.f, ItemCursor.minZ - this.g);
        this.maxSpawnVec.set(ItemCursor.maxX - this.e, ItemCursor.maxY - this.f, ItemCursor.maxZ - this.g);
    }

    public boolean isTriggerSet(int i2) {
        boolean r = this.minVec[i2].x != 0;
        r = r || this.minVec[i2].y != 0;
        r = r || this.minVec[i2].z != 0;
        r = r || this.maxVec[i2].x != 0;
        r = r || this.maxVec[i2].y != 0;
        r = r || this.maxVec[i2].z != 0;
        return r;
    }

    public void setTrigger(int i2) {
        this.minVec[i2].set(ItemCursor.minX, ItemCursor.minY, ItemCursor.minZ);
        this.maxVec[i2].set(ItemCursor.maxX, ItemCursor.maxY, ItemCursor.maxZ);
    }

    public void setCursor(int i2) {
        ItemCursor.oneX = ItemCursor.minX = this.minVec[i2].x;
        ItemCursor.oneY = ItemCursor.minY = this.minVec[i2].y;
        ItemCursor.oneZ = ItemCursor.minZ = this.minVec[i2].z;
        ItemCursor.twoX = ItemCursor.maxX = this.maxVec[i2].x;
        ItemCursor.twoY = ItemCursor.maxY = this.maxVec[i2].y;
        ItemCursor.twoZ = ItemCursor.maxZ = this.maxVec[i2].z;
    }

    public void clearTrigger(int i2) {
        this.minVec[i2].z = 0;
        this.minVec[i2].y = 0;
        this.minVec[i2].x = 0;
        this.maxVec[i2].z = 0;
        this.maxVec[i2].y = 0;
        this.maxVec[i2].x = 0;
    }

    private void activateTriggers() {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!this.isTriggerSet(i2)) continue;
            this.activateTrigger(i2, this.minVec[i2], this.maxVec[i2]);
        }
    }

    private void activateTrigger(int i2, Coord minVec, Coord maxVec) {
        if (minVec.x == 0 && minVec.y == 0 && minVec.z == 0 && maxVec.x == 0 && maxVec.y == 0 && maxVec.z == 0) {
            return;
        }
        this.d.triggerManager.addArea(this.e, this.f, this.g, i2, new TriggerArea(minVec.x, minVec.y, minVec.z, maxVec.x, maxVec.y, maxVec.z));
    }

    private void deactivateTriggers() {
        this.d.triggerManager.removeArea(this.e, this.f, this.g);
    }

    @Override
    public void a(nu nbttagcompound) {
        super.a(nbttagcompound);
        this.entityID = nbttagcompound.i("EntityId");
        this.delay = nbttagcompound.d("Delay");
        this.respawnDelay = nbttagcompound.e("RespawnDelay");
        this.spawnNumber = nbttagcompound.e("SpawnNumber");
        this.spawnOnTrigger = nbttagcompound.m("SpawnOnTrigger");
        this.spawnOnDetrigger = nbttagcompound.m("SpawnOnDetrigger");
        this.dropItem = nbttagcompound.e("DropItem");
        this.hasDroppedItem = nbttagcompound.m("HasDroppedItem");
        this.spawnID = nbttagcompound.e("SpawnID");
        for (int i2 = 0; i2 < 8; ++i2) {
            this.minVec[i2].x = nbttagcompound.e("minX".concat(Integer.toString(i2)));
            this.minVec[i2].y = nbttagcompound.e("minY".concat(Integer.toString(i2)));
            this.minVec[i2].z = nbttagcompound.e("minZ".concat(Integer.toString(i2)));
            this.maxVec[i2].x = nbttagcompound.e("maxX".concat(Integer.toString(i2)));
            this.maxVec[i2].y = nbttagcompound.e("maxY".concat(Integer.toString(i2)));
            this.maxVec[i2].z = nbttagcompound.e("maxZ".concat(Integer.toString(i2)));
        }
        this.minSpawnVec.x = nbttagcompound.e("minSpawnX");
        this.minSpawnVec.y = nbttagcompound.e("minSpawnY");
        this.minSpawnVec.z = nbttagcompound.e("minSpawnZ");
        this.maxSpawnVec.x = nbttagcompound.e("maxSpawnX");
        this.maxSpawnVec.y = nbttagcompound.e("maxSpawnY");
        this.maxSpawnVec.z = nbttagcompound.e("maxSpawnZ");
        if (nbttagcompound.b("numEntities") && nbttagcompound.d("numEntities") > 0) {
            this.ticksBeforeLoad = 20;
            this.delayLoadData = nbttagcompound;
        }
        if (nbttagcompound.b("scope")) {
            ScopeTag.loadScopeFromTag(this.scope, nbttagcompound.k("scope"));
        }
    }

    @Override
    public void b(nu nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("EntityId", this.entityID);
        nbttagcompound.a("Delay", (short)this.delay);
        nbttagcompound.a("RespawnDelay", this.respawnDelay);
        nbttagcompound.a("SpawnNumber", this.spawnNumber);
        nbttagcompound.a("SpawnOnTrigger", this.spawnOnTrigger);
        nbttagcompound.a("SpawnOnDetrigger", this.spawnOnDetrigger);
        nbttagcompound.a("SpawnID", this.spawnID);
        nbttagcompound.a("DropItem", this.dropItem);
        nbttagcompound.a("HasDroppedItem", this.hasDroppedItem);
        for (int i2 = 0; i2 < 8; ++i2) {
            nbttagcompound.a("minX".concat(Integer.toString(i2)), this.minVec[i2].x);
            nbttagcompound.a("minY".concat(Integer.toString(i2)), this.minVec[i2].y);
            nbttagcompound.a("minZ".concat(Integer.toString(i2)), this.minVec[i2].z);
            nbttagcompound.a("maxX".concat(Integer.toString(i2)), this.maxVec[i2].x);
            nbttagcompound.a("maxY".concat(Integer.toString(i2)), this.maxVec[i2].y);
            nbttagcompound.a("maxZ".concat(Integer.toString(i2)), this.maxVec[i2].z);
        }
        nbttagcompound.a("minSpawnX", this.minSpawnVec.x);
        nbttagcompound.a("minSpawnY", this.minSpawnVec.y);
        nbttagcompound.a("minSpawnZ", this.minSpawnVec.z);
        nbttagcompound.a("maxSpawnX", this.maxSpawnVec.x);
        nbttagcompound.a("maxSpawnY", this.maxSpawnVec.y);
        nbttagcompound.a("maxSpawnZ", this.maxSpawnVec.z);
        nbttagcompound.a("numEntities", (short)this.spawnedEntities.size());
        int i2 = 0;
        for (sn sn2 : this.spawnedEntities) {
            nbttagcompound.a(String.format("entID_%d", i2), sn2.aD);
            ++i2;
        }
        nbttagcompound.a("scope", (ij)ScopeTag.getTagFromScope(this.scope));
    }

    private void executeScript(String scriptName) {
        if (!scriptName.equals("")) {
            int i2 = 0;
            ScriptEntity[] scriptSpawnedEntities = new ScriptEntity[this.entitiesLeft.size()];
            for (sn sn2 : this.entitiesLeft) {
                scriptSpawnedEntities[i2++] = ScriptEntity.getEntityClass(sn2);
            }
            this.d.script.addObject("spawnedEntities", scriptSpawnedEntities);
            this.d.scriptHandler.runScript(scriptName, this.scope);
        }
    }
}

