/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import net.minecraft.src.NBTTagCompound;

public class TileEntityStorage
extends TileEntityMinMax {
    byte[] blockIDs = null;
    byte[] metadatas = null;
    ArrayList<NBTTagCompound> tileEntities = new ArrayList();

    TileEntityStorage() {
    }

    void setArea() {
        this.minX = ItemCursor.minX;
        this.minY = ItemCursor.minY;
        this.minZ = ItemCursor.minZ;
        this.maxX = ItemCursor.maxX;
        this.maxY = ItemCursor.maxY;
        this.maxZ = ItemCursor.maxZ;
        int dX = this.maxX - this.minX + 1;
        int dY = this.maxY - this.minY + 1;
        int dZ = this.maxZ - this.minZ + 1;
        int size = dX * dY * dZ;
        this.blockIDs = new byte[size];
        this.metadatas = new byte[size];
        this.saveCurrentArea();
    }

    void saveCurrentArea() {
        int offset = 0;
        this.tileEntities.clear();
        for (int x2 = this.minX; x2 <= this.maxX; ++x2) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int blockID = this.d.a(x2, y, z);
                    int metadata = this.d.e(x2, y, z);
                    this.blockIDs[offset] = (byte)lm.translate128(blockID);
                    this.metadatas[offset] = (byte)metadata;
                    ow te = this.d.b(x2, y, z);
                    if (te != null) {
                        nu tag = new nu();
                        te.b(tag);
                        this.tileEntities.add((NBTTagCompound)tag);
                    }
                    ++offset;
                }
            }
        }
    }

    void loadCurrentArea() {
        if (this.blockIDs == null) {
            return;
        }
        int offset = 0;
        for (int x2 = this.minX; x2 <= this.maxX; ++x2) {
            for (int j = this.minZ; j <= this.maxZ; ++j) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int prevBlockID = this.d.a(x2, y, j);
                    this.d.cancelBlockUpdate(x2, y, j, prevBlockID);
                    int blockID = lm.translate256(this.blockIDs[offset]);
                    byte metadata = this.metadatas[offset];
                    this.d.b(x2, y, j, blockID, (int)metadata);
                    ++offset;
                }
            }
        }
        for (nu nu2 : this.tileEntities) {
            ow te = ow.c(nu2);
            this.d.a(te.e, te.f, te.g, te);
        }
    }

    @Override
    public void a(nu nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("blockIDs")) {
            this.blockIDs = nbttagcompound.j("blockIDs");
        }
        if (nbttagcompound.b("metadatas")) {
            this.metadatas = nbttagcompound.j("metadatas");
        }
        if (nbttagcompound.b("numTiles")) {
            this.tileEntities.clear();
            int numTiles = nbttagcompound.e("numTiles");
            for (int i2 = 0; i2 < numTiles; ++i2) {
                this.tileEntities.add((NBTTagCompound)nbttagcompound.k(String.format("tile%d", i2)));
            }
        }
    }

    @Override
    public void b(nu nbttagcompound) {
        super.b(nbttagcompound);
        if (this.blockIDs != null) {
            nbttagcompound.a("blockIDs", this.blockIDs);
        }
        if (this.metadatas != null) {
            nbttagcompound.a("metadatas", this.metadatas);
        }
        if (!this.tileEntities.isEmpty()) {
            int i2 = 0;
            for (nu nu2 : this.tileEntities) {
                nbttagcompound.a(String.format("tile%d", i2), (ij)nu2);
                ++i2;
            }
            nbttagcompound.a("numTiles", i2);
        }
    }
}

