/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.BlockCoord;

public class TriggerManager {
    fd world;
    HashMap<BlockCoord, HashMap<Integer, net.minecraft.src.TriggerArea>> triggerAreas;

    TriggerManager(fd w2) {
        this.world = w2;
        this.triggerAreas = new HashMap();
    }

    public void addArea(int x2, int y, int z, TriggerArea newArea) {
        this.addArea(x2, y, z, 0, newArea);
    }

    public void addArea(int x2, int y, int z, int areaID, TriggerArea newArea) {
        BlockCoord coord = new BlockCoord(x2, y, z);
        HashMap<Integer, Object> areas = this.triggerAreas.get(coord);
        if (areas == null) {
            areas = new HashMap();
            this.triggerAreas.put((BlockCoord)coord, areas);
        }
        TriggerArea prevArea = (TriggerArea)areas.get(areaID);
        ArrayList blocks = this.findBlocksToActivate(newArea);
        areas.put(areaID, (net.minecraft.src.TriggerArea)newArea);
        this.activateBlocks(blocks);
        if (prevArea != null) {
            this.deactivateArea(prevArea);
        }
    }

    public void removeArea(int x2, int y, int z) {
        BlockCoord coord = new BlockCoord(x2, y, z);
        HashMap<Integer, net.minecraft.src.TriggerArea> areas = this.triggerAreas.get(coord);
        if (areas != null) {
            for (Integer i2 : ((HashMap)areas.clone()).keySet()) {
                this.removeArea(coord, areas, (int)i2);
            }
        }
    }

    public void removeArea(int x2, int y, int z, int areaID) {
        BlockCoord coord = new BlockCoord(x2, y, z);
        HashMap<Integer, net.minecraft.src.TriggerArea> areas = this.triggerAreas.get(coord);
        if (areas != null) {
            this.removeArea(coord, areas, areaID);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void removeArea(BlockCoord coord, HashMap areas, int areaID) {
        TriggerArea prevArea = (TriggerArea)areas.get(areaID);
        if (prevArea != null) {
            areas.remove(areaID);
            if (areas.isEmpty()) {
                this.triggerAreas.remove(coord);
            }
            this.deactivateArea(prevArea);
        }
    }

    int getTriggerAmount(int x2, int y, int z) {
        int count = 0;
        for (HashMap<Integer, net.minecraft.src.TriggerArea> areas : this.triggerAreas.values()) {
            for (TriggerArea triggerArea : areas.values()) {
                if (!triggerArea.isPointInside(x2, y, z)) continue;
                ++count;
            }
        }
        return count;
    }

    boolean isActivated(int x2, int y, int z) {
        for (HashMap<Integer, net.minecraft.src.TriggerArea> areas : this.triggerAreas.values()) {
            for (TriggerArea triggerArea : areas.values()) {
                if (!triggerArea.isPointInside(x2, y, z)) continue;
                return true;
            }
        }
        return false;
    }

    void outputTriggerSources(int x2, int y, int z) {
        Minecraft.minecraftInstance.v.a(String.format("Outputting active triggerings for (%d, %d, %d)", x2, y, z));
        for (Map.Entry<BlockCoord, HashMap<Integer, net.minecraft.src.TriggerArea>> e : this.triggerAreas.entrySet()) {
            HashMap<Integer, net.minecraft.src.TriggerArea> areas = e.getValue();
            for (TriggerArea triggerArea : areas.values()) {
                if (!triggerArea.isPointInside(x2, y, z)) continue;
                BlockCoord c2 = (BlockCoord)e.getKey();
                Minecraft.minecraftInstance.v.a(String.format("Triggered by (%d, %d, %d)", c2.x, c2.y, c2.z));
            }
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private ArrayList findBlocksToActivate(TriggerArea area) {
        ArrayList<BlockCoord> blocksToActivate = new ArrayList<BlockCoord>();
        for (int x2 = area.minX; x2 <= area.maxX; ++x2) {
            for (int y = area.minY; y <= area.maxY; ++y) {
                for (int z = area.minZ; z <= area.maxZ; ++z) {
                    if (this.getTriggerAmount(x2, y, z) != 0) continue;
                    blocksToActivate.add(new BlockCoord(x2, y, z));
                }
            }
        }
        return blocksToActivate;
    }

    private void activateBlocks(ArrayList<BlockCoord> blocksToActivate) {
        for (BlockCoord blockCoord : blocksToActivate) {
            int blockID = this.world.a(blockCoord.x, blockCoord.y, blockCoord.z);
            if (blockID == 0 || !uu.m[blockID].canBeTriggered()) continue;
            uu.m[blockID].onTriggerActivated(this.world, blockCoord.x, blockCoord.y, blockCoord.z);
        }
    }

    private void deactivateArea(TriggerArea area) {
        for (int x2 = area.minX; x2 <= area.maxX; ++x2) {
            for (int y = area.minY; y <= area.maxY; ++y) {
                for (int z = area.minZ; z <= area.maxZ; ++z) {
                    int blockID;
                    if (this.getTriggerAmount(x2, y, z) != 0 || (blockID = this.world.a(x2, y, z)) == 0 || !uu.m[blockID].canBeTriggered()) continue;
                    uu.m[blockID].onTriggerDeactivated(this.world, x2, y, z);
                }
            }
        }
    }

    nu getTagCompound() {
        nu tag = new nu();
        int numCoords = 0;
        for (Map.Entry<BlockCoord, HashMap<Integer, net.minecraft.src.TriggerArea>> e : this.triggerAreas.entrySet()) {
            nu coordTag = new nu();
            BlockCoord c2 = (BlockCoord)e.getKey();
            coordTag.a("x", c2.x);
            coordTag.a("y", c2.y);
            coordTag.a("z", c2.z);
            int numAreas = 0;
            for (Map.Entry<Integer, net.minecraft.src.TriggerArea> te : e.getValue().entrySet()) {
                nu areaTag = ((TriggerArea)te.getValue()).getTagCompound();
                areaTag.a("areaID", te.getKey());
                coordTag.a(String.format("area%d", numAreas++), (ij)areaTag);
            }
            coordTag.a("numAreas", numAreas);
            tag.a(String.format("coord%d", numCoords++), (ij)coordTag);
        }
        tag.a("numCoords", numCoords);
        return tag;
    }

    void loadFromTagCompound(nu tag) {
        this.triggerAreas.clear();
        int numCoords = tag.e("numCoords");
        for (int i2 = 0; i2 < numCoords; ++i2) {
            nu coordTag = tag.k(String.format("coord%d", i2));
            BlockCoord coord = new BlockCoord(coordTag.e("x"), coordTag.e("y"), coordTag.e("z"));
            HashMap<Integer, TriggerArea> areas = new HashMap<Integer, TriggerArea>();
            this.triggerAreas.put((BlockCoord)coord, areas);
            int numAreas = coordTag.e("numAreas");
            for (int j = 0; j < numAreas; ++j) {
                nu areaTag = coordTag.k(String.format("area%d", j));
                TriggerArea area = TriggerArea.getFromTagCompound(areaTag);
                areas.put(coordTag.e("areaID"), area);
            }
        }
    }
}

