/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.script;

import org.mozilla.javascript.Scriptable;

public class ScopeTag {
    public static nu getTagFromScope(Scriptable scope) {
        nu tag = new nu();
        for (Object id2 : scope.getIds()) {
            if (!(id2 instanceof String)) continue;
            String key = (String)id2;
            Object value = scope.get(key, scope);
            ScopeTag.saveProperty(tag, key, value);
        }
        return tag;
    }

    private static void saveProperty(nu tag, String key, Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            tag.a("String_" + key, strValue);
        } else if (value instanceof Boolean) {
            boolean bValue = (Boolean)value;
            tag.a("Boolean_" + key, bValue);
        } else if (value instanceof Number) {
            Number nValue = (Number)value;
            double dValue = nValue.doubleValue();
            float fValue = nValue.floatValue();
            long lValue = nValue.longValue();
            int iValue = nValue.intValue();
            short sValue = nValue.shortValue();
            if (dValue != (double)fValue) {
                tag.a("Double_" + key, dValue);
            } else if (fValue != (float)lValue) {
                tag.a("Float_" + key, fValue);
            } else if (lValue != (long)iValue) {
                tag.a("Long_" + key, lValue);
            } else if (iValue != sValue) {
                tag.a("Integer_" + key, iValue);
            } else {
                tag.a("Short_" + key, sValue);
            }
        }
    }

    public static void loadScopeFromTag(Scriptable scope, nu tag) {
        for (String varKey : tag.getKeys()) {
            String[] parts = varKey.split("_", 2);
            if (parts.length != 2) {
                System.out.printf("Unknown key in tag: %s %d\n", varKey, parts.length);
                continue;
            }
            String type = parts[0];
            String key = parts[1];
            if (type.equals("String")) {
                String value = tag.i(varKey);
                scope.put(key, scope, (Object)value);
                continue;
            }
            if (type.equals("Boolean")) {
                boolean value = tag.m(varKey);
                scope.put(key, scope, (Object)new Boolean(value));
                continue;
            }
            if (type.equals("Double")) {
                double value = tag.h(varKey);
                scope.put(key, scope, (Object)new Double(value));
                continue;
            }
            if (type.equals("Float")) {
                float value = tag.g(varKey);
                scope.put(key, scope, (Object)new Float(value));
                continue;
            }
            if (type.equals("Long")) {
                long value = tag.f(varKey);
                scope.put(key, scope, (Object)new Long(value));
                continue;
            }
            if (type.equals("Integer")) {
                int value = tag.e(varKey);
                scope.put(key, scope, (Object)new Integer(value));
                continue;
            }
            if (type.equals("Short")) {
                short value = tag.d(varKey);
                scope.put(key, scope, (Object)new Short(value));
                continue;
            }
            System.out.printf("Unknown type: %s\n", type);
        }
    }
}

