/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.script;

import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.script.ScriptChat;
import net.minecraft.script.ScriptContinuation;
import net.minecraft.script.ScriptEffect;
import net.minecraft.script.ScriptEntityPlayer;
import net.minecraft.script.ScriptSound;
import net.minecraft.script.ScriptTime;
import net.minecraft.script.ScriptUI;
import net.minecraft.script.ScriptWeather;
import net.minecraft.script.ScriptWorld;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Script {
    public Scriptable globalScope;
    Scriptable curScope;
    Scriptable runScope;
    Context cx;
    ScriptTime time;
    ScriptWorld world;
    ScriptEntityPlayer player;
    ScriptChat chat;
    ScriptWeather weather;
    ScriptEffect effect;
    ScriptSound sound;
    ScriptUI ui;
    LinkedList<ScriptContinuation> sleepingScripts = new LinkedList();
    LinkedList<ScriptContinuation> removeMe = new LinkedList();
    static boolean shutterSet = false;

    public Script(fd w) {
        this.cx = ContextFactory.getGlobal().enterContext();
        this.cx.setOptimizationLevel(-1);
        if (!shutterSet) {
            this.cx.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String className) {
                    return className.startsWith("Script") || className.startsWith("net.minecraft.script") || className.equals("java.lang.Object") || className.equals("java.lang.String");
                }
            });
            shutterSet = true;
        }
        this.globalScope = this.cx.initStandardObjects();
        this.runScope = this.cx.newObject(this.globalScope);
        this.runScope.setParentScope(this.globalScope);
        this.time = new ScriptTime(w);
        this.world = new ScriptWorld(w);
        this.chat = new ScriptChat();
        this.weather = new ScriptWeather(w);
        this.effect = new ScriptEffect(w, Minecraft.minecraftInstance.g);
        this.sound = new ScriptSound(Minecraft.minecraftInstance.B);
        this.ui = new ScriptUI();
        Object wrappedOut = Context.javaToJS((Object)this.time, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"time", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)this.world, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"world", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)this.chat, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"chat", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)this.weather, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"weather", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)this.effect, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"effect", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)this.sound, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"sound", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)this.ui, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"ui", (Object)wrappedOut);
        wrappedOut = Context.javaToJS((Object)Minecraft.minecraftInstance.v.scriptUI, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"screen", (Object)wrappedOut);
        wrappedOut = Context.javaToJS(null, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"hitEntity", (Object)wrappedOut);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"hitBlock", (Object)wrappedOut);
        this.runString("if(typeof(ScriptItem) == \"undefined\")\n{Item = net.minecraft.script.ScriptItem}\nelse\n{Item = ScriptItem}");
        this.runString("UILabel = net.minecraft.script.ScriptUILabel");
        this.runString("UISprite = net.minecraft.script.ScriptUISprite");
        this.runString("UIRect = net.minecraft.script.ScriptUIRect");
        this.runString("UIContainer = net.minecraft.script.ScriptUIContainer");
    }

    public void addObject(String name, Object o) {
        Object wrappedOut = Context.javaToJS((Object)o, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)name, (Object)wrappedOut);
    }

    protected void finalize() {
        Script script = this;
        script.cx.exit();
    }

    public void initPlayer() {
        this.player = new ScriptEntityPlayer(Minecraft.minecraftInstance.h);
        Object wrappedOut = Context.javaToJS((Object)this.player, (Scriptable)this.globalScope);
        ScriptableObject.putProperty((Scriptable)this.globalScope, (String)"player", (Object)wrappedOut);
    }

    public String runString(String script) {
        Object result;
        org.mozilla.javascript.Script s = this.compileString(script, "<cmd>");
        if (s != null && (result = this.runScript(s, this.runScope)) != null) {
            return Context.toString((Object)result);
        }
        return null;
    }

    public org.mozilla.javascript.Script compileString(String script, String sourceName) {
        try {
            return this.cx.compileString(script, sourceName, 1, null);
        }
        catch (Exception e) {
            Minecraft.minecraftInstance.v.a("Javascript Error: " + e.getMessage());
            return null;
        }
    }

    public Scriptable getNewScope() {
        Scriptable scope = this.cx.newObject(this.globalScope);
        scope.setParentScope(this.globalScope);
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runScript(org.mozilla.javascript.Script script, Scriptable scope) {
        try {
            this.curScope = scope;
            Object object = this.cx.executeScriptWithContinuations(script, scope);
            return object;
        }
        catch (ContinuationPending e) {
        }
        catch (Exception e) {
            Minecraft.minecraftInstance.v.a("Javascript Error: " + e.getMessage());
        }
        finally {
            this.curScope = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void wakeupScripts(long tick) {
        for (ScriptContinuation c2 : this.sleepingScripts) {
            if (c2.wakeUp > tick) continue;
            this.removeMe.add(c2);
        }
        Iterator i$ = this.removeMe.iterator();
        while (true) {
            ScriptContinuation c2;
            if (!i$.hasNext()) {
                this.removeMe.clear();
                return;
            }
            c2 = (ScriptContinuation)i$.next();
            this.sleepingScripts.remove(c2);
            try {
                this.curScope = c2.scope;
                this.cx.resumeContinuation(c2.contituation, c2.scope, null);
                continue;
            }
            catch (ContinuationPending e) {
                continue;
            }
            catch (Exception e) {
                Minecraft.minecraftInstance.v.a("Javascript Error: " + e.getMessage());
                continue;
            }
            finally {
                this.curScope = null;
                continue;
            }
            break;
        }
    }

    public void sleep(float t2) {
        int ticks = (int)(20.0f * t2);
        ContinuationPending cp = this.cx.captureContinuation();
        this.sleepingScripts.add(new ScriptContinuation(cp.getContinuation(), this.time.getTickCount() + (long)ticks, this.curScope));
        throw cp;
    }
}

