/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.script;

import net.minecraft.client.Minecraft;
import net.minecraft.script.ScriptEntity;

public class ScriptEffect {
    fd worldObj;
    n renderGlobal;

    ScriptEffect(fd w, n rg) {
        this.worldObj = w;
        this.renderGlobal = rg;
    }

    public ScriptEntity spawnParticle(String particleType, double x2, double y, double z, double arg1, double arg2, double arg3) {
        return ScriptEntity.getEntityClass((sn)this.renderGlobal.spawnParticleR(particleType, x2, y, z, arg1, arg2, arg3));
    }

    public boolean replaceTexture(String textureToReplace, String replacement) {
        return BlockEffect.replaceTexture(this.worldObj, textureToReplace, replacement);
    }

    public String getReplaceTexture(String textureToReplace) {
        String replacement = this.worldObj.x.replacementTextures.get(textureToReplace);
        if (replacement == null) {
            return textureToReplace;
        }
        return replacement;
    }

    public void revertTextures() {
        BlockEffect.revertTextures(this.worldObj);
    }

    public String getOverlay() {
        return this.worldObj.x.overlay;
    }

    public void setOverlay(String overlay) {
        this.worldObj.x.overlay = overlay;
    }

    public void clearOverlay() {
        this.worldObj.x.overlay = "";
    }

    public void setFogColor(float r, float g2, float b) {
        this.worldObj.x.fogR = r;
        this.worldObj.x.fogG = g2;
        this.worldObj.x.fogB = b;
        this.worldObj.x.overrideFogColor = true;
    }

    public void revertFogColor() {
        this.worldObj.x.overrideFogColor = false;
    }

    public void setFogDensity(float start, float end) {
        this.worldObj.x.fogStart = start;
        this.worldObj.x.fogEnd = end;
        this.worldObj.x.overrideFogDensity = true;
    }

    public void revertFogDensity() {
        this.worldObj.x.overrideFogDensity = false;
    }

    public float getLightRampValue(int i2) {
        return this.worldObj.x.brightness[i2];
    }

    public void setLightRampValue(int i2, float f) {
        this.worldObj.x.brightness[i2] = f;
        this.worldObj.loadBrightness();
        Minecraft.minecraftInstance.g.updateAllTheRenderers();
    }

    public void resetLightRampValues() {
        float f = 0.05f;
        for (int i2 = 0; i2 < 16; ++i2) {
            float f1 = 1.0f - (float)i2 / 15.0f;
            this.worldObj.x.brightness[i2] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        this.worldObj.loadBrightness();
        Minecraft.minecraftInstance.g.updateAllTheRenderers();
    }
}

