/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.script;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.script.ScriptEntityCreature;
import net.minecraft.script.ScriptEntityFlying;
import net.minecraft.script.ScriptEntityLiving;
import net.minecraft.script.ScriptEntityLivingScript;
import net.minecraft.script.ScriptEntityMob;
import net.minecraft.script.ScriptEntityNPC;
import net.minecraft.script.ScriptEntityPlayer;
import net.minecraft.script.ScriptEntitySlime;
import net.minecraft.script.ScriptEntityWolf;
import net.minecraft.script.ScriptItem;
import net.minecraft.script.ScriptVec3;
import net.minecraft.script.ScriptVecRot;

public class ScriptEntity {
    protected sn entity;

    ScriptEntity(sn e) {
        this.entity = e;
    }

    public static ScriptEntity getEntityClass(sn e) {
        if (e == null) {
            return null;
        }
        if (e instanceof gs) {
            return new ScriptEntityPlayer((gs)e);
        }
        if (e instanceof gz) {
            return new ScriptEntityMob((gz)e);
        }
        if (e instanceof gi) {
            return new ScriptEntityWolf((gi)((Object)e));
        }
        if (e instanceof ii) {
            return new ScriptEntityCreature((ii)e);
        }
        if (e instanceof wq) {
            return new ScriptEntityFlying((wq)e);
        }
        if (e instanceof EntityNPC) {
            return new ScriptEntityNPC((EntityNPC)e);
        }
        if (e instanceof EntityLivingScript) {
            return new ScriptEntityLivingScript((EntityLivingScript)e);
        }
        if (e instanceof uw) {
            return new ScriptEntitySlime((uw)e);
        }
        if (e instanceof ls) {
            return new ScriptEntityLiving((ls)e);
        }
        return new ScriptEntity(e);
    }

    public ScriptVec3 getPosition() {
        return new ScriptVec3(this.entity.aM, this.entity.aN, this.entity.aO);
    }

    public void setPosition(double x2, double y, double z) {
        this.entity.e(x2, y, z);
    }

    public ScriptVecRot getRotation() {
        return new ScriptVecRot(this.entity.aS, this.entity.aT);
    }

    public void setRotation(float yaw, float pitch) {
        this.entity.c(yaw, pitch);
    }

    public ScriptVec3 getVelocity() {
        return new ScriptVec3(this.entity.aP, this.entity.aQ, this.entity.aR);
    }

    public void setVelocity(double x2, double y, double z) {
        this.entity.a(x2, y, z);
    }

    public void addVelocity(double x2, double y, double z) {
        this.entity.d(x2, y, z);
    }

    public void setDead() {
        this.entity.K();
    }

    public void mountEntity(ScriptEntity e) {
        if (e != null) {
            this.entity.i(e.entity);
        } else {
            this.entity.i(null);
        }
    }

    public ScriptEntity getMountedEntity() {
        return ScriptEntity.getEntityClass(this.entity.aH);
    }

    public boolean isBurning() {
        return this.entity.ak();
    }

    public boolean isAlive() {
        return this.entity.W();
    }

    public boolean isRiding() {
        return this.entity.al();
    }

    public boolean isSneaking() {
        return this.entity.t();
    }

    public ScriptEntity[] getEntitiesWithinRange(double dist) {
        eq bb2 = eq.b((double)(this.entity.aM - dist), (double)(this.entity.aN - dist), (double)(this.entity.aO - dist), (double)(this.entity.aM + dist), (double)(this.entity.aN + dist), (double)(this.entity.aO + dist));
        List entities = this.entity.aI.b(this.entity, bb2);
        ArrayList<ScriptEntity> scriptEntities = new ArrayList<ScriptEntity>();
        double sqDist = dist * dist;
        for (Object ent : entities) {
            sn e = (sn)ent;
            if (!(e.g(this.entity) < sqDist)) continue;
            scriptEntities.add(ScriptEntity.getEntityClass(e));
        }
        int i2 = 0;
        ScriptEntity[] returnList = new ScriptEntity[scriptEntities.size()];
        for (ScriptEntity e : scriptEntities) {
            returnList[i2++] = e;
        }
        return returnList;
    }

    public ScriptEntity dropItem(ScriptItem item) {
        return ScriptEntity.getEntityClass(this.entity.a(item.item, 0.0f));
    }

    public boolean isInsideOfWater() {
        return this.entity.a(ln.g);
    }

    public boolean isInsideOfLava() {
        return this.entity.a(ln.h);
    }

    public boolean getImmuneToFire() {
        return this.entity.bC;
    }

    public void setImmuneToFire(boolean i2) {
        this.entity.bC = i2;
    }

    public int getFireLevel() {
        return this.entity.bv;
    }

    public void setFireLevel(int f) {
        this.entity.bv = f;
    }

    public int getFireResistance() {
        return this.entity.bu;
    }

    public void setFireResistance(int f) {
        this.entity.bu = f;
    }

    public int getAir() {
        return this.entity.bz;
    }

    public void setAir(int i2) {
        this.entity.bz = i2;
    }

    public int getMaxAir() {
        return this.entity.bw;
    }

    public void setMaxAir(int i2) {
        this.entity.bw = i2;
    }

    public int getStunned() {
        return this.entity.stunned;
    }

    public void setStunned(int i2) {
        this.entity.stunned = i2;
    }

    public boolean attackEntityFrom(ScriptEntity e, int i2) {
        return this.entity.a(e.entity, i2);
    }

    public String getClassType() {
        if (this.entity instanceof gs) {
            return "Player";
        }
        return jc.getEntityStringClimbing(this.entity);
    }

    public boolean getCollidesWithClipBlocks() {
        return this.entity.collidesWithClipBlocks;
    }

    public void setCollidesWithClipBlocks(boolean b) {
        this.entity.collidesWithClipBlocks = b;
    }

    public float getHeight() {
        return this.entity.bh;
    }

    public void setHeight(float h2) {
        this.entity.bh = h2;
        this.entity.e(this.entity.aM, this.entity.aN, this.entity.aO);
    }

    public float getWidth() {
        return this.entity.bg;
    }

    public void setWidth(float w) {
        this.entity.bg = w;
        this.entity.e(this.entity.aM, this.entity.aN, this.entity.aO);
    }
}

