/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.script;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.script.UIElement;
import org.lwjgl.opengl.GL11;

public class ScriptUIContainer
extends UIElement {
    public String text = "";
    public int x = 0;
    public int y = 0;
    private List<UIElement> uiElements;

    public ScriptUIContainer(int xPos, int yPos) {
        this(xPos, yPos, Minecraft.minecraftInstance.v.scriptUI);
    }

    public ScriptUIContainer(int xPos, int yPos, ScriptUIContainer p) {
        this.x = xPos;
        this.y = yPos;
        this.uiElements = new LinkedList<UIElement>();
        if (p != null) {
            p.add(this);
        }
    }

    @Override
    public void render(sj fontRenderer, ji renderEngine) {
        if (this.x != 0 || this.y != 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        }
        for (UIElement uie : this.uiElements) {
            uie.render(fontRenderer, renderEngine);
        }
        if (this.x != 0 || this.y != 0) {
            GL11.glPopMatrix();
        }
    }

    public void add(UIElement uie) {
        if (uie.parent != null) {
            uie.parent.remove(uie);
        }
        this.uiElements.add(uie);
        uie.parent = this;
    }

    public void addToBack(UIElement uie) {
        if (uie.parent != null) {
            uie.parent.remove(uie);
        }
        this.uiElements.add(0, uie);
        uie.parent = this;
    }

    public void remove(UIElement uie) {
        this.uiElements.remove(uie);
        uie.parent = null;
    }

    public void clear() {
        this.uiElements.clear();
    }
}

