/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.script;

import net.minecraft.client.Minecraft;
import net.minecraft.script.ScriptUIContainer;
import net.minecraft.script.UIElement;

public class ScriptUILabel
extends UIElement {
    public String text = "";
    public int x = 0;
    public int y = 0;
    public boolean shadow = true;
    public boolean centered = false;
    public float red = 1.0f;
    public float green = 1.0f;
    public float blue = 1.0f;
    public float alpha = 1.0f;

    public ScriptUILabel(String label, int xPos, int yPos) {
        this(label, xPos, yPos, Minecraft.minecraftInstance.v.scriptUI);
    }

    public ScriptUILabel(String label, int xPos, int yPos, ScriptUIContainer parent) {
        this.text = label;
        this.x = xPos;
        this.y = yPos;
        if (parent != null) {
            parent.add(this);
        }
    }

    @Override
    public void render(sj fontRenderer, ji renderEngine) {
        int color = Math.max(Math.min((int)(this.alpha * 255.0f), 255), 0);
        if (color == 0) {
            return;
        }
        color = (color << 8) + Math.max(Math.min((int)(this.red * 255.0f), 255), 0);
        color = (color << 8) + Math.max(Math.min((int)(this.green * 255.0f), 255), 0);
        color = (color << 8) + Math.max(Math.min((int)(this.blue * 255.0f), 255), 0);
        int xPos = this.x;
        if (this.centered) {
            xPos -= fontRenderer.a(this.text) / 2;
        }
        if (this.shadow) {
            fontRenderer.a(this.text, xPos, this.y, color);
        } else {
            fontRenderer.b(this.text, xPos, this.y, color);
        }
    }
}

