/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IPropertyBag;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebFramePrivate;
import org.eclipse.swt.internal.webkit.IWebOpenPanelResultListener;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebUIDelegate {
    COMObject iWebUIDelegate;
    int refCount = 0;
    String lastHoveredLinkURL;
    Browser browser;
    Point size;
    Point location;
    boolean menuBar = true;
    boolean toolBar = true;
    boolean statusBar = true;
    boolean prompt = true;

    WebUIDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int canTakeFocus(int n, int n2, int n3) {
        OS.MoveMemory(n3, new int[]{1}, 4);
        return 0;
    }

    int contextMenuItemsForElement(int n, int n2, int n3, int n4) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (event.doit) {
            Menu menu = this.browser.getMenu();
            if (menu != null && !menu.isDisposed()) {
                if (event.x != point.x || event.y != point.y) {
                    menu.setLocation(event.x, event.y);
                }
                menu.setVisible(true);
            } else {
                OS.MoveMemory(n4, new int[]{n3}, C.PTR_SIZEOF);
                return 0;
            }
        }
        OS.MoveMemory(n4, new int[1], C.PTR_SIZEOF);
        return 0;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[66];
        nArray[0] = 2;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 2;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[23] = 3;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 2;
        nArray[27] = 3;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 3;
        nArray[31] = 3;
        nArray[32] = 3;
        nArray[33] = 3;
        nArray[34] = 5;
        nArray[35] = 3;
        nArray[36] = 1;
        nArray[37] = 3;
        nArray[38] = 2;
        nArray[39] = 2;
        nArray[40] = 2;
        nArray[41] = 2;
        nArray[42] = 3;
        nArray[43] = 2;
        nArray[44] = 3;
        nArray[45] = 1;
        nArray[46] = 1;
        nArray[49] = 1;
        nArray[50] = 1;
        nArray[51] = 2;
        nArray[52] = 2;
        nArray[53] = 2;
        nArray[54] = 2;
        nArray[55] = 3;
        nArray[56] = 5;
        nArray[57] = 2;
        nArray[58] = 2;
        nArray[59] = 3;
        nArray[60] = 1;
        nArray[61] = 2;
        nArray[62] = 2;
        nArray[63] = 4;
        nArray[64] = 10;
        nArray[65] = 3;
        this.iWebUIDelegate = new COMObject(nArray){

            public int method0(int[] nArray) {
                return WebUIDelegate.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return WebUIDelegate.this.AddRef();
            }

            public int method2(int[] nArray) {
                return WebUIDelegate.this.Release();
            }

            public int method3(int[] nArray) {
                return WebUIDelegate.this.createWebViewWithRequest(nArray[0], nArray[1], nArray[2]);
            }

            public int method4(int[] nArray) {
                return WebUIDelegate.this.webViewShow(nArray[0]);
            }

            public int method5(int[] nArray) {
                return WebUIDelegate.this.webViewClose(nArray[0]);
            }

            public int method6(int[] nArray) {
                return -2147467263;
            }

            public int method7(int[] nArray) {
                return -2147467263;
            }

            public int method8(int[] nArray) {
                return -2147467263;
            }

            public int method9(int[] nArray) {
                return -2147467263;
            }

            public int method10(int[] nArray) {
                return WebUIDelegate.this.setStatusText(nArray[0], nArray[1]);
            }

            public int method11(int[] nArray) {
                return -2147467263;
            }

            public int method12(int[] nArray) {
                return -2147467263;
            }

            public int method13(int[] nArray) {
                return WebUIDelegate.this.setToolbarsVisible(nArray[0], nArray[1]);
            }

            public int method14(int[] nArray) {
                return -2147467263;
            }

            public int method15(int[] nArray) {
                return WebUIDelegate.this.setStatusBarVisible(nArray[0], nArray[1]);
            }

            public int method16(int[] nArray) {
                return -2147467263;
            }

            public int method17(int[] nArray) {
                return -2147467263;
            }

            public int method18(int[] nArray) {
                return WebUIDelegate.this.setFrame(nArray[0], nArray[1]);
            }

            public int method19(int[] nArray) {
                return -2147467263;
            }

            public int method20(int[] nArray) {
                return -2147467263;
            }

            public int method21(int[] nArray) {
                return -2147467263;
            }

            public int method22(int[] nArray) {
                return WebUIDelegate.this.runJavaScriptAlertPanelWithMessage(nArray[0], nArray[1]);
            }

            public int method23(int[] nArray) {
                return WebUIDelegate.this.runJavaScriptConfirmPanelWithMessage(nArray[0], nArray[1], nArray[2]);
            }

            public int method24(int[] nArray) {
                return WebUIDelegate.this.runJavaScriptTextInputPanelWithPrompt(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method25(int[] nArray) {
                return WebUIDelegate.this.runBeforeUnloadConfirmPanelWithMessage(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method26(int[] nArray) {
                return WebUIDelegate.this.runOpenPanelForFileButtonWithResultListener(nArray[0], nArray[1]);
            }

            public int method27(int[] nArray) {
                return WebUIDelegate.this.mouseDidMoveOverElement(nArray[0], nArray[1], nArray[2]);
            }

            public int method28(int[] nArray) {
                return WebUIDelegate.this.contextMenuItemsForElement(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method29(int[] nArray) {
                return -2147467263;
            }

            public int method30(int[] nArray) {
                return -2147467263;
            }

            public int method31(int[] nArray) {
                return -2147467263;
            }

            public int method32(int[] nArray) {
                return -2147467263;
            }

            public int method33(int[] nArray) {
                return -2147467263;
            }

            public int method34(int[] nArray) {
                return -2147467263;
            }

            public int method35(int[] nArray) {
                return -2147467263;
            }

            public int method36(int[] nArray) {
                return -2147467263;
            }

            public int method37(int[] nArray) {
                return -2147467263;
            }

            public int method38(int[] nArray) {
                return -2147467263;
            }

            public int method39(int[] nArray) {
                return -2147467263;
            }

            public int method40(int[] nArray) {
                return -2147467263;
            }

            public int method41(int[] nArray) {
                return -2147467263;
            }

            public int method42(int[] nArray) {
                return WebUIDelegate.this.canTakeFocus(nArray[0], nArray[1], nArray[2]);
            }

            public int method43(int[] nArray) {
                return WebUIDelegate.this.takeFocus(nArray[0], nArray[1]);
            }

            public int method44(int[] nArray) {
                return -2147467263;
            }

            public int method45(int[] nArray) {
                return 0;
            }

            public int method46(int[] nArray) {
                return -2147467263;
            }

            public int method47(int[] nArray) {
                return -2147467263;
            }

            public int method48(int[] nArray) {
                return -2147467263;
            }

            public int method49(int[] nArray) {
                return -2147467263;
            }

            public int method50(int[] nArray) {
                return -2147467263;
            }

            public int method51(int[] nArray) {
                return WebUIDelegate.this.printFrame(nArray[0], nArray[1]);
            }

            public int method52(int[] nArray) {
                return -2147467263;
            }

            public int method53(int[] nArray) {
                return -2147467263;
            }

            public int method54(int[] nArray) {
                return -2147467263;
            }

            public int method55(int[] nArray) {
                return -2147467263;
            }

            public int method56(int[] nArray) {
                return -2147467263;
            }

            public int method57(int[] nArray) {
                return -2147467263;
            }

            public int method58(int[] nArray) {
                return -2147467263;
            }

            public int method59(int[] nArray) {
                return -2147467263;
            }

            public int method60(int[] nArray) {
                return -2147467263;
            }

            public int method61(int[] nArray) {
                return -2147467263;
            }

            public int method62(int[] nArray) {
                return WebUIDelegate.this.setMenuBarVisible(nArray[0], nArray[1]);
            }

            public int method63(int[] nArray) {
                return -2147467263;
            }

            public int method64(int[] nArray) {
                return -2147467263;
            }

            public int method65(int[] nArray) {
                return -2147467263;
            }
        };
    }

    int createWebViewWithRequest(int n, int n2, int n3) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        OpenWindowListener[] openWindowListenerArray = this.browser.webBrowser.openWindowListeners;
        int n4 = 0;
        while (n4 < openWindowListenerArray.length) {
            openWindowListenerArray[n4].open(windowEvent);
            ++n4;
        }
        IWebView iWebView = null;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            iWebView = ((WebKit)((Browser)widget).webBrowser).webView;
            OS.MoveMemory(n3, new int[]{iWebView.getAddress()}, OS.PTR_SIZEOF);
            if (n2 != 0) {
                IWebURLRequest iWebURLRequest = new IWebURLRequest(n2);
                int[] nArray = new int[1];
                int n5 = iWebURLRequest.URL(nArray);
                if (n5 != 0 || nArray[0] == 0) {
                    return 0;
                }
                String string = WebKit.extractBSTR(nArray[0]);
                COM.SysFreeString(nArray[0]);
                if (string.length() != 0) {
                    nArray[0] = 0;
                    n5 = iWebView.mainFrame(nArray);
                    if (n5 != 0 || nArray[0] == 0) {
                        return 0;
                    }
                    IWebFrame iWebFrame = new IWebFrame(nArray[0]);
                    iWebFrame.loadRequest(iWebURLRequest.getAddress());
                    iWebFrame.Release();
                }
            }
            return 0;
        }
        return -2147467263;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebUIDelegate != null) {
            this.iWebUIDelegate.dispose();
            this.iWebUIDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebUIDelegate.getAddress();
    }

    int mouseDidMoveOverElement(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == 0) {
            return 0;
        }
        IPropertyBag iPropertyBag = new IPropertyBag(n2);
        int n6 = WebKit.createBSTR("WebElementLinkURLKey");
        int n7 = iPropertyBag.Read(n6, n5 = OS.HeapAlloc(n4 = OS.GetProcessHeap(), 8, VARIANT.sizeof), null);
        if (n7 != 0 || n5 == 0) {
            return 0;
        }
        String string = null;
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n5, VARIANT.sizeof);
        if (vARIANT.vt == 8) {
            string = WebKit.extractBSTR(vARIANT.lVal);
        }
        OS.HeapFree(n4, 0, n5);
        StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
        if (string == null || string.length() == 0) {
            if (this.lastHoveredLinkURL == null) {
                return 0;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            int n8 = 0;
            while (n8 < statusTextListenerArray.length) {
                statusTextListenerArray[n8].changed(statusTextEvent);
                ++n8;
            }
            return 0;
        }
        if (string.equals(this.lastHoveredLinkURL)) {
            return 0;
        }
        this.lastHoveredLinkURL = string;
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        int n9 = 0;
        while (n9 < statusTextListenerArray.length) {
            statusTextListenerArray[n9].changed(statusTextEvent);
            ++n9;
        }
        return 0;
    }

    int printFrame(int n, int n2) {
        int n3;
        Object object;
        IWebFrame iWebFrame = new IWebFrame(n2);
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        pRINTDLG.Flags = 256;
        OS.PrintDlg(pRINTDLG);
        int n4 = pRINTDLG.hDC;
        int[] nArray = new int[1];
        int n5 = iWebFrame.QueryInterface(WebKit_win32.IID_IWebFramePrivate, nArray);
        if (n5 != 0 || nArray[0] == 0) {
            return 0;
        }
        IWebFramePrivate iWebFramePrivate = new IWebFramePrivate(nArray[0]);
        iWebFramePrivate.setInPrintingMode(1, n4);
        int[] nArray2 = new int[1];
        n5 = iWebFramePrivate.getPrintedPageCount(n4, nArray2);
        if (n5 != 0 || nArray2[0] == 0) {
            iWebFramePrivate.Release();
            return 0;
        }
        int n6 = nArray2[0];
        String string = null;
        nArray[0] = 0;
        n5 = iWebFrame.dataSource(nArray);
        if (n5 == 0 && nArray[0] != 0) {
            object = new IWebDataSource(nArray[0]);
            nArray[0] = 0;
            n5 = ((IWebDataSource)object).pageTitle(nArray);
            ((IUnknown)object).Release();
            if (n5 == 0 && nArray[0] != 0) {
                string = WebKit.extractBSTR(nArray[0]);
                COM.SysFreeString(nArray[0]);
            }
        }
        object = new DOCINFO();
        ((DOCINFO)object).cbSize = DOCINFO.sizeof;
        int n7 = OS.GetProcessHeap();
        int n8 = 0;
        if (string != null && string.length() != 0) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            n3 = tCHAR.length() * TCHAR.sizeof;
            n8 = OS.HeapAlloc(n7, 8, n3);
            OS.MoveMemory(n8, tCHAR, n3);
            ((DOCINFO)object).lpszDocName = n8;
        }
        int n9 = OS.StartDoc(n4, (DOCINFO)object);
        if (n8 != 0) {
            OS.HeapFree(n7, 0, n8);
        }
        if (n9 >= 0) {
            n3 = 0;
            while (n3 < n6) {
                OS.StartPage(n4);
                iWebFramePrivate.spoolPages(n4, n3, n3, null);
                OS.EndPage(n4);
                ++n3;
            }
            iWebFramePrivate.setInPrintingMode(0, n4);
            OS.EndDoc(n4);
        }
        iWebFramePrivate.Release();
        return 0;
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.iWebUIDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebUIDelegate)) {
            COM.MoveMemory(n2, new int[]{this.iWebUIDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int runBeforeUnloadConfirmPanelWithMessage(int n, int n2, int n3, int n4) {
        if (!this.prompt) {
            return 0;
        }
        Shell shell = this.browser.getShell();
        String string = WebKit.extractBSTR(n2);
        StringBuffer stringBuffer = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        stringBuffer.append("\n\n");
        stringBuffer.append(string);
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(shell, 292);
        messageBox.setMessage(stringBuffer.toString());
        int[] nArray = new int[]{messageBox.open() == 32 ? 1 : 0};
        OS.MoveMemory(n4, nArray, 4);
        return 0;
    }

    int runJavaScriptAlertPanelWithMessage(int n, int n2) {
        String string = WebKit.extractBSTR(n2);
        this.showAlertMessage("Javascript", string);
        return 0;
    }

    int runJavaScriptConfirmPanelWithMessage(int n, int n2, int n3) {
        String string = WebKit.extractBSTR(n2);
        int[] nArray = new int[]{this.showConfirmPanel("Javascript", string) == 32 ? 1 : 0};
        OS.MoveMemory(n3, nArray, 4);
        return 0;
    }

    int runJavaScriptTextInputPanelWithPrompt(int n, int n2, int n3, int n4) {
        String string = WebKit.extractBSTR(n2);
        String string2 = WebKit.extractBSTR(n3);
        String string3 = this.showTextPrompter("Javascript", string, string2);
        int[] nArray = new int[1];
        if (string3 != null) {
            nArray[0] = WebKit.createBSTR(string3);
        }
        OS.MoveMemory(n4, nArray, C.PTR_SIZEOF);
        return 0;
    }

    int runOpenPanelForFileButtonWithResultListener(int n, int n2) {
        Shell shell = this.browser.getShell();
        FileDialog fileDialog = new FileDialog(shell, 0);
        String string = fileDialog.open();
        IWebOpenPanelResultListener iWebOpenPanelResultListener = new IWebOpenPanelResultListener(n2);
        if (string == null) {
            iWebOpenPanelResultListener.cancel();
        } else {
            iWebOpenPanelResultListener.chooseFilename(WebKit.createBSTR(string));
        }
        return 0;
    }

    int setFrame(int n, int n2) {
        RECT rECT = new RECT();
        COM.MoveMemory(rECT, n2, RECT.sizeof);
        this.location = this.browser.getDisplay().map(this.browser, null, rECT.left, rECT.top);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        if (n4 < 0 || n3 < 0 || n3 == 0 && n4 == 0) {
            return 0;
        }
        this.size = new Point(n3, n4);
        return 0;
    }

    int setMenuBarVisible(int n, int n2) {
        this.menuBar = n2 == 1;
        return 0;
    }

    int setStatusBarVisible(int n, int n2) {
        this.statusBar = n2 == 1;
        return 0;
    }

    int setStatusText(int n, int n2) {
        String string = WebKit.extractBSTR(n2);
        if (string.length() == 0) {
            return 0;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
        int n3 = 0;
        while (n3 < statusTextListenerArray.length) {
            statusTextListenerArray[n3].changed(statusTextEvent);
            ++n3;
        }
        return 0;
    }

    int setToolbarsVisible(int n, int n2) {
        this.toolBar = n2 == 1;
        return 0;
    }

    void showAlertMessage(String string, String string2) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        shell2.setLayout(gridLayout);
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        Image image = shell2.getDisplay().getSystemImage(8);
        label.setImage(image);
        label = new Label(shell2, 64);
        label.setText(string2);
        Monitor monitor = shell.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = Math.min(n2, n);
        label.setLayoutData(gridData);
        Button button = new Button(shell2, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        n2 = button.computeSize((int)-1, (int)-1).x;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 0x1000000;
        gridData2.verticalAlignment = 0x1000000;
        gridData2.horizontalSpan = 2;
        gridData2.widthHint = Math.max(n2, 75);
        button.setLayoutData(gridData2);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n3 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n4 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n3, n4);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    int showConfirmPanel(String string, String string2) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        shell2.setLayout(gridLayout);
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        Image image = shell2.getDisplay().getSystemImage(4);
        label.setImage(image);
        label.setLayoutData(new GridData());
        label = new Label(shell2, 64);
        label.setText(string2);
        Monitor monitor = shell.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = Math.min(n2, n);
        label.setLayoutData(gridData);
        Composite composite = new Composite(shell2, 0);
        gridData = new GridData(0x1000000, 0x1000000, true, true, 2, 1);
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, true));
        Button button = new Button(composite, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 0x1000000;
        gridData2.verticalAlignment = 0x1000000;
        button.setLayoutData(gridData2);
        Button button2 = new Button(composite, 8);
        button2.setText(SWT.getMessage("SWT_Cancel"));
        button2.setLayoutData(gridData2);
        n2 = button2.computeSize((int)-1, (int)-1).x;
        gridData2.widthHint = Math.max(n2, 75);
        final int[] nArray = new int[1];
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                nArray[0] = 32;
                shell2.dispose();
            }
        });
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                nArray[0] = 256;
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n3 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n4 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n3, n4);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return nArray[0];
    }

    String showTextPrompter(String string, String string2, String string3) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(string);
        Label label = new Label(shell2, 0);
        label.setLayoutData(new GridData(768));
        label.setText(string2);
        final Text text = new Text(shell2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        text.setLayoutData(gridData);
        text.setText(string3);
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, true));
        composite.setLayoutData(new GridData(64));
        Button button = new Button(composite, 8);
        button.setText(SWT.getMessage("SWT_OK"));
        button.setLayoutData(new GridData(768));
        final String[] stringArray = new String[1];
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                stringArray[0] = text.getText();
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(SWT.getMessage("SWT_Cancel"));
        button2.setLayoutData(new GridData(768));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n2 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n, n2);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return stringArray[0];
    }

    int takeFocus(int n, int n2) {
        int n3 = n2 == 0 ? 8 : 16;
        ((WebKit)this.browser.webBrowser).traverseOut = true;
        this.browser.traverse(n3);
        return 0;
    }

    int webViewClose(int n) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        CloseWindowListener[] closeWindowListenerArray = this.browser.webBrowser.closeWindowListeners;
        int n2 = 0;
        while (n2 < closeWindowListenerArray.length) {
            closeWindowListenerArray[n2].close(windowEvent);
            ++n2;
        }
        this.browser.dispose();
        return 0;
    }

    int webViewFrame(int n, int n2) {
        RECT rECT = new RECT();
        OS.MoveMemory(n2, rECT, RECT.sizeof);
        return 0;
    }

    int webViewShow(int n) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = this.menuBar;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        VisibilityWindowListener[] visibilityWindowListenerArray = this.browser.webBrowser.visibilityWindowListeners;
        int n2 = 0;
        while (n2 < visibilityWindowListenerArray.length) {
            visibilityWindowListenerArray[n2].show(windowEvent);
            ++n2;
        }
        this.location = null;
        this.size = null;
        return 0;
    }
}

