/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROPERTYKEY;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];
    int mTaskbarList3;
    static final char[] EXE_PATH;
    static final char[] ICO_DIR;
    static final PROPERTYKEY PKEY_Title;
    static final PROPERTYKEY PKEY_AppUserModel_IsDestListSeparator;
    static final String EXE_PATH_KEY = "org.eclipse.swt.win32.taskbar.executable";
    static final String EXE_ARGS_KEY = "org.eclipse.swt.win32.taskbar.arguments";
    static final String ICON_KEY = "org.eclipse.swt.win32.taskbar.icon";
    static final String ICON_INDEX_KEY = "org.eclipse.swt.win32.taskbar.icon.index";
    static final byte[] CLSID_TaskbarList;
    static final byte[] CLSID_DestinationList;
    static final byte[] CLSID_EnumerableObjectCollection;
    static final byte[] CLSID_ShellLink;
    static final byte[] CLSID_FileOperation;
    static final byte[] IID_ITaskbarList3;
    static final byte[] IID_ICustomDestinationList;
    static final byte[] IID_IObjectArray;
    static final byte[] IID_IObjectCollection;
    static final byte[] IID_IShellLinkW;
    static final byte[] IID_IPropertyStore;
    static final byte[] IID_IShellItem;
    static final byte[] IID_IFileOperation;
    static final byte[] FOLDERID_LocalAppData;

    static {
        char[] cArray = new char[8];
        cArray[0] = 105;
        cArray[1] = 99;
        cArray[2] = 111;
        cArray[3] = 95;
        cArray[4] = 100;
        cArray[5] = 105;
        cArray[6] = 114;
        ICO_DIR = cArray;
        PKEY_Title = new PROPERTYKEY();
        PKEY_AppUserModel_IsDestListSeparator = new PROPERTYKEY();
        CLSID_TaskbarList = new byte[16];
        CLSID_DestinationList = new byte[16];
        CLSID_EnumerableObjectCollection = new byte[16];
        CLSID_ShellLink = new byte[16];
        CLSID_FileOperation = new byte[16];
        IID_ITaskbarList3 = new byte[16];
        IID_ICustomDestinationList = new byte[16];
        IID_IObjectArray = new byte[16];
        IID_IObjectCollection = new byte[16];
        IID_IShellLinkW = new byte[16];
        IID_IPropertyStore = new byte[16];
        IID_IShellItem = new byte[16];
        IID_IFileOperation = new byte[16];
        FOLDERID_LocalAppData = new byte[16];
        OS.IIDFromString("{56FDF344-FD6D-11d0-958A-006097C9A090}\u0000".toCharArray(), CLSID_TaskbarList);
        OS.IIDFromString("{77f10cf0-3db5-4966-b520-b7c54fd35ed6}\u0000".toCharArray(), CLSID_DestinationList);
        OS.IIDFromString("{2d3468c1-36a7-43b6-ac24-d3f02fd9607a}\u0000".toCharArray(), CLSID_EnumerableObjectCollection);
        OS.IIDFromString("{00021401-0000-0000-C000-000000000046}\u0000".toCharArray(), CLSID_ShellLink);
        OS.IIDFromString("{3ad05575-8857-4850-9277-11b85bdb8e09}\u0000".toCharArray(), CLSID_FileOperation);
        OS.IIDFromString("{EA1AFB91-9E28-4B86-90E9-9E9F8A5EEFAF}\u0000".toCharArray(), IID_ITaskbarList3);
        OS.IIDFromString("{6332debf-87b5-4670-90c0-5e57b408a49e}\u0000".toCharArray(), IID_ICustomDestinationList);
        OS.IIDFromString("{92CA9DCD-5622-4bba-A805-5E9F541BD8C9}\u0000".toCharArray(), IID_IObjectArray);
        OS.IIDFromString("{5632b1a4-e38a-400a-928a-d4cd63230295}\u0000".toCharArray(), IID_IObjectCollection);
        OS.IIDFromString("{000214F9-0000-0000-C000-000000000046}\u0000".toCharArray(), IID_IShellLinkW);
        OS.IIDFromString("{886d8eeb-8cf2-4446-8d02-cdba1dbdcf99}\u0000".toCharArray(), IID_IPropertyStore);
        OS.IIDFromString("{43826d1e-e718-42ee-bc55-a1e261c37bfe}\u0000".toCharArray(), IID_IShellItem);
        OS.IIDFromString("{947aab5f-0a5c-4c13-b4d6-4bf7836fc9f8}\u0000".toCharArray(), IID_IFileOperation);
        OS.IIDFromString("{F1B32785-6FBA-4FCF-9D55-7B8E7F157091}\u0000".toCharArray(), FOLDERID_LocalAppData);
        OS.PSPropertyKeyFromString("{F29F85E0-4FF9-1068-AB91-08002B27B3D9} 2\u0000".toCharArray(), PKEY_Title);
        OS.PSPropertyKeyFromString("{9F4C2855-9F79-4B39-A8D0-E1D42DE1D5F3}, 6\u0000".toCharArray(), PKEY_AppUserModel_IsDestListSeparator);
        TCHAR tCHAR = new TCHAR(0, 260);
        while (OS.GetModuleFileName(0, tCHAR, tCHAR.length()) == tCHAR.length()) {
            tCHAR = new TCHAR(0, tCHAR.length() + 260);
        }
        int n = tCHAR.strlen();
        EXE_PATH = new char[n + 1];
        System.arraycopy(tCHAR.chars, 0, EXE_PATH, 0, n);
    }

    TaskBar(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.createHandle();
        this.reskinWidget();
    }

    void createHandle() {
        int[] nArray = new int[1];
        int n = OS.CoCreateInstance(CLSID_TaskbarList, 0, 1, IID_ITaskbarList3, nArray);
        if (n != 0) {
            this.error(2);
        }
        this.mTaskbarList3 = nArray[0];
    }

    void createItem(TaskItem taskItem, int n) {
        if (n == -1) {
            n = this.itemCount;
        }
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] taskItemArray = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, taskItemArray, 0, this.items.length);
            this.items = taskItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = taskItem;
    }

    void createItems() {
        Shell[] shellArray = this.display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            this.getItem(shellArray[n]);
            ++n;
        }
        this.getItem(null);
    }

    int createShellLink(MenuItem menuItem, String string) {
        int n;
        PROPERTYKEY pROPERTYKEY;
        int n2 = menuItem.getStyle();
        if ((n2 & 0x40) != 0) {
            return 0;
        }
        int[] nArray = new int[1];
        int n3 = OS.CoCreateInstance(CLSID_ShellLink, 0, 1, IID_IShellLinkW, nArray);
        if (n3 != 0) {
            this.error(2);
        }
        int n4 = nArray[0];
        int n5 = OS.GetProcessHeap();
        int n6 = OS.HeapAlloc(n5, 8, OS.PROPVARIANT_sizeof());
        int n7 = 0;
        if ((n2 & 2) != 0) {
            OS.MoveMemory(n6, new short[]{11}, 2);
            OS.MoveMemory(n6 + 8, new short[]{-1}, 2);
            pROPERTYKEY = PKEY_AppUserModel_IsDestListSeparator;
        } else {
            String string2 = menuItem.getText();
            int n8 = string2.length();
            char[] cArray = new char[n8 + 1];
            string2.getChars(0, n8, cArray, 0);
            n7 = OS.HeapAlloc(n5, 8, cArray.length * 2);
            OS.MoveMemory(n7, cArray, cArray.length * 2);
            OS.MoveMemory(n6, new short[]{31}, 2);
            OS.MoveMemory(n6 + 8, new int[]{n7}, OS.PTR_SIZEOF);
            pROPERTYKEY = PKEY_Title;
            String string3 = (String)menuItem.getData(EXE_PATH_KEY);
            if (string3 != null) {
                n8 = string3.length();
                cArray = new char[n8 + 1];
                string3.getChars(0, n8, cArray, 0);
            } else {
                cArray = EXE_PATH;
            }
            n3 = OS.VtblCall(20, n4, cArray);
            if (n3 != 0) {
                this.error(5);
            }
            if ((string2 = (String)menuItem.getData(EXE_ARGS_KEY)) == null) {
                string2 = "--launcher.openFile /SWTINTERNAL_ID" + menuItem.id;
            }
            n8 = string2.length();
            cArray = new char[n8 + 1];
            string2.getChars(0, n8, cArray, 0);
            n3 = OS.VtblCall(11, n4, cArray);
            if (n3 != 0) {
                this.error(5);
            }
            String string4 = (String)menuItem.getData(ICON_KEY);
            int n9 = 0;
            if (string4 != null) {
                string2 = (String)menuItem.getData(ICON_INDEX_KEY);
                if (string2 != null) {
                    n9 = Integer.parseInt(string2);
                }
            } else {
                Image image = menuItem.getImage();
                if (image != null && string != null) {
                    ImageData imageData;
                    Object object;
                    string4 = String.valueOf(string) + "\\menu" + menuItem.id + ".ico";
                    if (menuItem.hBitmap != 0) {
                        object = Image.win32_new(this.display, 0, menuItem.hBitmap);
                        imageData = ((Image)object).getImageData();
                    } else {
                        imageData = image.getImageData();
                    }
                    object = new ImageLoader();
                    ((ImageLoader)object).data = new ImageData[]{imageData};
                    ((ImageLoader)object).save(string4, 3);
                }
            }
            if (string4 != null) {
                n8 = string4.length();
                cArray = new char[n8 + 1];
                string4.getChars(0, n8, cArray, 0);
                n3 = OS.VtblCall(17, n4, cArray, n9);
                if (n3 != 0) {
                    this.error(5);
                }
            }
        }
        n3 = OS.VtblCall(0, n4, IID_IPropertyStore, nArray);
        if (n3 != 0) {
            this.error(2);
        }
        if ((n3 = OS.VtblCall(6, n = nArray[0], pROPERTYKEY, n6)) != 0) {
            this.error(5);
        }
        OS.VtblCall(7, n);
        OS.VtblCall(2, n);
        OS.HeapFree(n5, 0, n6);
        if (n7 != 0) {
            OS.HeapFree(n5, 0, n7);
        }
        return n4;
    }

    int createShellLinkArray(MenuItem[] menuItemArray, String string) {
        if (menuItemArray == null) {
            return 0;
        }
        if (menuItemArray.length == 0) {
            return 0;
        }
        int[] nArray = new int[1];
        int n = OS.CoCreateInstance(CLSID_EnumerableObjectCollection, 0, 1, IID_IObjectCollection, nArray);
        if (n != 0) {
            this.error(2);
        }
        int n2 = nArray[0];
        int n3 = 0;
        while (n3 < menuItemArray.length) {
            int n4 = this.createShellLink(menuItemArray[n3], string);
            if (n4 != 0) {
                n = OS.VtblCall(5, n2, n4);
                if (n != 0) {
                    this.error(5);
                }
                OS.VtblCall(2, n4);
            }
            ++n3;
        }
        n = OS.VtblCall(0, n2, IID_IObjectArray, nArray);
        if (n != 0) {
            this.error(2);
        }
        n3 = nArray[0];
        OS.VtblCall(2, n2);
        return n3;
    }

    void destroyItem(TaskItem taskItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == taskItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
    }

    String getDirectory(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    cArray2[n] = 95;
                    break;
                }
                default: {
                    cArray2[n] = c;
                }
            }
            ++n;
        }
        String string = null;
        int[] nArray = new int[1];
        int n2 = OS.SHCreateItemInKnownFolder(FOLDERID_LocalAppData, 0, null, IID_IShellItem, nArray);
        if (n2 == 0) {
            int n3 = nArray[0];
            n2 = OS.CoCreateInstance(CLSID_FileOperation, 0, 1, IID_IFileOperation, nArray);
            if (n2 == 0) {
                int n4;
                int n5 = nArray[0];
                n2 = OS.VtblCall(5, n5, 1556);
                if (n2 == 0 && (n4 = this.getDirectory(n3, n5, cArray2, false)) != 0) {
                    int n6 = this.getDirectory(n4, n5, ICO_DIR, true);
                    if (n6 != 0) {
                        n2 = OS.VtblCall(5, n6, -2147123200, nArray);
                        if (n2 == 0) {
                            int n7 = nArray[0];
                            int n8 = OS.wcslen(n7);
                            char[] cArray3 = new char[n8];
                            OS.MoveMemory(cArray3, n7, n8 * 2);
                            string = new String(cArray3);
                            OS.CoTaskMemFree(n7);
                        }
                        OS.VtblCall(2, n6);
                    }
                    OS.VtblCall(2, n4);
                }
                OS.VtblCall(2, n5);
            }
            OS.VtblCall(2, n3);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getDirectory(int n, int n2, char[] cArray, boolean bl) {
        int[] nArray = new int[1];
        int n3 = OS.SHCreateItemFromRelativeName(n, cArray, 0, IID_IShellItem, nArray);
        if (n3 == 0) {
            if (!bl) return nArray[0];
            n3 = OS.VtblCall(18, n2, nArray[0], 0);
            OS.VtblCall(2, nArray[0]);
            if (n3 != 0 || (n3 = OS.VtblCall(20, n2, n, 16, cArray, null, 0)) != 0 || (n3 = OS.VtblCall(21, n2)) != 0 || (n3 = OS.SHCreateItemFromRelativeName(n, cArray, 0, IID_IShellItem, nArray)) != 0) return 0;
            return nArray[0];
        }
        n3 = OS.VtblCall(20, n2, n, 16, cArray, null, 0);
        if (n3 != 0 || (n3 = OS.VtblCall(21, n2)) != 0 || (n3 = OS.SHCreateItemFromRelativeName(n, cArray, 0, IID_IShellItem, nArray)) != 0) return 0;
        return nArray[0];
    }

    public TaskItem getItem(int n) {
        this.checkWidget();
        this.createItems();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] != null && this.items[n].shell == shell) {
                return this.items[n];
            }
            ++n;
        }
        TaskItem taskItem = new TaskItem(this, 0);
        if (shell != null) {
            taskItem.setShell(shell);
        }
        return taskItem;
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] taskItemArray = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, taskItemArray, 0, taskItemArray.length);
        return taskItemArray;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                TaskItem taskItem = this.items[n];
                if (taskItem != null && !taskItem.isDisposed()) {
                    taskItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.display.taskBar == this) {
            this.display.taskBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.mTaskbarList3 != 0) {
            OS.VtblCall(2, this.mTaskbarList3);
            this.mTaskbarList3 = 0;
        }
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                TaskItem taskItem = this.items[n2];
                if (taskItem != null) {
                    taskItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    void setMenu(Menu menu) {
        int[] nArray = new int[1];
        int n = OS.CoCreateInstance(CLSID_DestinationList, 0, 1, IID_ICustomDestinationList, nArray);
        if (n != 0) {
            this.error(2);
        }
        int n2 = nArray[0];
        String string = Display.APP_NAME;
        char[] cArray = null;
        if (string != null) {
            int n3 = string.length();
            cArray = new char[n3 + 1];
            string.getChars(0, n3, cArray, 0);
        }
        MenuItem[] menuItemArray = null;
        if (menu != null && (menuItemArray = menu.getItems()).length != 0) {
            Object object;
            String string2 = null;
            int n4 = 0;
            while (n4 < menuItemArray.length) {
                object = menuItemArray[n4];
                if (((Item)object).getImage() != null && ((Widget)object).getData(ICON_KEY) == null) {
                    string2 = this.getDirectory(cArray);
                    break;
                }
                ++n4;
            }
            n4 = this.createShellLinkArray(menuItemArray, string2);
            if (n4 != 0) {
                n = OS.VtblCall(3, n2, cArray);
                if (n != 0) {
                    this.error(5);
                }
                object = new int[1];
                OS.VtblCall(4, n2, (int[])object, IID_IObjectArray, nArray);
                if (n != 0) {
                    this.error(5);
                }
                int n5 = nArray[0];
                int[] nArray2 = new int[1];
                OS.VtblCall(3, n4, nArray2);
                if (nArray2[0] != 0 && (n = OS.VtblCall(7, n2, n4)) != 0) {
                    this.error(5);
                }
                int n6 = 0;
                while (n6 < menuItemArray.length) {
                    Menu menu2;
                    MenuItem menuItem = menuItemArray[n6];
                    if ((menuItem.getStyle() & 0x40) != 0 && (menu2 = menuItem.getMenu()) != null) {
                        Object object2;
                        int n7;
                        MenuItem[] menuItemArray2 = menu2.getItems();
                        if (string2 == null) {
                            n7 = 0;
                            while (n7 < menuItemArray2.length) {
                                object2 = menuItemArray2[n7];
                                if (((Item)object2).getImage() != null && ((Widget)object2).getData(ICON_KEY) == null) {
                                    string2 = this.getDirectory(cArray);
                                    break;
                                }
                                ++n7;
                            }
                        }
                        if ((n7 = this.createShellLinkArray(menuItemArray2, string2)) != 0) {
                            OS.VtblCall(3, n7, nArray2);
                            if (nArray2[0] != 0) {
                                object2 = menuItem.getText();
                                int n8 = ((String)object2).length();
                                char[] cArray2 = new char[n8 + 1];
                                ((String)object2).getChars(0, n8, cArray2, 0);
                                n = OS.VtblCall(5, n2, cArray2, n7);
                                if (n != 0) {
                                    this.error(5);
                                }
                            }
                            OS.VtblCall(2, n7);
                        }
                    }
                    ++n6;
                }
                n = OS.VtblCall(8, n2);
                if (n != 0) {
                    this.error(5);
                }
                if (n5 != 0) {
                    OS.VtblCall(2, n5);
                }
                OS.VtblCall(2, n4);
            }
        } else {
            n = OS.VtblCall(10, n2, cArray);
            if (n != 0) {
                this.error(5);
            }
        }
        OS.VtblCall(2, n2);
    }
}

